# generated by datamodel-codegen:
#   filename:  entity/teams/role.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReferenceList


class Role(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: basic.Uuid
    name: basic.EntityName
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description="Name used for display purposes. Example 'Data Consumer'."
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the role.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    allowDelete: Annotated[
        Optional[bool], Field(None, description="Some system roles can't be deleted")
    ]
    allowEdit: Annotated[
        Optional[bool], Field(None, description="Some system roles can't be edited")
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    policies: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Policies that is attached to this role.'),
    ]
    users: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Users that have this role assigned to them.'),
    ]
    teams: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Teams that have this role assigned to them.'),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            None,
            description="System policy can't be deleted. Use this flag to disable them.",
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
