# generated by datamodel-codegen:
#   filename:  entity/teams/user.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...auth import basicAuth, jwtAuth, ssoAuth
from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    personaPreferences,
    profile,
)


class AuthType(Enum):
    JWT = 'JWT'
    SSO = 'SSO'
    BASIC = 'BASIC'


class AuthenticationMechanism(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[
            ssoAuth.SSOAuthMechanism,
            jwtAuth.JWTAuthMechanism,
            basicAuth.BasicAuthMechanism,
        ]
    ] = None
    authType: Optional[AuthType] = None


class User(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies a user entity instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(
            description='A unique name of the user, typically the user ID from an identity provider. Example - uid from LDAP.'
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Used for user biography.')
    ]
    externalId: Annotated[
        Optional[str],
        Field(
            None,
            description='External identifier from identity provider (used for SCIM).',
        ),
    ]
    scimUserName: Annotated[
        Optional[str], Field(None, description='Raw user name from SCIM.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'FirstName LastName'.",
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    email: Annotated[basic.Email, Field(description='Email address of the user.')]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    timezone: Annotated[Optional[str], Field(None, description='Timezone of the user.')]
    isBot: Annotated[
        Optional[bool],
        Field(
            False, description='When true indicates a special type of user called Bot.'
        ),
    ]
    isAdmin: Annotated[
        Optional[bool],
        Field(
            False,
            description='When true indicates user is an administrator for the system with superuser privileges.',
        ),
    ]
    authenticationMechanism: Optional[AuthenticationMechanism] = None
    profile: Annotated[
        Optional[profile.Profile], Field(None, description='Profile of the user.')
    ]
    teams: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Teams that the user belongs to.'),
    ]
    defaultPersona: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Default Persona for the user from list of personas.'),
    ]
    personas: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Personas that the user assigned to.'),
    ]
    owns: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of entities owned by the user.'),
    ]
    follows: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of entities followed by the user.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    roles: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Roles that the user has been assigned.'),
    ]
    inheritedRoles: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Roles that a user is inheriting through membership in teams that have set team default roles.',
        ),
    ]
    isEmailVerified: Annotated[
        Optional[bool], Field(None, description='If the User has verified the mail')
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domain the User belongs to. This is inherited by the team the user belongs to.',
        ),
    ]
    lastLoginTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Last time the user logged in.'),
    ]
    lastActivityTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Last time the user was active in the system.'),
    ]
    personaPreferences: Annotated[
        Optional[List[personaPreferences.PersonaPreferences]],
        Field(
            [],
            description="User's personal preferences for each persona. Users can customize certain UI elements per persona while inheriting base persona configuration.",
        ),
    ]
