# generated by datamodel-codegen:
#   filename:  events/eventFilterRule.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic


class InputType(Enum):
    static = 'static'
    runtime = 'runtime'
    none = 'none'


class Effect(Enum):
    include = 'include'
    exclude = 'exclude'


class PrefixCondition(Enum):
    AND = 'AND'
    OR = 'OR'


class EventFilterRule(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        Optional[str], Field(None, description='Name of this Event Filter.')
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name of the Filter.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='FullyQualifiedName in the form `eventSubscription.eventFilterRuleName`.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Event Filter Rule.'),
    ]
    effect: Effect
    condition: Annotated[
        basic.Expression,
        Field(
            description='Expression in SpEL used for matching of a `Rule` based on entity, resource, and environmental attributes.'
        ),
    ]
    arguments: Annotated[
        Optional[List[str]], Field(None, description='Arguments to the Condition.')
    ]
    inputType: Optional[InputType] = None
    prefixCondition: Annotated[
        Optional[PrefixCondition],
        Field(
            PrefixCondition.AND,
            description='Prefix Condition to be applied to the Condition.',
        ),
    ]
