# generated by datamodel-codegen:
#   filename:  jobs/backgroundJob.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic
from . import enumCleanupArgs


class JobType(Enum):
    CUSTOM_PROPERTY_ENUM_CLEANUP = 'CUSTOM_PROPERTY_ENUM_CLEANUP'
    DELETE_ENTITY = 'DELETE_ENTITY'
    DELETE_TOKEN = 'DELETE_TOKEN'


class Status(Enum):
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    RUNNING = 'RUNNING'
    PENDING = 'PENDING'


class BackgroundJob(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Any,
        Field(
            description='Unique identifier for the job. This field is auto-incremented.'
        ),
    ]
    jobType: Annotated[JobType, Field(description='Type of the job.')]
    methodName: Annotated[
        str,
        Field(
            description='JobHandler name of the method that will be executed for this job.'
        ),
    ]
    jobArgs: Annotated[
        Union[enumCleanupArgs.EnumCleanupArgs, Dict[str, Any]],
        Field(description='Object containing job arguments.'),
    ]
    runAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp when the job was run in Unix epoch time milliseconds (default: as soon as possible).',
        ),
    ]
    status: Annotated[Status, Field(description='Current status of the job.')]
    createdBy: Annotated[
        str, Field(description='User or Bot who triggered the background job.')
    ]
    createdAt: Annotated[
        basic.Timestamp,
        Field(
            description='Timestamp when the job was created in Unix epoch time milliseconds.'
        ),
    ]
    updatedAt: Annotated[
        basic.Timestamp,
        Field(
            description='Time when job was last updated in Unix epoch time milliseconds.'
        ),
    ]
