# generated by datamodel-codegen:
#   filename:  metadataIngestion/dashboardServiceMetadataPipeline.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class LineageInformation(BaseModel):
    dbServicePrefixes: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of service path prefixes for lineage matching. Supported formats: DBServiceName, DBServiceName.DatabaseName, DBServiceName.DatabaseName.SchemaName, or DBServiceName.DatabaseName.SchemaName.TableName',
            title='Database Service Prefixes',
        ),
    ]


class DashboardMetadataConfigType(Enum):
    DashboardMetadata = 'DashboardMetadata'


class DashboardServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DashboardMetadataConfigType],
        Field(
            DashboardMetadataConfigType.DashboardMetadata, description='Pipeline type'
        ),
    ]
    lineageInformation: Annotated[
        Optional[LineageInformation],
        Field(
            None,
            description='Details required to generate Lineage',
            title='Lineage Information',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Project Filter Pattern',
        ),
    ]
    includeOwners: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enabling a flag will replace the current owner with a new owner from the source during metadata ingestion, if the current owner is null. It is recommended to keep the flag enabled to obtain the owner information during the first metadata ingestion.',
            title='Include Current Owners',
        ),
    ]
    markDeletedDashboards: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete dashboards in OpenMetadata if the source dashboards are deleted. Also, if the dashboard is deleted, all the associated entities like lineage, etc., with that dashboard will be deleted',
            title='Mark Deleted Dashboards',
        ),
    ]
    markDeletedDataModels: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete data models in OpenMetadata if the source data models are deleted. Also, if the data models is deleted, all the associated entities like lineage, etc., with that data models will be deleted',
            title='Mark Deleted Data Models',
        ),
    ]
    includeTags: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the tags ingestion.',
            title='Include Tags',
        ),
    ]
    includeDataModels: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the ingestion of data models.',
            title='Include Data Models',
        ),
    ]
    includeDraftDashboard: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional Configuration to include/exclude draft dashboards. By default it will include draft dashboards',
            title='Include Draft Dashboards',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
    overrideLineage: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Lineage' toggle to control whether to override the existing lineage.",
            title='Override Lineage',
        ),
    ]
