# generated by datamodel-codegen:
#   filename:  metadataIngestion/driveServiceMetadataPipeline.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class DriveMetadataConfigType(Enum):
    DriveMetadata = 'DriveMetadata'


class DriveServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DriveMetadataConfigType],
        Field(DriveMetadataConfigType.DriveMetadata, description='Pipeline type'),
    ]
    markDeletedDirectories: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete directories in OpenMetadata if the source directories are deleted. Also, if the directory is deleted, all the associated entities like files, spreadsheets, worksheets, lineage, etc., with that directory will be deleted',
            title='Mark Deleted Directories',
        ),
    ]
    markDeletedFiles: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete files in OpenMetadata if the source files are deleted. Also, if the file is deleted, all the associated entities like lineage, etc., with that file will be deleted',
            title='Mark Deleted Files',
        ),
    ]
    markDeletedSpreadsheets: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete spreadsheets in OpenMetadata if the source spreadsheets are deleted. Also, if the spreadsheet is deleted, all the associated entities like worksheets, lineage, etc., with that spreadsheet will be deleted',
            title='Mark Deleted Spreadsheets',
        ),
    ]
    markDeletedWorksheets: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete worksheets in OpenMetadata if the source worksheets are deleted. Also, if the worksheet is deleted, all the associated entities like lineage, etc., with that worksheet will be deleted',
            title='Mark Deleted Worksheets',
        ),
    ]
    includeDirectories: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for directories.',
            title='Include Directories',
        ),
    ]
    includeFiles: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for files.',
            title='Include Files',
        ),
    ]
    includeSpreadsheets: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for spreadsheets.',
            title='Include Spreadsheets',
        ),
    ]
    includeWorksheets: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for worksheets.',
            title='Include Worksheets',
        ),
    ]
    includeTags: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the tags ingestion.',
            title='Include Tags',
        ),
    ]
    includeOwners: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Include Owners' toggle to control whether to include owners to the ingested entity if the owner email matches with a user stored in the OM server as part of metadata ingestion. If the ingested entity already exists and has an owner, the owner will not be overwritten.",
            title='Include Owners',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
    useFqnForFiltering: Annotated[
        Optional[bool],
        Field(
            False,
            description='Regex will be applied on fully qualified name (e.g service_name.directory_name.file_name) instead of raw name (e.g. file_name)',
            title='Use FQN For Filtering',
        ),
    ]
    directoryFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude directories that matches the pattern.',
            title='Directory Filter Pattern',
        ),
    ]
    fileFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude files that matches the pattern.',
            title='File Filter Pattern',
        ),
    ]
    spreadsheetFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude spreadsheets that matches the pattern.',
            title='Spreadsheet Filter Pattern',
        ),
    ]
    worksheetFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude worksheets that matches the pattern.',
            title='Worksheet Filter Pattern',
        ),
    ]
    threads: Annotated[
        Optional[int],
        Field(
            1,
            description='Number of Threads to use in order to parallelize Drive ingestion.',
            title='Number of Threads',
        ),
    ]
