# generated by datamodel-codegen:
#   filename:  settings/settings.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..configuration import (
    assetCertificationSettings,
    authenticationConfiguration,
    authorizerConfiguration,
    elasticSearchConfiguration,
    entityRulesSettings,
    eventHandlerConfiguration,
    fernetConfiguration,
    jwtTokenConfiguration,
    lineageSettings,
    openMetadataBaseUrlConfiguration,
    pipelineServiceClientConfiguration,
    profilerConfiguration,
    searchSettings,
    slackAppConfiguration,
    taskNotificationConfiguration,
    workflowSettings,
)
from ..email import smtpSettings


class SettingType(Enum):
    authorizerConfiguration = 'authorizerConfiguration'
    authenticationConfiguration = 'authenticationConfiguration'
    jwtTokenConfiguration = 'jwtTokenConfiguration'
    elasticsearch = 'elasticsearch'
    eventHandlerConfiguration = 'eventHandlerConfiguration'
    airflowConfiguration = 'airflowConfiguration'
    fernetConfiguration = 'fernetConfiguration'
    slackEventPublishers = 'slackEventPublishers'
    secretsManagerConfiguration = 'secretsManagerConfiguration'
    sandboxModeEnabled = 'sandboxModeEnabled'
    slackChat = 'slackChat'
    emailConfiguration = 'emailConfiguration'
    openMetadataBaseUrlConfiguration = 'openMetadataBaseUrlConfiguration'
    customUiThemePreference = 'customUiThemePreference'
    loginConfiguration = 'loginConfiguration'
    slackAppConfiguration = 'slackAppConfiguration'
    slackBot = 'slackBot'
    slackInstaller = 'slackInstaller'
    slackState = 'slackState'
    profilerConfiguration = 'profilerConfiguration'
    searchSettings = 'searchSettings'
    assetCertificationSettings = 'assetCertificationSettings'
    lineageSettings = 'lineageSettings'
    workflowSettings = 'workflowSettings'
    entityRulesSettings = 'entityRulesSettings'
    scimConfiguration = 'scimConfiguration'


class Settings(BaseModel):
    config_type: Annotated[
        SettingType,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    config_value: Optional[
        Union[
            pipelineServiceClientConfiguration.PipelineServiceClientConfiguration,
            authenticationConfiguration.AuthenticationConfiguration,
            authorizerConfiguration.AuthorizerConfiguration,
            elasticSearchConfiguration.ElasticSearchConfiguration,
            eventHandlerConfiguration.EventHandlerConfiguration,
            fernetConfiguration.FernetConfiguration,
            jwtTokenConfiguration.JWTTokenConfiguration,
            taskNotificationConfiguration.TaskNotificationConfiguration,
            smtpSettings.SmtpSettings,
            openMetadataBaseUrlConfiguration.OpenMetadataBaseUrlConfiguration,
            slackAppConfiguration.SlackAppConfiguration,
            profilerConfiguration.ProfilerConfiguration,
            searchSettings.SearchSettings,
            assetCertificationSettings.AssetCertificationSettings,
            lineageSettings.LineageSettings,
            workflowSettings.WorkflowSettings,
            entityRulesSettings.EntityRuleSettings,
        ]
    ] = None
