# generated by datamodel-codegen:
#   filename:  type/entityLineage.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic, entityReference


class ColumnLineage(BaseModel):
    fromColumns: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='One or more source columns identified by fully qualified column name used by transformation function to create destination column.',
        ),
    ]
    toColumn: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Destination column identified by fully qualified column name created by the transformation of source columns.',
        ),
    ]
    function: Annotated[
        Optional[basic.SqlFunction],
        Field(
            None,
            description='Transformation function applied to source columns to create destination column. That is `function(fromColumns) -> toColumn`.',
        ),
    ]


class Source(Enum):
    Manual = 'Manual'
    ViewLineage = 'ViewLineage'
    QueryLineage = 'QueryLineage'
    PipelineLineage = 'PipelineLineage'
    DashboardLineage = 'DashboardLineage'
    DbtLineage = 'DbtLineage'
    SparkLineage = 'SparkLineage'
    OpenLineage = 'OpenLineage'
    ExternalTableLineage = 'ExternalTableLineage'
    CrossDatabaseLineage = 'CrossDatabaseLineage'
    ChildAssets = 'ChildAssets'


class LineageDetails(BaseModel):
    sqlQuery: Annotated[
        Optional[basic.SqlQuery],
        Field(None, description='SQL used for transformation.'),
    ]
    columnsLineage: Annotated[
        Optional[List[ColumnLineage]],
        Field(
            None,
            description='Lineage information of how upstream columns were combined to get downstream column.',
        ),
    ]
    pipeline: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Pipeline where the sqlQuery is periodically run.'),
    ]
    description: Annotated[
        Optional[str], Field(None, description='description of lineage')
    ]
    source: Annotated[
        Optional[Source],
        Field(
            Source.Manual,
            description='Lineage type describes how a lineage was created.',
        ),
    ]
    createdAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    createdBy: Annotated[
        Optional[str], Field(None, description='User who created the node.')
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    assetEdges: Annotated[
        Optional[int],
        Field(None, description='Asset count in case of child assets lineage.'),
    ]


class Edge(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fromEntity: Annotated[
        basic.Uuid, Field(description='From entity that is upstream of lineage edge.')
    ]
    toEntity: Annotated[
        basic.Uuid, Field(description='To entity that is downstream of lineage edge.')
    ]
    description: Optional[basic.Markdown] = None
    lineageDetails: Annotated[
        Optional[LineageDetails],
        Field(
            None,
            description='Optional lineageDetails provided only for table to table lineage edge.',
        ),
    ]


class EntitiesEdge(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fromEntity: Annotated[
        entityReference.EntityReference,
        Field(description='From entity that is upstream of lineage edge.'),
    ]
    toEntity: Annotated[
        entityReference.EntityReference,
        Field(description='To entity that is downstream of lineage edge.'),
    ]
    description: Optional[basic.Markdown] = None
    lineageDetails: Annotated[
        Optional[LineageDetails],
        Field(
            None,
            description='Optional lineageDetails provided only for table to table lineage edge.',
        ),
    ]


class EntityLineage(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entity: Annotated[
        entityReference.EntityReference,
        Field(description='Primary entity for which this lineage graph is created.'),
    ]
    nodes: Optional[List[entityReference.EntityReference]] = None
    upstreamEdges: Optional[List[Edge]] = None
    downstreamEdges: Optional[List[Edge]] = None
