# Debian packaging tools.
#
# Author: Peter Odding <peter@peterodding.com>
# Last Change: February 5, 2020
# URL: https://github.com/xolox/python-deb-pkg-tools

"""Sphinx documentation configuration for the `deb-pkg-tools` project."""

import os
import sys

# Add the deb-pkg-tools source distribution's root directory to the module path.
sys.path.insert(0, os.path.abspath('..'))

# -- General configuration -----------------------------------------------------

# Sphinx extension module names.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'humanfriendly.sphinx',
]

# Paths that contain templates, relative to this directory.
templates_path = ['templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'deb-pkg-tools'
copyright = '2020, Peter Odding'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

# Find the package version and make it the release.
from deb_pkg_tools import __version__ as deb_pkg_tools_version  # NOQA

# The short X.Y version.
version = '.'.join(deb_pkg_tools_version.split('.')[:2])

# The full version, including alpha/beta/rc tags.
release = deb_pkg_tools_version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['build']

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# http://sphinx-doc.org/ext/autodoc.html#confval-autodoc_member_order
autodoc_member_order = 'bysource'

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# References to external documentation.
intersphinx_mapping = dict(
    executor=('https://executor.readthedocs.io/en/latest', None),
    humanfriendly=('https://humanfriendly.readthedocs.io/en/latest', None),
    propertymanager=('https://property-manager.readthedocs.io/en/latest', None),
    python2=('https://docs.python.org/2', None),
    python3=('https://docs.python.org/3', None),
)

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'nature'

# Output file base name for HTML help builder.
htmlhelp_basename = 'debpkgtoolsdoc'
