# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceSecurityMalwareArgs', 'ApplianceSecurityMalware']

@pulumi.input_type
class ApplianceSecurityMalwareArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 allowed_files: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]] = None,
                 allowed_urls: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplianceSecurityMalware resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]] allowed_files: Sha256 digests of files permitted by the malware detection engine
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]] allowed_urls: URLs permitted by the malware detection engine
        :param pulumi.Input[str] mode: Current status of malware prevention
        """
        pulumi.set(__self__, "network_id", network_id)
        if allowed_files is not None:
            pulumi.set(__self__, "allowed_files", allowed_files)
        if allowed_urls is not None:
            pulumi.set(__self__, "allowed_urls", allowed_urls)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="allowedFiles")
    def allowed_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]]:
        """
        Sha256 digests of files permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_files")

    @allowed_files.setter
    def allowed_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]]):
        pulumi.set(self, "allowed_files", value)

    @property
    @pulumi.getter(name="allowedUrls")
    def allowed_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]]:
        """
        URLs permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_urls")

    @allowed_urls.setter
    def allowed_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]]):
        pulumi.set(self, "allowed_urls", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of malware prevention
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class _ApplianceSecurityMalwareState:
    def __init__(__self__, *,
                 allowed_files: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]] = None,
                 allowed_urls: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplianceSecurityMalware resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]] allowed_files: Sha256 digests of files permitted by the malware detection engine
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]] allowed_urls: URLs permitted by the malware detection engine
        :param pulumi.Input[str] mode: Current status of malware prevention
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        if allowed_files is not None:
            pulumi.set(__self__, "allowed_files", allowed_files)
        if allowed_urls is not None:
            pulumi.set(__self__, "allowed_urls", allowed_urls)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="allowedFiles")
    def allowed_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]]:
        """
        Sha256 digests of files permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_files")

    @allowed_files.setter
    def allowed_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedFileArgs']]]]):
        pulumi.set(self, "allowed_files", value)

    @property
    @pulumi.getter(name="allowedUrls")
    def allowed_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]]:
        """
        URLs permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_urls")

    @allowed_urls.setter
    def allowed_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSecurityMalwareAllowedUrlArgs']]]]):
        pulumi.set(self, "allowed_urls", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of malware prevention
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)


class ApplianceSecurityMalware(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedFileArgs']]]]] = None,
                 allowed_urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedUrlArgs']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceSecurityMalware("example",
            allowed_files=[meraki.networks.ApplianceSecurityMalwareAllowedFileArgs(
                comment="allow ZIP file",
                sha256="e82c5f7d75004727e1f3b94426b9a11c8bc4c312a9170ac9a73abace40aef503",
            )],
            allowed_urls=[meraki.networks.ApplianceSecurityMalwareAllowedUrlArgs(
                comment="allow help.com.au",
                url="help.com.au",
            )],
            mode="enabled",
            network_id="string")
        pulumi.export("merakiNetworksApplianceSecurityMalwareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSecurityMalware:ApplianceSecurityMalware example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedFileArgs']]]] allowed_files: Sha256 digests of files permitted by the malware detection engine
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedUrlArgs']]]] allowed_urls: URLs permitted by the malware detection engine
        :param pulumi.Input[str] mode: Current status of malware prevention
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceSecurityMalwareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceSecurityMalware("example",
            allowed_files=[meraki.networks.ApplianceSecurityMalwareAllowedFileArgs(
                comment="allow ZIP file",
                sha256="e82c5f7d75004727e1f3b94426b9a11c8bc4c312a9170ac9a73abace40aef503",
            )],
            allowed_urls=[meraki.networks.ApplianceSecurityMalwareAllowedUrlArgs(
                comment="allow help.com.au",
                url="help.com.au",
            )],
            mode="enabled",
            network_id="string")
        pulumi.export("merakiNetworksApplianceSecurityMalwareExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSecurityMalware:ApplianceSecurityMalware example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceSecurityMalwareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceSecurityMalwareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedFileArgs']]]]] = None,
                 allowed_urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedUrlArgs']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceSecurityMalwareArgs.__new__(ApplianceSecurityMalwareArgs)

            __props__.__dict__["allowed_files"] = allowed_files
            __props__.__dict__["allowed_urls"] = allowed_urls
            __props__.__dict__["mode"] = mode
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(ApplianceSecurityMalware, __self__).__init__(
            'meraki:networks/applianceSecurityMalware:ApplianceSecurityMalware',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_files: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedFileArgs']]]]] = None,
            allowed_urls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedUrlArgs']]]]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None) -> 'ApplianceSecurityMalware':
        """
        Get an existing ApplianceSecurityMalware resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedFileArgs']]]] allowed_files: Sha256 digests of files permitted by the malware detection engine
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplianceSecurityMalwareAllowedUrlArgs']]]] allowed_urls: URLs permitted by the malware detection engine
        :param pulumi.Input[str] mode: Current status of malware prevention
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceSecurityMalwareState.__new__(_ApplianceSecurityMalwareState)

        __props__.__dict__["allowed_files"] = allowed_files
        __props__.__dict__["allowed_urls"] = allowed_urls
        __props__.__dict__["mode"] = mode
        __props__.__dict__["network_id"] = network_id
        return ApplianceSecurityMalware(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedFiles")
    def allowed_files(self) -> pulumi.Output[Sequence['outputs.ApplianceSecurityMalwareAllowedFile']]:
        """
        Sha256 digests of files permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_files")

    @property
    @pulumi.getter(name="allowedUrls")
    def allowed_urls(self) -> pulumi.Output[Sequence['outputs.ApplianceSecurityMalwareAllowedUrl']]:
        """
        URLs permitted by the malware detection engine
        """
        return pulumi.get(self, "allowed_urls")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        Current status of malware prevention
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

