# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CellularGatewaySubnetPoolArgs', 'CellularGatewaySubnetPool']

@pulumi.input_type
class CellularGatewaySubnetPoolArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 cidr: Optional[pulumi.Input[str]] = None,
                 mask: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a CellularGatewaySubnetPool resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        :param pulumi.Input[int] mask: Mask used for the subnet of all MGs in  this network.
        """
        pulumi.set(__self__, "network_id", network_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[int]]:
        """
        Mask used for the subnet of all MGs in  this network.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mask", value)


@pulumi.input_type
class _CellularGatewaySubnetPoolState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 deployment_mode: Optional[pulumi.Input[str]] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewaySubnetPoolSubnetArgs']]]] = None):
        """
        Input properties used for looking up and filtering CellularGatewaySubnetPool resources.
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        :param pulumi.Input[int] mask: Mask used for the subnet of all MGs in  this network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if deployment_mode is not None:
            pulumi.set(__self__, "deployment_mode", deployment_mode)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="deploymentMode")
    def deployment_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_mode")

    @deployment_mode.setter
    def deployment_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_mode", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[int]]:
        """
        Mask used for the subnet of all MGs in  this network.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewaySubnetPoolSubnetArgs']]]]:
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewaySubnetPoolSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)


class CellularGatewaySubnetPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CellularGatewaySubnetPool("example",
            cidr="192.168.0.0/16",
            mask=24,
            network_id="string")
        pulumi.export("merakiNetworksCellularGatewaySubnetPoolExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cellularGatewaySubnetPool:CellularGatewaySubnetPool example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        :param pulumi.Input[int] mask: Mask used for the subnet of all MGs in  this network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularGatewaySubnetPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.CellularGatewaySubnetPool("example",
            cidr="192.168.0.0/16",
            mask=24,
            network_id="string")
        pulumi.export("merakiNetworksCellularGatewaySubnetPoolExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/cellularGatewaySubnetPool:CellularGatewaySubnetPool example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param CellularGatewaySubnetPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularGatewaySubnetPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 mask: Optional[pulumi.Input[int]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularGatewaySubnetPoolArgs.__new__(CellularGatewaySubnetPoolArgs)

            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["mask"] = mask
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["deployment_mode"] = None
            __props__.__dict__["subnets"] = None
        super(CellularGatewaySubnetPool, __self__).__init__(
            'meraki:networks/cellularGatewaySubnetPool:CellularGatewaySubnetPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            deployment_mode: Optional[pulumi.Input[str]] = None,
            mask: Optional[pulumi.Input[int]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewaySubnetPoolSubnetArgs']]]]] = None) -> 'CellularGatewaySubnetPool':
        """
        Get an existing CellularGatewaySubnetPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        :param pulumi.Input[int] mask: Mask used for the subnet of all MGs in  this network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularGatewaySubnetPoolState.__new__(_CellularGatewaySubnetPoolState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["deployment_mode"] = deployment_mode
        __props__.__dict__["mask"] = mask
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["subnets"] = subnets
        return CellularGatewaySubnetPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        CIDR of the pool of subnets. Each MG in this network will automatically pick a subnet from this pool.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="deploymentMode")
    def deployment_mode(self) -> pulumi.Output[str]:
        return pulumi.get(self, "deployment_mode")

    @property
    @pulumi.getter
    def mask(self) -> pulumi.Output[int]:
        """
        Mask used for the subnet of all MGs in  this network.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence['outputs.CellularGatewaySubnetPoolSubnet']]:
        return pulumi.get(self, "subnets")

