# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLicensesResult',
    'AwaitableGetLicensesResult',
    'get_licenses',
    'get_licenses_output',
]

@pulumi.output_type
class GetLicensesResult:
    """
    A collection of values returned by getLicenses.
    """
    def __init__(__self__, id=None, item=None, license_id=None, organization_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if license_id and not isinstance(license_id, str):
            raise TypeError("Expected argument 'license_id' to be a str")
        pulumi.set(__self__, "license_id", license_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetLicensesItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="licenseId")
    def license_id(self) -> str:
        """
        licenseId path parameter. License ID
        """
        return pulumi.get(self, "license_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")


class AwaitableGetLicensesResult(GetLicensesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLicensesResult(
            id=self.id,
            item=self.item,
            license_id=self.license_id,
            organization_id=self.organization_id)


def get_licenses(license_id: Optional[str] = None,
                 organization_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLicensesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_licenses(license_id="string",
        organization_id="string")
    pulumi.export("merakiOrganizationsLicensesExample", example.item)
    ```


    :param str license_id: licenseId path parameter. License ID
    :param str organization_id: organizationId path parameter. Organization ID
    """
    __args__ = dict()
    __args__['licenseId'] = license_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getLicenses:getLicenses', __args__, opts=opts, typ=GetLicensesResult).value

    return AwaitableGetLicensesResult(
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        license_id=pulumi.get(__ret__, 'license_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'))


@_utilities.lift_output_func(get_licenses)
def get_licenses_output(license_id: Optional[pulumi.Input[str]] = None,
                        organization_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLicensesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_licenses(license_id="string",
        organization_id="string")
    pulumi.export("merakiOrganizationsLicensesExample", example.item)
    ```


    :param str license_id: licenseId path parameter. License ID
    :param str organization_id: organizationId path parameter. Organization ID
    """
    ...
