"""Zowe Python Client SDK.

This program and the accompanying materials are made available under the terms of the
Eclipse Public License v2.0 which accompanies this distribution, and is available at

https://www.eclipse.org/legal/epl-v20.html

SPDX-License-Identifier: EPL-2.0

Copyright Contributors to the Zowe project.
"""
from zowe.core_for_zowe_sdk import SdkApi


class Zosmf(SdkApi):
    """
    Class used to represent the base z/OSMF API.

    Attributes
    ----------
    connection
        Connection object
    """

    def __init__(self, connection):
        """
        Construct a Zosmf object.

        Parameters
        ----------
        connection
            The z/OSMF connection object (generated by the ZoweSDK object)
        """
        super().__init__(connection, "/zosmf/info")

    def get_info(self):
        """Return a JSON response from the GET request to z/OSMF info endpoint.

        Returns
        -------
        json
            A JSON containing the z/OSMF Info REST API data
        """
        response_json = self.request_handler.perform_request(
            "GET", self.request_arguments
        )
        return response_json
