# Generated by Django 4.1.8 on 2023-04-21 08:27

import django_fsm
from django.db import migrations, models


def move_external_id_in_metadata(apps, schema):
    Activity = apps.get_model("wbcrm", "Activity")
    for activity in Activity.objects.filter(external_id__isnull=False):
        if activity.parent_activity:
            metadata = {"outlook": {"event_id": activity.external_id}}
        else:
            metadata = {"outlook": {"event_uid": activity.external_id}}
        activity.metadata = metadata
        activity.save()


class Migration(migrations.Migration):
    dependencies = [
        ("wbcrm", "0002_alter_activity_repeat_choice"),
    ]

    operations = [
        migrations.AddField(
            model_name="activity",
            name="exclude_from_propagation",
            field=models.BooleanField(
                default=False,
                help_text="If this is checked, changes will not be propagated on this activity.",
                verbose_name="Exclude occurrence from propagation?",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="metadata",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.RemoveField(
            model_name="activity",
            name="external_id",
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="participation_status",
            field=django_fsm.FSMField(
                choices=[
                    ("CANCELLED", "Cancelled"),
                    ("MAYBE", "Maybe"),
                    ("ATTENDS", "Attends"),
                    ("NOTRESPONDED", "Not Responded"),
                    ("ATTENDS_DIGITALLY", "Attends Digitally"),
                ],
                default="NOTRESPONDED",
                max_length=50,
                verbose_name="Participation Status",
            ),
        ),
        migrations.RenameField(
            model_name="activity",
            old_name="parent_activity",
            new_name="parent_occurrence",
        ),
    ]
