# Generated by Django 4.1.9 on 2023-07-05 16:48
import django.contrib.postgres.constraints
import django.contrib.postgres.fields.ranges
import django.db.models.deletion
import django_fsm
import mptt.fields
import wbcore.utils.strings
from django.conf import settings
from django.contrib.postgres.operations import BtreeGistExtension
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("directory", "0004_entry_is_draft_entry"),
        ("wbcrm", "0004_alter_activity_status"),
    ]

    operations = [
        BtreeGistExtension(),
        migrations.CreateModel(
            name="Account",
            fields=[
                ("reference_id", models.PositiveIntegerField(unique=True)),
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("is_active", models.BooleanField(default=True)),
                ("deletion_datetime", models.DateTimeField(blank=True, null=True)),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("PENDING", "Pending"), ("OPEN", "Open"), ("CLOSE", "Close")],
                        default="CLOSE",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                (
                    "is_terminal_account",
                    models.BooleanField(
                        default=False,
                        help_text="If true, sales or revenue can happen in this account",
                        verbose_name="Terminal Account",
                    ),
                ),
                (
                    "is_public",
                    models.BooleanField(
                        default=False,
                        help_text="If True, all internal users can access this account",
                        verbose_name="Public",
                    ),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="accounts",
                        to="directory.entry",
                        verbose_name="Owner",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="wbcrm.account",
                        verbose_name="Parent Account",
                    ),
                ),
            ],
            options={
                "verbose_name": "Account",
                "verbose_name_plural": "Accounts",
                "permissions": [("administrate_account", "Administrate Account")],
            },
            bases=(wbcore.utils.strings.ReferenceIDMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AccountRole",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("weighting", models.FloatField(default=1, verbose_name="Weight")),
                (
                    "is_hidden",
                    models.BooleanField(
                        default=False,
                        help_text="If True, this role is hidden and can be seen only by authorized people",
                        verbose_name="Hidden",
                    ),
                ),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="roles",
                        to="wbcrm.account",
                        verbose_name="Account",
                    ),
                ),
                (
                    "authorized_hidden_users",
                    models.ManyToManyField(
                        blank=True,
                        help_text="List of users that are allowed to see this hidden account role",
                        related_name="authorized_hidden_roles",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="authorized Hidden Users",
                    ),
                ),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="account_roles",
                        to="directory.entry",
                        verbose_name="Entry",
                    ),
                ),
            ],
            options={
                "verbose_name": "Account Role",
                "verbose_name_plural": "Account Roles",
            },
        ),
        migrations.CreateModel(
            name="AccountRoleType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=126, verbose_name="Title")),
                ("key", models.CharField(max_length=126, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="AccountRoleValidity",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("timespan", django.contrib.postgres.fields.ranges.DateRangeField(verbose_name="Timespan")),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="validity_set",
                        to="wbcrm.accountrole",
                        verbose_name="Account Role",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="accountrole",
            name="role_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="roles",
                to="wbcrm.accountroletype",
                verbose_name="Role Type",
            ),
        ),
        migrations.AddConstraint(
            model_name="accountrolevalidity",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("timespan", "&&"), ("role", "=")], name="exclude_overlapping_roles"
            ),
        ),
        migrations.AddConstraint(
            model_name="accountrole",
            constraint=models.UniqueConstraint(fields=("account", "entry"), name="unique_account_entry_relationship"),
        ),
    ]
