# Activities
A list of every activity saved in the database. Will be filtered by activities that happen in the timeframe from a month ago to one week in the future by default. Will be ordered by the date an activity was last edited.

## Workflow:
An activity can have one of five different states that can be switched between by clicking on the corresponding buttons. These are displayed in the context menu if you right click the list row or at the top of the instance.

![Activity Workflow](data:image/png;base64,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)


### Planned:
The initial status after creating a new activity. From here you can either cancel, finish or directly review the activity which creates a popup where you can write your review.

### Finished:
The activity's status after it is over. From here you can review the activity.

### Canceled:
After canceling the activity this is its status.

### Reviewed:
After review this is the final status of the activity.

## Columns:
Each column title has three lines on the right if you hover over it. Click on them to show options for that column. The second tab of the options menu will allow you to filter the column, the third to completely hide entire columns. Click on anywhere else on the column to order it, cycling between ascending, descending and no ordering. Hold shift while clicking to order multiple columns with individual weights.

### Type:
The type of the activity. Activity types can be added, edited and deleted by managers under CRM > Administration > Activity Types.

### Title:
The activity's name.

### Period:
The timeframe where the activity takes place.

### Participants:
A list of persons participating in the activity. Hover over a name to display more information.

### Companies:
A list of companies participating in the activity. Hover over a name to display more information.

### Groups:
A list of groups participating in the activity. Groups can consist of persons and companies which will all be automatically added to the activity's participants and companies fields. Groups can be added, edited and deleted under CRM > Administration > Groups.

### Edited:
The date at which the activity was last edited.

### Created:
The date at which the activity was originally created.

### Description:
A description of what the activity is about. Hover over it to display the full description.

### Review:
A written review of the activity which can be created by anyone who can see the activity.

### Latest Reviewer:
The last person who updated the activity's review. Hover over the name to display more details about him/her.

## Legend:
Click on a status in the legend to filter the list. Repeating activities have a special symbol to the left of their column.

## Filters:
Filters are accessed by clicking on the symbol in the top left corner of the window.

### Status:
Filter activities by a specific status they're in, smiliarly to what clicking on the legend does.

### Frequency:
Filter activities by if and how often an activity is repeated.

### Conference Room:
Filter activities by if they take place in the conference room.

### Clients of:
Display only activities involving clients of the selected person.

### Visibility:
Filter activities by their visibility: Public, private or confidential.

### Importance:
Filter activities by their importance. The default importance value for activities is "Low".

### Only Recent:
Display activities that happen in the timeframe from a month ago to one week in the future. Will be active by default.

## Search Field:
Typing in the search field allows to filter the activities by name, description and review.
