# -*- coding: utf-8 -*-
"""
Kotlin-specific code review checklist.
"""

CHECKLIST = """
## Kotlin 代码审查检查清单

### 代码风格和约定
- [ ] 代码是否遵循 Kotlin 官方编码规范
- [ ] 是否使用工具（如 ktlint、detekt）进行代码风格检查
- [ ] 格式化是否一致（缩进、空格、换行等）
- [ ] 命名是否符合 Kotlin 约定（驼峰命名法，常量使用大写）
- [ ] 是否避免了魔法数字和硬编码字符串
- [ ] 是否避免使用 !!（非空断言）操作符
- [ ] 注释是否清晰且及时更新
- [ ] 文件组织是否合理（每个文件一个类，相关功能分组）

### Kotlin 特性使用
- [ ] 是否恰当使用扩展函数和属性
- [ ] 是否有效利用 null 安全操作符（?、?.、?:、!!）
- [ ] 是否合理使用数据类（data class）
- [ ] 是否合理使用密封类（sealed class）
- [ ] 是否恰当使用伴生对象（companion object）
- [ ] 是否合理使用对象声明（object）
- [ ] 是否合理使用高阶函数和 lambda 表达式
- [ ] 是否恰当使用委托属性（properties delegation）

### 面向对象设计
- [ ] 类的设计是否遵循单一职责原则
- [ ] 是否恰当使用继承和接口
- [ ] 是否避免过度使用继承
- [ ] 是否合理使用抽象类和接口
- [ ] 是否给类和方法提供适当的可见性修饰符
- [ ] 构造函数设计是否合理
- [ ] 是否遵循开闭原则和其他 SOLID 原则
- [ ] 是否使用组合而非继承（适当情况下）

### 并发和异步编程
- [ ] 是否正确使用协程（coroutines）
- [ ] 是否合理使用挂起函数（suspend functions）
- [ ] 是否恰当处理协程的取消和异常
- [ ] 是否合理使用协程上下文（CoroutineContext）
- [ ] 是否合理选择适当的调度器（Dispatchers）
- [ ] 是否避免共享可变状态或正确保护它
- [ ] 是否考虑线程安全问题
- [ ] 是否使用了适当的并发原语（如 Mutex）

### Android 特定检查 (如适用)
- [ ] 是否正确管理生命周期
- [ ] 是否避免内存泄漏（如 Context 引用）
- [ ] UI 组件是否遵循 Material Design 原则
- [ ] 是否有效使用 ViewModel 和 LiveData
- [ ] 是否恰当使用 Android KTX 扩展
- [ ] 是否适当配置了线程（主线程/后台线程）
- [ ] 是否遵循官方 Android 架构指南
- [ ] 是否妥善处理配置更改和进程死亡

### 性能优化
- [ ] 是否避免了昂贵的操作（如在循环中创建对象）
- [ ] 集合操作是否高效（适当使用序列进行大量元素的处理）
- [ ] 是否避免了装箱和拆箱开销
- [ ] 是否优化了闭包和内联函数使用
- [ ] 是否避免在关键路径上分配过多对象
- [ ] 是否考虑了惰性初始化（lazy）以优化资源使用
- [ ] 是否合理缓存计算结果
- [ ] 是否使用了适当的数据结构和算法

### 依赖管理
- [ ] 依赖是否声明精确的版本
- [ ] 是否避免使用过时或不安全的依赖
- [ ] 是否最小化依赖数量
- [ ] 是否定期更新依赖以修复安全漏洞
- [ ] 是否处理了依赖冲突
- [ ] 是否区分了开发和生产依赖
- [ ] 是否使用适当的构建系统（Gradle）配置
- [ ] 是否合理组织和模块化项目结构

### 错误处理
- [ ] 是否使用了合适的错误处理策略
- [ ] 是否考虑使用 Result 类型代替异常
- [ ] 是否创建了自定义异常类型
- [ ] 是否在适当的级别捕获和处理异常
- [ ] 是否提供有意义的错误消息
- [ ] 是否处理了所有可能的错误情况
- [ ] 是否记录了关键异常
- [ ] try-catch 块是否尽可能小而聚焦

### 测试
- [ ] 单元测试是否充分且有意义
- [ ] 是否使用了适当的测试框架（JUnit、Mockito、MockK）
- [ ] 测试是否涵盖主要功能和边界条件
- [ ] UI 测试是否覆盖关键用户流程
- [ ] 测试代码组织是否清晰
- [ ] 测试是否避免了不必要的复杂性
- [ ] 是否进行了性能和内存使用测试（适用时）
- [ ] 测试是否快速且可靠（无随机失败）

### 文档
- [ ] 是否使用 KDoc 注释公共 API
- [ ] 是否有清晰的 README 和项目文档
- [ ] 是否记录了复杂逻辑
- [ ] 文档是否与代码同步更新
- [ ] 是否记录了性能注意事项和限制
- [ ] API 参数和返回值是否有文档说明
- [ ] 是否包含了示例代码或用例
- [ ] 是否维护了 CHANGELOG 记录
"""
