from cyberfusion.CoreApiClient import models

from cyberfusion.CoreApiClient.http import DtoResponse
from cyberfusion.CoreApiClient.interfaces import Resource


class Regions(Resource):
    def list_regions(
        self,
        *,
        page: int = 1,
        per_page: int = 0,
        include_filters: models.RegionsSearchRequest | None = None,
    ) -> DtoResponse[list[models.RegionResource]]:
        local_response = self.api_connector.send_or_fail(
            "GET",
            "/api/v1/regions",
            data=None,
            query_parameters={
                "page": page,
                "per_page": per_page,
            }
            | include_filters.dict(exclude_unset=True)
            if include_filters
            else None,
        )

        return DtoResponse.from_response(local_response, models.RegionResource)
