from cyberfusion.CoreApiClient import models

from cyberfusion.CoreApiClient.http import DtoResponse
from cyberfusion.CoreApiClient.interfaces import Resource


class Tombstones(Resource):
    def list_tombstones(
        self,
        *,
        page: int = 1,
        per_page: int = 0,
        include_filters: models.TombstonesSearchRequest | None = None,
    ) -> DtoResponse[list[models.TombstoneResource]]:
        local_response = self.api_connector.send_or_fail(
            "GET",
            "/api/v1/tombstones",
            data=None,
            query_parameters={
                "page": page,
                "per_page": per_page,
            }
            | include_filters.dict(exclude_unset=True)
            if include_filters
            else None,
        )

        return DtoResponse.from_response(local_response, models.TombstoneResource)
