/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.WrappedCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;

public class PhotoshopTiffReader
extends BaseTiffReader {
    public static final int IMAGE_SOURCE_DATA = 37724;
    public static final int PACKBITS = 1;
    public static final int ZIP = 3;
    private transient RandomAccessInputStream tag;
    private long[] layerOffset;
    private int[] compression;
    private int[][] channelOrder;
    private String[] layerNames;

    public PhotoshopTiffReader() {
        super("Adobe Photoshop TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        tp.setDoCaching(false);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(37724);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.getSeries() == 0) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int offsetIndex = 0;
        for (int i = 1; i < this.getSeries(); ++i) {
            offsetIndex += ((CoreMetadata)this.core.get((int)i)).sizeC;
        }
        this.tag.seek(this.layerOffset[offsetIndex]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.compression[this.getSeries() - 1] == 1 || this.compression[this.getSeries() - 1] == 3) {
            WrappedCodec codec = this.compression[this.getSeries() - 1] == 3 ? new ZlibCodec() : new PackbitsCodec();
            CodecOptions options = new CodecOptions();
            options.maxBytes = FormatTools.getPlaneSize(this) / this.getSizeC();
            ByteArrayHandle pix = new ByteArrayHandle();
            for (int c = 0; c < this.getSizeC(); ++c) {
                int index = this.channelOrder[this.getSeries() - 1][c];
                this.tag.seek(this.layerOffset[offsetIndex + index]);
                pix.write(codec.decompress(this.tag, options));
            }
            RandomAccessInputStream plane = new RandomAccessInputStream(pix);
            plane.seek(0L);
            this.readPlane(plane, x, y, w, h, buf);
            plane.close();
            pix = null;
        } else {
            this.readPlane(this.tag, x, y, w, h, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.tag != null) {
                this.tag.close();
            }
            this.tag = null;
            this.layerOffset = null;
            this.compression = null;
            this.layerNames = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Object sourceData = ((IFD)this.ifds.get(0)).getIFDValue(37724);
        byte[] b = null;
        if (sourceData instanceof byte[]) {
            b = (byte[])sourceData;
        } else if (sourceData instanceof TiffIFDEntry) {
            b = (byte[])this.tiffParser.getIFDValue((TiffIFDEntry)sourceData);
        }
        if (b == null) {
            return;
        }
        this.tag = new RandomAccessInputStream(b);
        this.tag.order(this.isLittleEndian());
        String checkString = this.tag.readCString();
        while (this.tag.getFilePointer() < this.tag.length() - 12L && this.tag.getFilePointer() > 0L) {
            String signature = this.tag.readString(4);
            String type = this.tag.readString(4);
            int length = this.tag.readInt();
            int skip = length % 4;
            if (skip != 0) {
                skip = 4 - skip;
            }
            if (type.equals("ryaL")) {
                int nLayers = Math.abs(this.tag.readShort());
                this.compression = new int[nLayers];
                this.layerNames = new String[nLayers];
                this.channelOrder = new int[nLayers][];
                int[][] dataSize = new int[nLayers][];
                int offsetCount = 0;
                for (int layer = 0; layer < nLayers; ++layer) {
                    int top = this.tag.readInt();
                    int left = this.tag.readInt();
                    int bottom = this.tag.readInt();
                    int right = this.tag.readInt();
                    CoreMetadata layerCore = new CoreMetadata();
                    layerCore = new CoreMetadata();
                    layerCore.sizeX = right - left;
                    layerCore.sizeY = bottom - top;
                    layerCore.pixelType = this.getPixelType();
                    layerCore.sizeC = this.tag.readShort();
                    layerCore.sizeZ = 1;
                    layerCore.sizeT = 1;
                    layerCore.imageCount = 1;
                    layerCore.rgb = this.isRGB();
                    layerCore.interleaved = this.isInterleaved();
                    layerCore.littleEndian = this.isLittleEndian();
                    layerCore.dimensionOrder = this.getDimensionOrder();
                    if (layerCore.sizeX == 0 || layerCore.sizeY == 0 || layerCore.sizeC > 1 && !this.isRGB()) {
                        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
                        this.core.clear();
                        this.core.add(ms0);
                        break;
                    }
                    offsetCount += layerCore.sizeC;
                    this.channelOrder[layer] = new int[layerCore.sizeC];
                    dataSize[layer] = new int[layerCore.sizeC];
                    for (int c = 0; c < layerCore.sizeC; ++c) {
                        int channelID = this.tag.readShort();
                        if (channelID < 0) {
                            channelID = layerCore.sizeC - 1;
                        }
                        this.channelOrder[layer][channelID] = c;
                        dataSize[layer][c] = this.tag.readInt();
                    }
                    this.tag.skipBytes(12);
                    int len = this.tag.readInt();
                    long fp = this.tag.getFilePointer();
                    int mask = this.tag.readInt();
                    if (mask != 0) {
                        this.tag.skipBytes(mask);
                    }
                    int blending = this.tag.readInt();
                    this.tag.skipBytes(blending);
                    int nameLength = this.tag.read();
                    int pad = nameLength % 4;
                    if (pad != 0) {
                        pad = 4 - pad;
                    }
                    this.layerNames[layer] = this.tag.readString(nameLength + pad);
                    this.layerNames[layer] = this.layerNames[layer].replaceAll("[^\\p{ASCII}]", "").trim();
                    if (this.layerNames[layer].length() == nameLength + pad && !this.layerNames[layer].equalsIgnoreCase("Layer " + layer + "M")) {
                        this.addGlobalMetaList("Layer name", this.layerNames[layer]);
                        this.core.add(layerCore);
                    }
                    this.tag.skipBytes((int)(fp + (long)len - this.tag.getFilePointer()));
                }
                nLayers = this.core.size() - 1;
                this.layerOffset = new long[offsetCount];
                int nextOffset = 0;
                for (int layer = 0; layer < nLayers; ++layer) {
                    for (int c = 0; c < ((CoreMetadata)this.core.get((int)(layer + 1))).sizeC; ++c) {
                        WrappedCodec codec;
                        long startFP = this.tag.getFilePointer();
                        this.compression[layer] = this.tag.readShort();
                        this.layerOffset[nextOffset] = this.tag.getFilePointer();
                        if (this.compression[layer] == 3) {
                            this.layerOffset[nextOffset] = this.tag.getFilePointer();
                            codec = new ZlibCodec();
                            ((ZlibCodec)codec).decompress(this.tag, null);
                        } else if (this.compression[layer] == 1) {
                            if (layer == 0) {
                                this.tag.skipBytes(1572);
                            } else {
                                this.tag.skipBytes(192);
                            }
                            this.layerOffset[nextOffset] = this.tag.getFilePointer();
                            codec = new PackbitsCodec();
                            CodecOptions options = new CodecOptions();
                            options.maxBytes = ((CoreMetadata)this.core.get((int)(layer + 1))).sizeX * ((CoreMetadata)this.core.get((int)(layer + 1))).sizeY;
                            ((PackbitsCodec)codec).decompress(this.tag, options);
                        }
                        this.tag.seek(startFP + (long)dataSize[layer][c]);
                        ++nextOffset;
                    }
                }
                continue;
            }
            this.tag.skipBytes(length + skip);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName("Merged", 0);
        if (this.layerNames != null) {
            int end = Math.min(this.getSeriesCount() - 1, this.layerNames.length);
            for (int layer = 0; layer < end; ++layer) {
                store.setImageName(this.layerNames[layer], layer + 1);
            }
        }
    }
}

