/*
 * Decompiled with CFR 0.152.
 */
package ome.metakit;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import ome.metakit.Column;
import ome.metakit.MetakitTools;

public class ColumnMap {
    private ArrayList values = new ArrayList();
    private Column col;
    private RandomAccessInputStream stream;
    private int rowCount;

    public ColumnMap(Column col, RandomAccessInputStream stream, int rowCount) {
        this.col = col;
        this.stream = stream;
        this.rowCount = rowCount;
        try {
            this.setup();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public ArrayList getValueList() {
        return this.values;
    }

    public Object[] getValues() {
        return this.values.toArray(new Object[this.values.size()]);
    }

    public boolean isFixedMap() {
        char type = this.col.getTypeString().charAt(0);
        return type != 'S' && type != 'B';
    }

    private void setup() throws IOException {
        if (this.isFixedMap()) {
            int ivecSize = MetakitTools.readBpInt(this.stream);
            if (ivecSize > 0) {
                int ivecPointer = MetakitTools.readBpInt(this.stream);
                long fp = this.stream.getFilePointer();
                this.stream.seek(ivecPointer);
                for (int i = 0; i < this.rowCount; ++i) {
                    this.values.add(this.readElement(ivecSize, i));
                }
                this.stream.seek(fp);
            } else {
                for (int i = 0; i < this.rowCount; ++i) {
                    this.values.add(null);
                }
            }
        } else {
            int i;
            int ivecSize = MetakitTools.readBpInt(this.stream);
            int ivecPointer = MetakitTools.readBpInt(this.stream);
            int mapIvecSize = MetakitTools.readBpInt(this.stream);
            int mapIvecPointer = MetakitTools.readBpInt(this.stream);
            int catalogIvecSize = MetakitTools.readBpInt(this.stream);
            int catalogIvecPointer = 0;
            if (catalogIvecSize > 0) {
                catalogIvecPointer = MetakitTools.readBpInt(this.stream);
            }
            long fp = this.stream.getFilePointer();
            this.stream.seek(mapIvecPointer);
            int[] byteCounts = new int[this.rowCount];
            int bits = mapIvecSize * 8 / this.rowCount;
            for (i = 0; i < this.rowCount; ++i) {
                byteCounts[i] = this.readBits(mapIvecSize, bits, i);
            }
            this.stream.seek(ivecPointer);
            for (i = 0; i < this.rowCount; ++i) {
                Object object;
                byte[] buf = new byte[byteCounts[i]];
                this.stream.read(buf);
                char type = this.col.getTypeString().charAt(0);
                if (type == 'B') {
                    object = buf;
                } else {
                    String string;
                    object = string;
                    string = new String(buf, "UTF-8");
                }
                this.values.add(object);
            }
            this.stream.seek(fp);
        }
    }

    private Object readElement(int vectorSize, int index) throws IOException {
        char type = this.col.getTypeString().charAt(0);
        switch (type) {
            case 'F': {
                return new Float(this.stream.readFloat());
            }
            case 'D': {
                return new Double(this.stream.readDouble());
            }
            case 'L': {
                return new Long(this.stream.readLong());
            }
            case 'I': {
                int bits = vectorSize * 8 / this.rowCount;
                switch (bits) {
                    case 1: {
                        return this.readBits(vectorSize, 1, index);
                    }
                    case 2: {
                        return this.readBits(vectorSize, 2, index);
                    }
                    case 4: {
                        return this.readBits(vectorSize, 4, index);
                    }
                    case 8: {
                        return new Integer(this.stream.read());
                    }
                    case 16: {
                        return new Integer(this.stream.readShort());
                    }
                    case 32: {
                        return new Integer(this.stream.readInt());
                    }
                }
                return new Integer(this.stream.readInt());
            }
        }
        return null;
    }

    private int readBits(int nBytes, int bits, int index) throws IOException {
        if (bits == 8) {
            return this.stream.read();
        }
        if (bits == 16) {
            return this.stream.readShort() & 0xFFFF;
        }
        if (bits >= 32) {
            return this.stream.readInt();
        }
        long fp = this.stream.getFilePointer();
        this.stream.skipBytes(index * bits / 8);
        int b = this.stream.read();
        int mask = (int)Math.pow(2.0, bits) - 1;
        int bitIndex = index % (8 / bits);
        int value = b & mask << bitIndex * bits;
        this.stream.seek(fp);
        return value >>= (8 - bitIndex * bits) % 8;
    }
}

