/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import net.jcip.annotations.Immutable;
import org.joda.time.Period;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDuration {
    private static final boolean debug = false;
    private String text;
    private CalendarPeriod.Field timeUnit;
    private boolean isBlank;
    private double value;

    static Period convertToPeriod(int value, String udunit) {
        if (udunit.endsWith("s")) {
            udunit = udunit.substring(0, udunit.length() - 1);
        }
        if (udunit.equals("msec")) {
            return Period.millis(value);
        }
        if (udunit.equals("sec")) {
            return Period.seconds(value);
        }
        if (udunit.equals("minute")) {
            return Period.minutes(value);
        }
        if (udunit.equals("hour") || udunit.equals("hr")) {
            return Period.hours(value);
        }
        if (udunit.equals("day")) {
            return Period.days(value);
        }
        if (udunit.equals("week")) {
            return Period.weeks(value);
        }
        if (udunit.equals("month")) {
            return Period.months(value);
        }
        if (udunit.equals("year")) {
            return Period.years(value);
        }
        throw new IllegalArgumentException("cant convert " + udunit + " to Joda Period");
    }

    public CalendarDuration(int value, CalendarPeriod.Field timeUnit) {
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public CalendarPeriod.Field getTimeUnit() {
        return this.timeUnit;
    }

    public static CalendarDuration fromUnitString(String unitString) {
        return new CalendarDuration(1, CalendarPeriod.fromUnitString(unitString));
    }

    public double getValue() {
        return this.value;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getText() {
        return this.text == null ? this.timeUnit.toString() : this.text;
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDuration that = (CalendarDuration)o;
        if (this.isBlank != that.isBlank) {
            return false;
        }
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        return this.timeUnit == that.timeUnit;
    }

    public int hashCode() {
        int result = this.timeUnit != null ? this.timeUnit.hashCode() : 0;
        result = 31 * result + (this.isBlank ? 1 : 0);
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    private static void test(String unit, String result) throws Exception {
        Period jp = CalendarDuration.convertToPeriod(1, unit);
        assert (jp != null);
        System.out.printf("%s == %s%n", unit, jp);
        assert (jp.toString().equals(result)) : jp.toString() + " != " + result;
    }

    public static void main(String[] args) throws Exception {
        CalendarDuration.test("sec", "PT1S");
        CalendarDuration.test("secs", "PT1S");
        CalendarDuration.test("minute", "PT1M");
        CalendarDuration.test("minutes", "PT1M");
        CalendarDuration.test("hour", "PT1H");
        CalendarDuration.test("hours", "PT1H");
        CalendarDuration.test("hr", "PT1H");
        CalendarDuration.test("day", "P1D");
        CalendarDuration.test("days", "P1D");
        CalendarDuration.test("week", "P7D");
        CalendarDuration.test("weeks", "P7D");
        CalendarDuration.test("month", "P1M");
        CalendarDuration.test("months", "P1M");
        CalendarDuration.test("year", "P1Y");
        CalendarDuration.test("years", "P1Y");
    }
}

