"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 Google Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Modifications Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

File-level comment for <code>ondewo/nlu/agent.proto</code>.

This file contains a single service <a href="#ondewo.nlu.Agents">Agents</a>.

The most important messages is <a href="#ondewo.nlu.Agent">Agent</a> and its most complicated field is <code>configs</code>.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import ondewo.nlu.common_pb2
import ondewo.nlu.intent_pb2
import ondewo.nlu.project_role_pb2
import ondewo.nlu.session_pb2
import ondewo.nlu.user_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AgentView:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AgentViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AgentView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AGENT_VIEW_UNSPECIFIED: _AgentView.ValueType  # 0
    """Unspecified agent view: the view is defined by the call:
    - CreateAgent: AGENT_VIEW_SHALLOW
    - UpdateAgent: AGENT_VIEW_SHALLOW
    - GetAgent: AGENT_VIEW_FULL
    - ListAgents: AGENT_VIEW_SHALLOW
    """
    AGENT_VIEW_FULL: _AgentView.ValueType  # 1
    """Full agent view: populate all the fields of the Agent message including configs."""
    AGENT_VIEW_SHALLOW: _AgentView.ValueType  # 2
    """Shallow agent view: populates all the fields except configs."""
    AGENT_VIEW_MINIMUM: _AgentView.ValueType  # 3
    """Minimum view including only agent UUID and agent display name"""

class AgentView(_AgentView, metaclass=_AgentViewEnumTypeWrapper):
    """Structure of agent view"""

AGENT_VIEW_UNSPECIFIED: AgentView.ValueType  # 0
"""Unspecified agent view: the view is defined by the call:
- CreateAgent: AGENT_VIEW_SHALLOW
- UpdateAgent: AGENT_VIEW_SHALLOW
- GetAgent: AGENT_VIEW_FULL
- ListAgents: AGENT_VIEW_SHALLOW
"""
AGENT_VIEW_FULL: AgentView.ValueType  # 1
"""Full agent view: populate all the fields of the Agent message including configs."""
AGENT_VIEW_SHALLOW: AgentView.ValueType  # 2
"""Shallow agent view: populates all the fields except configs."""
AGENT_VIEW_MINIMUM: AgentView.ValueType  # 3
"""Minimum view including only agent UUID and agent display name"""
global___AgentView = AgentView

class _InitiationProtocol:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InitiationProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InitiationProtocol.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AS_SOON_AS_POSSIBLE: _InitiationProtocol.ValueType  # 0
    """after cache successfully built and after each model trained the agent will be updated"""
    WHEN_TRAINED: _InitiationProtocol.ValueType  # 1
    """after cache successfully built and all the active models successfully trained"""
    NEVER: _InitiationProtocol.ValueType  # 2
    """do not initiate"""

class InitiationProtocol(_InitiationProtocol, metaclass=_InitiationProtocolEnumTypeWrapper):
    """Defines when to initiate newly created agent when training started"""

AS_SOON_AS_POSSIBLE: InitiationProtocol.ValueType  # 0
"""after cache successfully built and after each model trained the agent will be updated"""
WHEN_TRAINED: InitiationProtocol.ValueType  # 1
"""after cache successfully built and all the active models successfully trained"""
NEVER: InitiationProtocol.ValueType  # 2
"""do not initiate"""
global___InitiationProtocol = InitiationProtocol

class _ReportType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReportTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReportType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ALL: _ReportType.ValueType  # 0
    """will return all reports as files of specified format compressed into a single zipfile"""
    INTENT_PER_LANGUAGE: _ReportType.ValueType  # 1
    """statistics of the language specific part of the intent database"""
    ENTITY_PER_LANGUAGE: _ReportType.ValueType  # 2
    """statistics of the language specific part of the entity database"""
    ENTITY_COLLISION: _ReportType.ValueType  # 3
    """report on collision of the entity synonyms"""
    INTENT_GENERAL: _ReportType.ValueType  # 4
    """report of statistics of the general (relevant to all supported languages) part of intent database"""

class ReportType(_ReportType, metaclass=_ReportTypeEnumTypeWrapper):
    """Type of reports about the domain of the agent"""

ALL: ReportType.ValueType  # 0
"""will return all reports as files of specified format compressed into a single zipfile"""
INTENT_PER_LANGUAGE: ReportType.ValueType  # 1
"""statistics of the language specific part of the intent database"""
ENTITY_PER_LANGUAGE: ReportType.ValueType  # 2
"""statistics of the language specific part of the entity database"""
ENTITY_COLLISION: ReportType.ValueType  # 3
"""report on collision of the entity synonyms"""
INTENT_GENERAL: ReportType.ValueType  # 4
"""report of statistics of the general (relevant to all supported languages) part of intent database"""
global___ReportType = ReportType

class _SessionsReportType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SessionsReportTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SessionsReportType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SESSIONS: _SessionsReportType.ValueType  # 0
    """report on sessions. Supports SessionFilter to filter"""
    SESSION_STEPS: _SessionsReportType.ValueType  # 1
    """report on session steps. Supports SessionFilter to filter"""
    SESSION_TOP_X_INTENTS: _SessionsReportType.ValueType  # 2
    """report top x detected intents in session. Supports SessionFilter to filter"""
    SESSION_TOP_X_ENTITY_TYPES: _SessionsReportType.ValueType  # 3
    """report top x detected entity types. Supports SessionFilter to filter"""
    SESSION_TOP_X_ENTITY_VALUES: _SessionsReportType.ValueType  # 4
    """report top x detected entity values Supports SessionFilter to filter"""
    SESSION_TOP_X_USERS: _SessionsReportType.ValueType  # 5
    """report top x users. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
    SESSION_TOP_X_LABELS: _SessionsReportType.ValueType  # 6
    """report top x labels. Supports SessionFilter to filter"""
    SESSION_TOP_X_TAGS: _SessionsReportType.ValueType  # 7
    """report top x tags. Supports SessionFilter to filter"""
    SESSION_TOP_X_PHONE_NUMBERS: _SessionsReportType.ValueType  # 8
    """report top x phone_numbers. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
    SESSION_HUMAN_HANDOVERS: _SessionsReportType.ValueType  # 9
    """report on human handovers. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
    SESSION_SQL_QUERY: _SessionsReportType.ValueType  # 10
    """report based on a query issued tables with session information.
    Requires to define <code>sql_query</code> in request.

    Allowed tables to query are:
    * session
    * session_context
    * session_step
    * session_step_context
    * session_step_detect_entity
    * session_step_detect_intent
    * session_step_detect_intent_context_in
    * session_step_detect_intent_context_out
    * session_step_detect_intent_context_out
    * session_step_detect_intent_label
    * session_step_detect_intent_tag

    Example:
      <code>SELECT ... FROM session</code>
      <code>SELECT ... FROM session, session_steps</code>
    """
    SESSION_LEAST_X_INTENTS: _SessionsReportType.ValueType  # 11
    """report least x detected intents in session. Supports SessionFilter to filter"""
    SESSION_LEAST_X_ENTITY_TYPES: _SessionsReportType.ValueType  # 12
    """report least x detected entity types. Supports SessionFilter to filter"""
    SESSION_LEAST_X_ENTITY_VALUES: _SessionsReportType.ValueType  # 13
    """report least x detected entity values Supports SessionFilter to filter"""
    SESSION_LEAST_X_USERS: _SessionsReportType.ValueType  # 14
    """report least x users. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
    SESSION_LEAST_X_LABELS: _SessionsReportType.ValueType  # 15
    """report least x labels. Supports SessionFilter to filter"""
    SESSION_LEAST_X_TAGS: _SessionsReportType.ValueType  # 16
    """report least x tags. Supports SessionFilter to filter"""
    TOTAL_STATISTICS: _SessionsReportType.ValueType  # 17
    """report total numbers of e.g. sessions, session steps, etc."""

class SessionsReportType(_SessionsReportType, metaclass=_SessionsReportTypeEnumTypeWrapper):
    """Type of reports about the domain of the agent"""

SESSIONS: SessionsReportType.ValueType  # 0
"""report on sessions. Supports SessionFilter to filter"""
SESSION_STEPS: SessionsReportType.ValueType  # 1
"""report on session steps. Supports SessionFilter to filter"""
SESSION_TOP_X_INTENTS: SessionsReportType.ValueType  # 2
"""report top x detected intents in session. Supports SessionFilter to filter"""
SESSION_TOP_X_ENTITY_TYPES: SessionsReportType.ValueType  # 3
"""report top x detected entity types. Supports SessionFilter to filter"""
SESSION_TOP_X_ENTITY_VALUES: SessionsReportType.ValueType  # 4
"""report top x detected entity values Supports SessionFilter to filter"""
SESSION_TOP_X_USERS: SessionsReportType.ValueType  # 5
"""report top x users. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
SESSION_TOP_X_LABELS: SessionsReportType.ValueType  # 6
"""report top x labels. Supports SessionFilter to filter"""
SESSION_TOP_X_TAGS: SessionsReportType.ValueType  # 7
"""report top x tags. Supports SessionFilter to filter"""
SESSION_TOP_X_PHONE_NUMBERS: SessionsReportType.ValueType  # 8
"""report top x phone_numbers. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
SESSION_HUMAN_HANDOVERS: SessionsReportType.ValueType  # 9
"""report on human handovers. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
SESSION_SQL_QUERY: SessionsReportType.ValueType  # 10
"""report based on a query issued tables with session information.
Requires to define <code>sql_query</code> in request.

Allowed tables to query are:
* session
* session_context
* session_step
* session_step_context
* session_step_detect_entity
* session_step_detect_intent
* session_step_detect_intent_context_in
* session_step_detect_intent_context_out
* session_step_detect_intent_context_out
* session_step_detect_intent_label
* session_step_detect_intent_tag

Example:
  <code>SELECT ... FROM session</code>
  <code>SELECT ... FROM session, session_steps</code>
"""
SESSION_LEAST_X_INTENTS: SessionsReportType.ValueType  # 11
"""report least x detected intents in session. Supports SessionFilter to filter"""
SESSION_LEAST_X_ENTITY_TYPES: SessionsReportType.ValueType  # 12
"""report least x detected entity types. Supports SessionFilter to filter"""
SESSION_LEAST_X_ENTITY_VALUES: SessionsReportType.ValueType  # 13
"""report least x detected entity values Supports SessionFilter to filter"""
SESSION_LEAST_X_USERS: SessionsReportType.ValueType  # 14
"""report least x users. Supports SessionFilter to filter (Coming soon! Not yet implemented)"""
SESSION_LEAST_X_LABELS: SessionsReportType.ValueType  # 15
"""report least x labels. Supports SessionFilter to filter"""
SESSION_LEAST_X_TAGS: SessionsReportType.ValueType  # 16
"""report least x tags. Supports SessionFilter to filter"""
TOTAL_STATISTICS: SessionsReportType.ValueType  # 17
"""report total numbers of e.g. sessions, session steps, etc."""
global___SessionsReportType = SessionsReportType

class _ReportFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReportFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReportFormat.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CSV: _ReportFormat.ValueType  # 0
    """CSV (comma separated values) file format"""
    HTML: _ReportFormat.ValueType  # 1
    """HTML file format"""
    JSON: _ReportFormat.ValueType  # 2
    """JSON file format"""

class ReportFormat(_ReportFormat, metaclass=_ReportFormatEnumTypeWrapper):
    """File formats for reports"""

CSV: ReportFormat.ValueType  # 0
"""CSV (comma separated values) file format"""
HTML: ReportFormat.ValueType  # 1
"""HTML file format"""
JSON: ReportFormat.ValueType  # 2
"""JSON file format"""
global___ReportFormat = ReportFormat

class _AgentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AgentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AgentStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACTIVE: _AgentStatus.ValueType  # 0
    """If project is active, all its endpoints are active"""
    INACTIVE: _AgentStatus.ValueType  # 1
    """If project is inactive:
    * members of the project do not see the project anymore except users with project role "PROJECT_ADMIN" and users with server role "SERVER_ADMIN"
    * nothing is allowed (no endpoint) on the project except "SetAgentStatus" by PROJECT_ADMIN or SERVER_ADMIN
    """

class AgentStatus(_AgentStatus, metaclass=_AgentStatusEnumTypeWrapper):
    """FIXME(arath): add endpoint to set agent owner

    Type of Agent / Project status
    """

ACTIVE: AgentStatus.ValueType  # 0
"""If project is active, all its endpoints are active"""
INACTIVE: AgentStatus.ValueType  # 1
"""If project is inactive:
* members of the project do not see the project anymore except users with project role "PROJECT_ADMIN" and users with server role "SERVER_ADMIN"
* nothing is allowed (no endpoint) on the project except "SetAgentStatus" by PROJECT_ADMIN or SERVER_ADMIN
"""
global___AgentStatus = AgentStatus

@typing_extensions.final
class Agent(google.protobuf.message.Message):
    """Project/Agent messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    DEFAULT_LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    TIME_ZONE_FIELD_NUMBER: builtins.int
    NLU_PLATFORM_FIELD_NUMBER: builtins.int
    CONFIGS_FIELD_NUMBER: builtins.int
    OWNER_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    Read-only in the Agent message
    """
    display_name: builtins.str
    """Required. The name of this agent."""
    default_language_code: builtins.str
    """Required. The default language of the agent as a language tag. See
    [Language Support](https://dialogflow.com/docs/reference/language) for a
    list of the currently supported language codes.
    This field cannot be set by the `Update` method.
    """
    @property
    def supported_language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The list of all languages supported by this agent (except for the
        `default_language_code`).
        """
    time_zone: builtins.str
    """Required. The time zone of this agent from the
    [time zone database](https://www.iana.org/time-zones), e.g.,
    America/New_York, Europe/Paris.
    """
    nlu_platform: builtins.str
    """Required. Specifies the format of the agent data."""
    @property
    def configs(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. Agent configuration as OndewoConfig converted to Struct format."""
    owner_id: builtins.str
    """Optional. User id of the project owner. If empty, in CreateAgent call it is set to user id in the call
    metadata.
    Read-only in the Agent message
    """
    status: global___AgentStatus.ValueType
    """Optional. Status of the agent
    Read-only in the Agent message
    """
    description: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        display_name: builtins.str = ...,
        default_language_code: builtins.str = ...,
        supported_language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        time_zone: builtins.str = ...,
        nlu_platform: builtins.str = ...,
        configs: google.protobuf.struct_pb2.Struct | None = ...,
        owner_id: builtins.str = ...,
        status: global___AgentStatus.ValueType = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["configs", b"configs", "created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["configs", b"configs", "created_at", b"created_at", "created_by", b"created_by", "default_language_code", b"default_language_code", "description", b"description", "display_name", b"display_name", "modified_at", b"modified_at", "modified_by", b"modified_by", "nlu_platform", b"nlu_platform", "owner_id", b"owner_id", "parent", b"parent", "status", b"status", "supported_language_codes", b"supported_language_codes", "time_zone", b"time_zone"]) -> None: ...

global___Agent = Agent

@typing_extensions.final
class AgentWithOwner(google.protobuf.message.Message):
    """This message contains the agent with owner"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent:
        """The agent"""
    @property
    def owner(self) -> ondewo.nlu.user_pb2.User:
        """User who created the agent"""
    def __init__(
        self,
        *,
        agent: global___Agent | None = ...,
        owner: ondewo.nlu.user_pb2.User | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "owner", b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "owner", b"owner"]) -> None: ...

global___AgentWithOwner = AgentWithOwner

@typing_extensions.final
class AgentOfUserWithOwner(google.protobuf.message.Message):
    """This message contains the agent of user with owner"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_WITH_OWNER_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_FIELD_NUMBER: builtins.int
    @property
    def agent_with_owner(self) -> global___AgentWithOwner:
        """Required. Agent message and User message of its owner."""
    @property
    def project_role(self) -> ondewo.nlu.project_role_pb2.ProjectRole:
        """Required. The role of the user in the project in SHALLOW view (only ID and name fields are populated)"""
    def __init__(
        self,
        *,
        agent_with_owner: global___AgentWithOwner | None = ...,
        project_role: ondewo.nlu.project_role_pb2.ProjectRole | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_with_owner", b"agent_with_owner", "project_role", b"project_role"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_with_owner", b"agent_with_owner", "project_role", b"project_role"]) -> None: ...

global___AgentOfUserWithOwner = AgentOfUserWithOwner

@typing_extensions.final
class CreateAgentRequest(google.protobuf.message.Message):
    """Request to create an agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent:
        """The agent"""
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (sparse view by default)"""
    def __init__(
        self,
        *,
        agent: global___Agent | None = ...,
        agent_view: global___AgentView.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_view", b"agent_view"]) -> None: ...

global___CreateAgentRequest = CreateAgentRequest

@typing_extensions.final
class UpdateAgentRequest(google.protobuf.message.Message):
    """Request to update the agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent:
        """The agent"""
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (sparse view by default)"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which fields get updated."""
    def __init__(
        self,
        *,
        agent: global___Agent | None = ...,
        agent_view: global___AgentView.ValueType = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_view", b"agent_view", "update_mask", b"update_mask"]) -> None: ...

global___UpdateAgentRequest = UpdateAgentRequest

@typing_extensions.final
class DeleteAgentRequest(google.protobuf.message.Message):
    """Request to delete the agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___DeleteAgentRequest = DeleteAgentRequest

@typing_extensions.final
class GetAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.GetAgent][google.cloud.dialogflow.v2.Agents.GetAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (full view by default)"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        agent_view: global___AgentView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view", b"agent_view", "parent", b"parent"]) -> None: ...

global___GetAgentRequest = GetAgentRequest

@typing_extensions.final
class ListAgentsRequest(google.protobuf.message.Message):
    """Request to get the list of agents"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SORT_BY_FIELD_FIELD_NUMBER: builtins.int
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (full view by default)"""
    page_token: builtins.str
    """Optional. The next_page_token value returned from a previous list request."""
    @property
    def sort_by_field(self) -> global___AgentSorting:
        """Optional. Defines the sorting of the list. Default, no sorting."""
    def __init__(
        self,
        *,
        agent_view: global___AgentView.ValueType = ...,
        page_token: builtins.str = ...,
        sort_by_field: global___AgentSorting | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["sort_by_field", b"sort_by_field"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view", b"agent_view", "page_token", b"page_token", "sort_by_field", b"sort_by_field"]) -> None: ...

global___ListAgentsRequest = ListAgentsRequest

@typing_extensions.final
class ListAgentsResponse(google.protobuf.message.Message):
    """Get list of agents"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENTS_WITH_OWNERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def agents_with_owners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AgentWithOwner]:
        """The list of agent and their owners. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """
    def __init__(
        self,
        *,
        agents_with_owners: collections.abc.Iterable[global___AgentWithOwner] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agents_with_owners", b"agents_with_owners", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAgentsResponse = ListAgentsResponse

@typing_extensions.final
class ListAgentsOfUserResponse(google.protobuf.message.Message):
    """Get list of agents of user"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENTS_OF_USER_WITH_OWNERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def agents_of_user_with_owners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AgentOfUserWithOwner]:
        """The list of agents with their owners of the given user. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """
    def __init__(
        self,
        *,
        agents_of_user_with_owners: collections.abc.Iterable[global___AgentOfUserWithOwner] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agents_of_user_with_owners", b"agents_of_user_with_owners", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAgentsOfUserResponse = ListAgentsOfUserResponse

@typing_extensions.final
class TrainAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    INITIATION_PROTOCOL_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    branch: builtins.str
    """Name of the branch of the agent for versioning. The default branch name is <code>develop</code>."""
    initiation_protocol: global___InitiationProtocol.ValueType
    """Defines when to initiate newly created agent when training started"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        branch: builtins.str = ...,
        initiation_protocol: global___InitiationProtocol.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "initiation_protocol", b"initiation_protocol", "parent", b"parent"]) -> None: ...

global___TrainAgentRequest = TrainAgentRequest

@typing_extensions.final
class BuildCacheRequest(google.protobuf.message.Message):
    """The request message for [Agents.TrainAgentBuildCache][google.cloud.dialogflow.v2.Agents.BuildCache]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to build cache is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    branch: builtins.str
    """Name of the branch of the agent for versioning. The default branch name is <code>develop</code>."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        branch: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "parent", b"parent"]) -> None: ...

global___BuildCacheRequest = BuildCacheRequest

@typing_extensions.final
class ExportAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    COMPRESSION_LEVEL_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to export is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    agent_uri: builtins.str
    """Optional. The Google Cloud Storage URI to export the agent to.
    Note: The URI must start with
    "gs://". If left unspecified, the serialized agent is returned inline.
    """
    compression_level: builtins.int
    """Optional. The compression level of the zip file created.
    Valid range 1-9; the grpc-default value 0 will be mapped to 1,
    other values cause an error in the request validation handler.
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        agent_uri: builtins.str = ...,
        compression_level: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_uri", b"agent_uri", "compression_level", b"compression_level", "parent", b"parent"]) -> None: ...

global___ExportAgentRequest = ExportAgentRequest

@typing_extensions.final
class ExportAgentResponse(google.protobuf.message.Message):
    """The response message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    agent_uri: builtins.str
    """The URI to a file containing the exported agent. This field is populated
    only if `agent_uri` is specified in `ExportAgentRequest`.
    """
    agent_content: builtins.bytes
    """The exported agent.

    Example for how to export an agent to a zip file via a command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:export'\\
      -X POST \\
      -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
      -H 'Accept: application/json' \\
      -H 'Content-Type: application/json' \\
      --compressed \\
      --data-binary '{}' \\
    | grep agentContent | sed -e 's/.*"agentContent": "\\([^"]*\\)".*/\\1/' \\
    | base64 --decode > <agent zip file>
    """
    def __init__(
        self,
        *,
        agent_uri: builtins.str = ...,
        agent_content: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent", b"agent"]) -> typing_extensions.Literal["agent_uri", "agent_content"] | None: ...

global___ExportAgentResponse = ExportAgentResponse

@typing_extensions.final
class ExportBenchmarkAgentRequest(google.protobuf.message.Message):
    """Request to export benchmark agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    COMPRESSION_LEVEL_FIELD_NUMBER: builtins.int
    TEST_SIZE_FIELD_NUMBER: builtins.int
    TRAIN_SIZE_FIELD_NUMBER: builtins.int
    RANDOM_STATE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Agent related info
    Required. The project that the agent to export is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    compression_level: builtins.int
    """Optional. The compression level of the zip file created.
    Valid range 1-9; the grpc-default value 0 will be mapped to 1,
    other values cause an error in the request validation handler.
    """
    test_size: builtins.float
    """Train-test split related parameters, for further info,
    check https://scikit-learn.org/stable/modules/generated/sklearn.model_selection.train_test_split.html
    default values come from API definition above
    Optional: bigger than zero
    """
    train_size: builtins.float
    """Optional: bigger than zero"""
    random_state: builtins.int
    """Optional: random seed"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        compression_level: builtins.int = ...,
        test_size: builtins.float = ...,
        train_size: builtins.float = ...,
        random_state: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["compression_level", b"compression_level", "parent", b"parent", "random_state", b"random_state", "test_size", b"test_size", "train_size", b"train_size"]) -> None: ...

global___ExportBenchmarkAgentRequest = ExportBenchmarkAgentRequest

@typing_extensions.final
class ExportBenchmarkAgentResponse(google.protobuf.message.Message):
    """Response to export benchmark agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TrainingPhrasesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    TRAINING_PHRASES_FIELD_NUMBER: builtins.int
    agent_content: builtins.bytes
    """Agent responses as zip file"""
    @property
    def training_phrases(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse]:
        """Key is the language code, value is the corresponding ListTrainingPhrasesResponse"""
    def __init__(
        self,
        *,
        agent_content: builtins.bytes = ...,
        training_phrases: collections.abc.Mapping[builtins.str, ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_content", b"agent_content", "training_phrases", b"training_phrases"]) -> None: ...

global___ExportBenchmarkAgentResponse = ExportBenchmarkAgentResponse

@typing_extensions.final
class OptimizeRankingMatchRequest(google.protobuf.message.Message):
    """This message is a request to run Optimize Ranking Match"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    OPTIMIZATION_CONFIGS_FIELD_NUMBER: builtins.int
    IN_PLACE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """languages that should be optimized"""
    @property
    def optimization_configs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RankingMatchOptimizationConfig]:
        """optimization config will contain all possible optimizations, with which we will come up in the future"""
    in_place: builtins.bool
    """if in_place is true then the config of the agent on the server will be updated, if False then config
    with optimized thresholds will be returned but not updated on the server
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        optimization_configs: collections.abc.Iterable[global___RankingMatchOptimizationConfig] | None = ...,
        in_place: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["in_place", b"in_place", "language_codes", b"language_codes", "optimization_configs", b"optimization_configs", "parent", b"parent"]) -> None: ...

global___OptimizeRankingMatchRequest = OptimizeRankingMatchRequest

@typing_extensions.final
class RankingMatchOptimizationConfig(google.protobuf.message.Message):
    """This message contains the configuration to run Optimize Ranking Match"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    N_SPLITS_FIELD_NUMBER: builtins.int
    RANDOM_SEED_FIELD_NUMBER: builtins.int
    INITIAL_THRESHOLDS_FIELD_NUMBER: builtins.int
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    n_splits: builtins.int
    """number of splits for optimization"""
    random_seed: builtins.int
    """random seed number for defining the split of train and test of training phrases for optimization"""
    @property
    def initial_thresholds(self) -> google.protobuf.struct_pb2.Struct:
        """initial thresholds are optional, if not given will be taken from the current config
        example {'OndewoIntentSimilarityMatch': 0.59, 'OndewoIntentNamedSimilarityMatch': 0.39}
        """
    def __init__(
        self,
        *,
        language_code: builtins.str = ...,
        n_splits: builtins.int = ...,
        random_seed: builtins.int = ...,
        initial_thresholds: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["initial_thresholds", b"initial_thresholds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["initial_thresholds", b"initial_thresholds", "language_code", b"language_code", "n_splits", b"n_splits", "random_seed", b"random_seed"]) -> None: ...

global___RankingMatchOptimizationConfig = RankingMatchOptimizationConfig

@typing_extensions.final
class OptimizeRankingMatchResponse(google.protobuf.message.Message):
    """This message is a response of Optimize Ranking Match"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIMIZATION_INFO_FIELD_NUMBER: builtins.int
    OPTIMIZED_ONDEWO_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def optimization_info(self) -> google.protobuf.struct_pb2.Struct:
        """info about optimization"""
    @property
    def optimized_ondewo_config(self) -> google.protobuf.struct_pb2.Struct:
        """the optimized configuration of the ondewo agent e.g., optimized parameters"""
    def __init__(
        self,
        *,
        optimization_info: google.protobuf.struct_pb2.Struct | None = ...,
        optimized_ondewo_config: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["optimization_info", b"optimization_info", "optimized_ondewo_config", b"optimized_ondewo_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["optimization_info", b"optimization_info", "optimized_ondewo_config", b"optimized_ondewo_config"]) -> None: ...

global___OptimizeRankingMatchResponse = OptimizeRankingMatchResponse

@typing_extensions.final
class ImportAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.ImportAgent][google.cloud.dialogflow.v2.Agents.ImportAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to import is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    agent_uri: builtins.str
    """The URI to a Google Cloud Storage file containing the agent to import.
    Note: The URI must start with "gs://".
    """
    agent_content: builtins.bytes
    """The agent to import.

    Example for how to import an agent via the command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:import\\
       -X POST \\
       -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
       -H 'Accept: application/json' \\
       -H 'Content-Type: application/json' \\
       --compressed \\
       --data-binary "{
          'agentContent': '$(cat <agent zip file> | base64 -w 0)'
       }"
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        agent_uri: builtins.str = ...,
        agent_content: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri", "parent", b"parent"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent", b"agent"]) -> typing_extensions.Literal["agent_uri", "agent_content"] | None: ...

global___ImportAgentRequest = ImportAgentRequest

@typing_extensions.final
class RestoreAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.RestoreAgent][google.cloud.dialogflow.v2.Agents.RestoreAgent]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to restore is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    agent_uri: builtins.str
    """The URI to a Google Cloud Storage file containing the agent to restore.
    Note: The URI must start with "gs://".
    """
    agent_content: builtins.bytes
    """The agent to restore.

    Example for how to restore an agent via the command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:restore\\
       -X POST \\
       -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
       -H 'Accept: application/json' \\
       -H 'Content-Type: application/json' \\
       --compressed \\
       --data-binary "{
           'agentContent': '$(cat <agent zip file> | base64 -w 0)'
       }" \\
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        agent_uri: builtins.str = ...,
        agent_content: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "agent_content", b"agent_content", "agent_uri", b"agent_uri", "parent", b"parent"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent", b"agent"]) -> typing_extensions.Literal["agent_uri", "agent_content"] | None: ...

global___RestoreAgentRequest = RestoreAgentRequest

@typing_extensions.final
class GetAgentStatisticsRequest(google.protobuf.message.Message):
    """Request statistics of the agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project to get statistics from.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    format: global___ReportFormat.ValueType
    """File formats for reports"""
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru
    the language to calculate statistics about
    """
    type: global___ReportType.ValueType
    """Type of reports about the domain of the agent"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        format: global___ReportFormat.ValueType = ...,
        language_code: builtins.str = ...,
        type: global___ReportType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format", b"format", "language_code", b"language_code", "parent", b"parent", "type", b"type"]) -> None: ...

global___GetAgentStatisticsRequest = GetAgentStatisticsRequest

@typing_extensions.final
class GetAgentStatisticsResponse(google.protobuf.message.Message):
    """Response to get statistics of the agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORTS_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    reports: builtins.bytes
    """Statistic info."""
    format: global___ReportFormat.ValueType
    """File formats for reports"""
    type: global___ReportType.ValueType
    """Type of reports about the domain of the agent"""
    def __init__(
        self,
        *,
        reports: builtins.bytes = ...,
        format: global___ReportFormat.ValueType = ...,
        type: global___ReportType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format", b"format", "reports", b"reports", "type", b"type"]) -> None: ...

global___GetAgentStatisticsResponse = GetAgentStatisticsResponse

@typing_extensions.final
class GetSessionsStatisticsRequest(google.protobuf.message.Message):
    """Request of the report of the statistics about sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    CONTEXT_FILTERS_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    GROUP_BYS_FIELD_NUMBER: builtins.int
    ORDER_BYS_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    SQL_QUERY_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project to get statistics from.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    format: global___ReportFormat.ValueType
    """File formats for reports"""
    type: global___SessionsReportType.ValueType
    """Type of reports about the domain of the agent"""
    @property
    def session_filter(self) -> ondewo.nlu.session_pb2.SessionFilter:
        """Optional. A filter to narrow reports based on sessions"""
    @property
    def context_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.session_pb2.ContextFilter]:
        """Optional. A filter to narrow reports based on contextual information (Coming soon! Not yet implemented)"""
    limit: builtins.int
    """Optional. limit the returned number of results"""
    @property
    def group_bys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. Grouping based on named properties"""
    @property
    def order_bys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. Order based on named properties"""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which data fields will be added to the returned data.
        Example: paths=["duration_in_s_min", "id", "session_id", "project_id"]
        """
    sql_query: builtins.str
    """SQL Query - only usable with specific SessionsReportType such as SessionsReportType.SESSION_SQL_QUERY"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        format: global___ReportFormat.ValueType = ...,
        type: global___SessionsReportType.ValueType = ...,
        session_filter: ondewo.nlu.session_pb2.SessionFilter | None = ...,
        context_filters: collections.abc.Iterable[ondewo.nlu.session_pb2.ContextFilter] | None = ...,
        limit: builtins.int = ...,
        group_bys: collections.abc.Iterable[builtins.str] | None = ...,
        order_bys: collections.abc.Iterable[builtins.str] | None = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        sql_query: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["context_filters", b"context_filters", "field_mask", b"field_mask", "format", b"format", "group_bys", b"group_bys", "limit", b"limit", "order_bys", b"order_bys", "parent", b"parent", "session_filter", b"session_filter", "sql_query", b"sql_query", "type", b"type"]) -> None: ...

global___GetSessionsStatisticsRequest = GetSessionsStatisticsRequest

@typing_extensions.final
class GetSessionsStatisticsResponse(google.protobuf.message.Message):
    """Report of the statistics about sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORTS_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    reports: builtins.bytes
    """Statistic info."""
    format: global___ReportFormat.ValueType
    """File formats for reports"""
    type: global___SessionsReportType.ValueType
    """Type of reports about the domain of the agent"""
    def __init__(
        self,
        *,
        reports: builtins.bytes = ...,
        format: global___ReportFormat.ValueType = ...,
        type: global___SessionsReportType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format", b"format", "reports", b"reports", "type", b"type"]) -> None: ...

global___GetSessionsStatisticsResponse = GetSessionsStatisticsResponse

@typing_extensions.final
class AddUserToProjectRequest(google.protobuf.message.Message):
    """Request to add user to project."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_ID_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    user_id: builtins.str
    """id of the user"""
    project_role_id: builtins.int
    """ID of the project role of the user"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        user_id: builtins.str = ...,
        project_role_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "project_role_id", b"project_role_id", "user_id", b"user_id"]) -> None: ...

global___AddUserToProjectRequest = AddUserToProjectRequest

@typing_extensions.final
class RemoveUserFromProjectRequest(google.protobuf.message.Message):
    """Request to remove user from the project."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    user_id: builtins.str
    """id of the user"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "user_id", b"user_id"]) -> None: ...

global___RemoveUserFromProjectRequest = RemoveUserFromProjectRequest

@typing_extensions.final
class ListUsersInProjectRequest(google.protobuf.message.Message):
    """Request to list users in the project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    page_token: builtins.str
    """Optional. The next_page_token value returned from a previous list request.
    The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token", "parent", b"parent"]) -> None: ...

global___ListUsersInProjectRequest = ListUsersInProjectRequest

@typing_extensions.final
class UserInProject(google.protobuf.message.Message):
    """Request to get user in project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to train is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    @property
    def user(self) -> ondewo.nlu.user_pb2.User:
        """User object"""
    role_id: builtins.int
    """ID of the project role of the user"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        user: ondewo.nlu.user_pb2.User | None = ...,
        role_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "role_id", b"role_id", "user", b"user"]) -> None: ...

global___UserInProject = UserInProject

@typing_extensions.final
class ListUsersInProjectResponse(google.protobuf.message.Message):
    """List the users in a project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserInProject]:
        """The list of users in a project. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """
    def __init__(
        self,
        *,
        users: collections.abc.Iterable[global___UserInProject] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "users", b"users"]) -> None: ...

global___ListUsersInProjectResponse = ListUsersInProjectResponse

@typing_extensions.final
class GetPlatformInfoResponse(google.protobuf.message.Message):
    """GIT information about the version of the server"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    COMMIT_HASH_FIELD_NUMBER: builtins.int
    version: builtins.str
    """version of the server build"""
    commit_hash: builtins.str
    """git commit hash of the server build"""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        commit_hash: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["commit_hash", b"commit_hash", "version", b"version"]) -> None: ...

global___GetPlatformInfoResponse = GetPlatformInfoResponse

@typing_extensions.final
class ListProjectPermissionsRequest(google.protobuf.message.Message):
    """Project permissions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_token: builtins.str
    """Optional. The next_page_token value returned from a previous list request.
    The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token"]) -> None: ...

global___ListProjectPermissionsRequest = ListProjectPermissionsRequest

@typing_extensions.final
class ListProjectPermissionsResponse(google.protobuf.message.Message):
    """List project permissions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of project permissions. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """
    def __init__(
        self,
        *,
        permissions: collections.abc.Iterable[builtins.str] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "permissions", b"permissions"]) -> None: ...

global___ListProjectPermissionsResponse = ListProjectPermissionsResponse

@typing_extensions.final
class SetAgentStatusRequest(google.protobuf.message.Message):
    """Request to set status of the agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of which to set the status.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    status: global___AgentStatus.ValueType
    """Required. Status of the agent"""
    agent_view: global___AgentView.ValueType
    """Optional. View of the returned agent"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        status: global___AgentStatus.ValueType = ...,
        agent_view: global___AgentView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view", b"agent_view", "parent", b"parent", "status", b"status"]) -> None: ...

global___SetAgentStatusRequest = SetAgentStatusRequest

@typing_extensions.final
class AgentSorting(google.protobuf.message.Message):
    """Sorting order of agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AgentSortingField:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AgentSortingFieldEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AgentSorting._AgentSortingField.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_AGENT_SORTING: AgentSorting._AgentSortingField.ValueType  # 0
        """no sorting"""
        SORT_AGENT_BY_NAME: AgentSorting._AgentSortingField.ValueType  # 1
        """sorting by name"""
        SORT_AGENT_BY_CREATION_DATE: AgentSorting._AgentSortingField.ValueType  # 2
        """sorting by creation date"""
        SORT_AGENT_BY_LAST_UPDATED: AgentSorting._AgentSortingField.ValueType  # 3
        """sorting by last updated date"""
        SORT_AGENT_BY_OWNER_NAME: AgentSorting._AgentSortingField.ValueType  # 4
        """sorting by owner, i.e. user who owns the agent which is usually the creator of the agent"""

    class AgentSortingField(_AgentSortingField, metaclass=_AgentSortingFieldEnumTypeWrapper):
        """Sorting field"""

    NO_AGENT_SORTING: AgentSorting.AgentSortingField.ValueType  # 0
    """no sorting"""
    SORT_AGENT_BY_NAME: AgentSorting.AgentSortingField.ValueType  # 1
    """sorting by name"""
    SORT_AGENT_BY_CREATION_DATE: AgentSorting.AgentSortingField.ValueType  # 2
    """sorting by creation date"""
    SORT_AGENT_BY_LAST_UPDATED: AgentSorting.AgentSortingField.ValueType  # 3
    """sorting by last updated date"""
    SORT_AGENT_BY_OWNER_NAME: AgentSorting.AgentSortingField.ValueType  # 4
    """sorting by owner, i.e. user who owns the agent which is usually the creator of the agent"""

    SORTING_FIELD_FIELD_NUMBER: builtins.int
    SORTING_MODE_FIELD_NUMBER: builtins.int
    sorting_field: global___AgentSorting.AgentSortingField.ValueType
    """sorting field for agent sorting"""
    sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType
    """Sorting mode"""
    def __init__(
        self,
        *,
        sorting_field: global___AgentSorting.AgentSortingField.ValueType = ...,
        sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sorting_field", b"sorting_field", "sorting_mode", b"sorting_mode"]) -> None: ...

global___AgentSorting = AgentSorting

@typing_extensions.final
class SetResourcesRequest(google.protobuf.message.Message):
    """Request to set resources"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_FILE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    name: builtins.str
    type: builtins.str
    resource_file: builtins.bytes
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
        resource_file: builtins.bytes = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "name", b"name", "parent", b"parent", "resource_file", b"resource_file", "type", b"type"]) -> None: ...

global___SetResourcesRequest = SetResourcesRequest

@typing_extensions.final
class DeleteResourcesRequest(google.protobuf.message.Message):
    """Request to delete resources"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    name: builtins.str
    type: builtins.str
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "name", b"name", "parent", b"parent", "type", b"type"]) -> None: ...

global___DeleteResourcesRequest = DeleteResourcesRequest

@typing_extensions.final
class ExportResourcesRequest(google.protobuf.message.Message):
    """Request to export resources"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    name: builtins.str
    type: builtins.str
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "name", b"name", "parent", b"parent", "type", b"type"]) -> None: ...

global___ExportResourcesRequest = ExportResourcesRequest

@typing_extensions.final
class ExportResourcesResponse(google.protobuf.message.Message):
    """Response to export resources"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    RESOURCE_FILE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    name: builtins.str
    type: builtins.str
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    resource_file: builtins.bytes
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
        language_code: builtins.str = ...,
        resource_file: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "name", b"name", "parent", b"parent", "resource_file", b"resource_file", "type", b"type"]) -> None: ...

global___ExportResourcesResponse = ExportResourcesResponse

@typing_extensions.final
class GetModelStatusesRequest(google.protobuf.message.Message):
    """Request to get model statuses"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    CACHE_VERSION_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    cache_version: builtins.int
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    model_name: builtins.str
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        cache_version: builtins.int = ...,
        language_code: builtins.str = ...,
        model_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_version", b"cache_version", "language_code", b"language_code", "model_name", b"model_name", "parent", b"parent"]) -> None: ...

global___GetModelStatusesRequest = GetModelStatusesRequest

@typing_extensions.final
class ModelStatus(google.protobuf.message.Message):
    """Status of model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _StatusName:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusNameEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelStatus._StatusName.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: ModelStatus._StatusName.ValueType  # 0
        INITIALIZING: ModelStatus._StatusName.ValueType  # 1
        INITIALIZED: ModelStatus._StatusName.ValueType  # 2
        LOADING_DATA: ModelStatus._StatusName.ValueType  # 3
        TRAINING: ModelStatus._StatusName.ValueType  # 4
        TESTING: ModelStatus._StatusName.ValueType  # 5
        TRAINED: ModelStatus._StatusName.ValueType  # 6

    class StatusName(_StatusName, metaclass=_StatusNameEnumTypeWrapper): ...
    UNKNOWN: ModelStatus.StatusName.ValueType  # 0
    INITIALIZING: ModelStatus.StatusName.ValueType  # 1
    INITIALIZED: ModelStatus.StatusName.ValueType  # 2
    LOADING_DATA: ModelStatus.StatusName.ValueType  # 3
    TRAINING: ModelStatus.StatusName.ValueType  # 4
    TESTING: ModelStatus.StatusName.ValueType  # 5
    TRAINED: ModelStatus.StatusName.ValueType  # 6

    CACHE_VERSION_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    STATUS_SET_TIME_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    cache_version: builtins.int
    """Cache version that contains the correspondent model"""
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    model_name: builtins.str
    """The model name"""
    @property
    def status_set_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    config: builtins.str
    status: global___ModelStatus.StatusName.ValueType
    def __init__(
        self,
        *,
        cache_version: builtins.int = ...,
        language_code: builtins.str = ...,
        model_name: builtins.str = ...,
        status_set_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        config: builtins.str = ...,
        status: global___ModelStatus.StatusName.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status_set_time", b"status_set_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_version", b"cache_version", "config", b"config", "language_code", b"language_code", "model_name", b"model_name", "status", b"status", "status_set_time", b"status_set_time"]) -> None: ...

global___ModelStatus = ModelStatus

@typing_extensions.final
class GetModelStatusesResponse(google.protobuf.message.Message):
    """Response to get model statuses"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_STATUSES_FIELD_NUMBER: builtins.int
    @property
    def model_statuses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelStatus]: ...
    def __init__(
        self,
        *,
        model_statuses: collections.abc.Iterable[global___ModelStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_statuses", b"model_statuses"]) -> None: ...

global___GetModelStatusesResponse = GetModelStatusesResponse

@typing_extensions.final
class CustomPlatformInfo(google.protobuf.message.Message):
    """This message contains the information of custom platform"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLATFORM_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    platform: ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType
    """Required. ID of the Platform.
    Custom Intent.Message.Platform placeholder. Note: it will not work with non-placeholders values
    """
    display_name: builtins.str
    """Required.
    Name to be displayed.
    """
    position: builtins.int
    """Optional.
    Sorting position of the GetPlatformMappingRequest.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        platform: ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType = ...,
        display_name: builtins.str = ...,
        position: builtins.int = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "display_name", b"display_name", "modified_at", b"modified_at", "modified_by", b"modified_by", "platform", b"platform", "position", b"position"]) -> None: ...

global___CustomPlatformInfo = CustomPlatformInfo

@typing_extensions.final
class GetPlatformMappingRequest(google.protobuf.message.Message):
    """Request to get platform mapping"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___GetPlatformMappingRequest = GetPlatformMappingRequest

@typing_extensions.final
class PlatformMapping(google.protobuf.message.Message):
    """This message contains the mapping of platform"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    PLATFORM_INFO_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def platform_info(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CustomPlatformInfo]:
        """Required. If not set, it will set it empty."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        platform_info: collections.abc.Iterable[global___CustomPlatformInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "platform_info", b"platform_info"]) -> None: ...

global___PlatformMapping = PlatformMapping

@typing_extensions.final
class FullTextSearchRequest(google.protobuf.message.Message):
    """This message is a request to run full text search"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _QueryType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _QueryTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FullTextSearchRequest._QueryType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALL: FullTextSearchRequest._QueryType.ValueType  # 0
        """just a placeholder, has to start with zero"""
        OndewoEntityQuery: FullTextSearchRequest._QueryType.ValueType  # 1
        OndewoEntityTypeQuery: FullTextSearchRequest._QueryType.ValueType  # 2
        OndewoEntitySynonymQuery: FullTextSearchRequest._QueryType.ValueType  # 3
        OndewoIntentQuery: FullTextSearchRequest._QueryType.ValueType  # 4
        OndewoIntentContextInQuery: FullTextSearchRequest._QueryType.ValueType  # 5
        OndewoIntentContextOutQuery: FullTextSearchRequest._QueryType.ValueType  # 6
        OndewoIntentUsersaysQuery: FullTextSearchRequest._QueryType.ValueType  # 7
        OndewoIntentTagsQuery: FullTextSearchRequest._QueryType.ValueType  # 8
        OndewoIntentParametersQuery: FullTextSearchRequest._QueryType.ValueType  # 9
        OndewoIntentResponseQuery: FullTextSearchRequest._QueryType.ValueType  # 10

    class QueryType(_QueryType, metaclass=_QueryTypeEnumTypeWrapper):
        """Type of query"""

    ALL: FullTextSearchRequest.QueryType.ValueType  # 0
    """just a placeholder, has to start with zero"""
    OndewoEntityQuery: FullTextSearchRequest.QueryType.ValueType  # 1
    OndewoEntityTypeQuery: FullTextSearchRequest.QueryType.ValueType  # 2
    OndewoEntitySynonymQuery: FullTextSearchRequest.QueryType.ValueType  # 3
    OndewoIntentQuery: FullTextSearchRequest.QueryType.ValueType  # 4
    OndewoIntentContextInQuery: FullTextSearchRequest.QueryType.ValueType  # 5
    OndewoIntentContextOutQuery: FullTextSearchRequest.QueryType.ValueType  # 6
    OndewoIntentUsersaysQuery: FullTextSearchRequest.QueryType.ValueType  # 7
    OndewoIntentTagsQuery: FullTextSearchRequest.QueryType.ValueType  # 8
    OndewoIntentParametersQuery: FullTextSearchRequest.QueryType.ValueType  # 9
    OndewoIntentResponseQuery: FullTextSearchRequest.QueryType.ValueType  # 10

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    term: builtins.str
    """What to search for in the elastic server"""
    page_token: builtins.str
    """Composite string: current_index-0--page_size-10
    The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        term: builtins.str = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "page_token", b"page_token", "parent", b"parent", "term", b"term"]) -> None: ...

global___FullTextSearchRequest = FullTextSearchRequest

@typing_extensions.final
class FullTextSearchResponseEntityType(google.protobuf.message.Message):
    """This message is a response of full text search of entity type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class EntityTypeSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        display_name: builtins.str
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            display_name: builtins.str = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "display_name", b"display_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def entity_type_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntityType.EntityTypeSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        entity_type_results: collections.abc.Iterable[global___FullTextSearchResponseEntityType.EntityTypeSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "entity_type_results", b"entity_type_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseEntityType = FullTextSearchResponseEntityType

@typing_extensions.final
class FullTextSearchResponseEntity(google.protobuf.message.Message):
    """This message is a response of full text search of entity"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class EntitySearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        display_name: builtins.str
        entity_type_name: builtins.str
        entity_type_display_name: builtins.str
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            display_name: builtins.str = ...,
            entity_type_name: builtins.str = ...,
            entity_type_display_name: builtins.str = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "display_name", b"display_name", "entity_type_display_name", b"entity_type_display_name", "entity_type_name", b"entity_type_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def entity_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntity.EntitySearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        entity_results: collections.abc.Iterable[global___FullTextSearchResponseEntity.EntitySearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "entity_results", b"entity_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseEntity = FullTextSearchResponseEntity

@typing_extensions.final
class FullTextSearchResponseEntitySynonym(google.protobuf.message.Message):
    """This message is a response of full text search of synonym entity"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class EntitySynonymSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        display_name: builtins.str
        entity_type_name: builtins.str
        entity_type_display_name: builtins.str
        entity_name: builtins.str
        entity_display_name: builtins.str
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            display_name: builtins.str = ...,
            entity_type_name: builtins.str = ...,
            entity_type_display_name: builtins.str = ...,
            entity_name: builtins.str = ...,
            entity_display_name: builtins.str = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "display_name", b"display_name", "entity_display_name", b"entity_display_name", "entity_name", b"entity_name", "entity_type_display_name", b"entity_type_display_name", "entity_type_name", b"entity_type_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_SYNONYM_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def entity_synonym_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntitySynonym.EntitySynonymSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        entity_synonym_results: collections.abc.Iterable[global___FullTextSearchResponseEntitySynonym.EntitySynonymSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "entity_synonym_results", b"entity_synonym_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseEntitySynonym = FullTextSearchResponseEntitySynonym

@typing_extensions.final
class FullTextSearchResponseIntent(google.protobuf.message.Message):
    """This message is a response of full text search of intent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        DOMAIN_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        display_name: builtins.str
        domain_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            display_name: builtins.str = ...,
            domain_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "display_name", b"display_name", "domain_name", b"domain_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "tags", b"tags"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntent.IntentSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_results: collections.abc.Iterable[global___FullTextSearchResponseIntent.IntentSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_results", b"intent_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntent = FullTextSearchResponseIntent

@typing_extensions.final
class FullTextSearchResponseIntentContextIn(google.protobuf.message.Message):
    """This message is a response of full text search of intent with context in"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentContextInSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "tags", b"tags"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_CONTEXT_IN_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_context_in_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentContextIn.IntentContextInSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_context_in_results: collections.abc.Iterable[global___FullTextSearchResponseIntentContextIn.IntentContextInSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_context_in_results", b"intent_context_in_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentContextIn = FullTextSearchResponseIntentContextIn

@typing_extensions.final
class FullTextSearchResponseIntentContextOut(google.protobuf.message.Message):
    """This message is a response of full text search of intent with context out"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentContextOutSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "tags", b"tags"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_CONTEXT_OUT_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_context_out_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentContextOut.IntentContextOutSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_context_out_results: collections.abc.Iterable[global___FullTextSearchResponseIntentContextOut.IntentContextOutSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_context_out_results", b"intent_context_out_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentContextOut = FullTextSearchResponseIntentContextOut

@typing_extensions.final
class FullTextSearchResponseIntentUsersays(google.protobuf.message.Message):
    """This message is a response of full text search of intent with sentence"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentUsersaysSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TEXT_FIELD_NUMBER: builtins.int
        TEXT_AS_ENTITY_TYPES_FIELD_NUMBER: builtins.int
        TEXT_AS_ENTITY_VALUES_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        text: builtins.str
        text_as_entity_types: builtins.str
        text_as_entity_values: builtins.str
        type: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            text: builtins.str = ...,
            text_as_entity_types: builtins.str = ...,
            text_as_entity_values: builtins.str = ...,
            type: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "tags", b"tags", "text", b"text", "text_as_entity_types", b"text_as_entity_types", "text_as_entity_values", b"text_as_entity_values", "type", b"type"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_USERSAYS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_usersays_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentUsersays.IntentUsersaysSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_usersays_results: collections.abc.Iterable[global___FullTextSearchResponseIntentUsersays.IntentUsersaysSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_usersays_results", b"intent_usersays_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentUsersays = FullTextSearchResponseIntentUsersays

@typing_extensions.final
class FullTextSearchResponseIntentTags(google.protobuf.message.Message):
    """This message is a response of full text search of intent with tags"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentTagsSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TEXT_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        name: builtins.str
        text: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            text: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "tags", b"tags", "text", b"text"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_TAGS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_tags_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentTags.IntentTagsSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_tags_results: collections.abc.Iterable[global___FullTextSearchResponseIntentTags.IntentTagsSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_tags_results", b"intent_tags_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentTags = FullTextSearchResponseIntentTags

@typing_extensions.final
class FullTextSearchResponseIntentResponse(google.protobuf.message.Message):
    """This message is a response of full text search of intent response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentResponseSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TEXT_FIELD_NUMBER: builtins.int
        PLATFORM_FIELD_NUMBER: builtins.int
        RESPONSE_TYPE_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        text: builtins.str
        platform: builtins.str
        response_type: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            text: builtins.str = ...,
            platform: builtins.str = ...,
            response_type: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "platform", b"platform", "response_type", b"response_type", "tags", b"tags", "text", b"text"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_RESPONSE_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_response_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentResponse.IntentResponseSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result.
    The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_response_results: collections.abc.Iterable[global___FullTextSearchResponseIntentResponse.IntentResponseSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_response_results", b"intent_response_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentResponse = FullTextSearchResponseIntentResponse

@typing_extensions.final
class FullTextSearchResponseIntentParameters(google.protobuf.message.Message):
    """This message is a response of full text search of intent with parameters"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IntentParametersSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PARAMETER_NAME_FIELD_NUMBER: builtins.int
        PARAMETER_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        CREATED_AT_FIELD_NUMBER: builtins.int
        MODIFIED_AT_FIELD_NUMBER: builtins.int
        CREATED_BY_FIELD_NUMBER: builtins.int
        MODIFIED_BY_FIELD_NUMBER: builtins.int
        parameter_name: builtins.str
        parameter_display_name: builtins.str
        intent_name: builtins.str
        intent_display_name: builtins.str
        @property
        def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        language: builtins.str
        @property
        def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Creation date and time. Read-only field."""
        @property
        def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Modification date and time. Read-only field."""
        created_by: builtins.str
        """User id in form of a valid UUID."""
        modified_by: builtins.str
        """User id in form of a valid UUID."""
        def __init__(
            self,
            *,
            parameter_name: builtins.str = ...,
            parameter_display_name: builtins.str = ...,
            intent_name: builtins.str = ...,
            intent_display_name: builtins.str = ...,
            tags: collections.abc.Iterable[builtins.str] | None = ...,
            language: builtins.str = ...,
            created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            created_by: builtins.str = ...,
            modified_by: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "parameter_display_name", b"parameter_display_name", "parameter_name", b"parameter_name", "tags", b"tags"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_PARAMETERS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    @property
    def intent_parameters_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentParameters.IntentParametersSearchResult]: ...
    term: builtins.str
    elastic_query: builtins.str
    time: builtins.float
    next_page_token: builtins.str
    """The next_page_token is used to retrieve the next page of a returned result, e.g. next_page_token is current_index-2"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_parameters_results: collections.abc.Iterable[global___FullTextSearchResponseIntentParameters.IntentParametersSearchResult] | None = ...,
        term: builtins.str = ...,
        elastic_query: builtins.str = ...,
        time: builtins.float = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query", b"elastic_query", "intent_parameters_results", b"intent_parameters_results", "language_code", b"language_code", "next_page_token", b"next_page_token", "parent", b"parent", "term", b"term", "time", b"time"]) -> None: ...

global___FullTextSearchResponseIntentParameters = FullTextSearchResponseIntentParameters

@typing_extensions.final
class ReindexAgentRequest(google.protobuf.message.Message):
    """This message is a request to reindex agent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_NAME_FIELD_NUMBER: builtins.int
    INDEX_TYPES_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    branch_name: builtins.str
    """Optional, useful for versioning reasons of the agent data"""
    @property
    def index_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FullTextSearchRequest.QueryType.ValueType]:
        """Optional, useful for reindexing specific indices in the future"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        branch_name: builtins.str = ...,
        index_types: collections.abc.Iterable[global___FullTextSearchRequest.QueryType.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_name", b"branch_name", "index_types", b"index_types", "parent", b"parent"]) -> None: ...

global___ReindexAgentRequest = ReindexAgentRequest
