"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ondewo.nlu.entity_type_pb2
import ondewo.nlu.intent_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Mode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Mode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSPECIFIED: _Mode.ValueType  # 0
    """default mode, described in agent config"""
    EXCLUSIVE: _Mode.ValueType  # 1
    """skip algorithms listed in `algorithms` field,"""
    INCLUSIVE: _Mode.ValueType  # 2
    """run ONLY algorithms listed in `algorithms` field"""

class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
    """Type of mode"""

UNSPECIFIED: Mode.ValueType  # 0
"""default mode, described in agent config"""
EXCLUSIVE: Mode.ValueType  # 1
"""skip algorithms listed in `algorithms` field,"""
INCLUSIVE: Mode.ValueType  # 2
"""run ONLY algorithms listed in `algorithms` field"""
global___Mode = Mode

class _IntentAlgorithms:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IntentAlgorithmsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IntentAlgorithms.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OndewoIntentExactContextDetector: _IntentAlgorithms.ValueType  # 0
    """By enabling this, a specific intent is triggered if the context and the intent name in the user says is
    matched. This can be used for directly triggering 'quick reply' button clicks confidence is always '1.0'.
    """
    OndewoIntentExactMatch: _IntentAlgorithms.ValueType  # 1
    """exact matching' of user input to user says is used to detect the intent. Confidence is always '1.0' if an
    'exact match' is found.
    """
    OndewoIntentNamedExactMatch: _IntentAlgorithms.ValueType  # 2
    """the entity synonym in the user says text is replaced by the entity and 'exact matching' of user says text
    is performed. Confidence is always '1.0'.
    """
    OndewoIntentSimilarityMatch: _IntentAlgorithms.ValueType  # 3
    """the algorithm computes the similarity of the user input to all user says of all intents."""
    OndewoIntentNamedSimilarityMatch: _IntentAlgorithms.ValueType  # 4
    """the entity synonyms in the user says are replaced by their Entity. Text similarity algorithms are then
    used to detect the intent.
    """
    OndewoIntentBertClassifier: _IntentAlgorithms.ValueType  # 7
    """new language representation model called BERT, which stands for Bidirectional Encoder Representations
    from Transformers.BERT is designed to pre-train deep bidirectional representations by jointly conditioning
    on both left and right context in all layers. As a result, the pre-trained BERT representations can be
    fine-tuned for multi-class intent detection. For details see https://arxiv.org/abs/1810.04805
    """
    OndewoIntentMetaClassifier: _IntentAlgorithms.ValueType  # 8
    IntentExitDetector: _IntentAlgorithms.ValueType  # 10
    """Maximum number of repeated fallbacks before this algorithm exists the conversation and resets contexts"""
    OndewoIntentRankingMatch: _IntentAlgorithms.ValueType  # 11
    """Algorithm to improve the interplay of the other algorithms"""
    OndewoWeightedEnsemble: _IntentAlgorithms.ValueType  # 13
    """Ensemble calculation of used algorithms"""
    OndewoIntentExitDetector: _IntentAlgorithms.ValueType  # 14
    """Maximum number of repeated fallbacks before this algorithm exists the conversation and resets contexts"""
    OndewoIntentParameterMatch: _IntentAlgorithms.ValueType  # 15
    """Matches the intent based on the parameter constellation and the current user context"""

class IntentAlgorithms(_IntentAlgorithms, metaclass=_IntentAlgorithmsEnumTypeWrapper):
    """Type of Intent algorithm."""

OndewoIntentExactContextDetector: IntentAlgorithms.ValueType  # 0
"""By enabling this, a specific intent is triggered if the context and the intent name in the user says is
matched. This can be used for directly triggering 'quick reply' button clicks confidence is always '1.0'.
"""
OndewoIntentExactMatch: IntentAlgorithms.ValueType  # 1
"""exact matching' of user input to user says is used to detect the intent. Confidence is always '1.0' if an
'exact match' is found.
"""
OndewoIntentNamedExactMatch: IntentAlgorithms.ValueType  # 2
"""the entity synonym in the user says text is replaced by the entity and 'exact matching' of user says text
is performed. Confidence is always '1.0'.
"""
OndewoIntentSimilarityMatch: IntentAlgorithms.ValueType  # 3
"""the algorithm computes the similarity of the user input to all user says of all intents."""
OndewoIntentNamedSimilarityMatch: IntentAlgorithms.ValueType  # 4
"""the entity synonyms in the user says are replaced by their Entity. Text similarity algorithms are then
used to detect the intent.
"""
OndewoIntentBertClassifier: IntentAlgorithms.ValueType  # 7
"""new language representation model called BERT, which stands for Bidirectional Encoder Representations
from Transformers.BERT is designed to pre-train deep bidirectional representations by jointly conditioning
on both left and right context in all layers. As a result, the pre-trained BERT representations can be
fine-tuned for multi-class intent detection. For details see https://arxiv.org/abs/1810.04805
"""
OndewoIntentMetaClassifier: IntentAlgorithms.ValueType  # 8
IntentExitDetector: IntentAlgorithms.ValueType  # 10
"""Maximum number of repeated fallbacks before this algorithm exists the conversation and resets contexts"""
OndewoIntentRankingMatch: IntentAlgorithms.ValueType  # 11
"""Algorithm to improve the interplay of the other algorithms"""
OndewoWeightedEnsemble: IntentAlgorithms.ValueType  # 13
"""Ensemble calculation of used algorithms"""
OndewoIntentExitDetector: IntentAlgorithms.ValueType  # 14
"""Maximum number of repeated fallbacks before this algorithm exists the conversation and resets contexts"""
OndewoIntentParameterMatch: IntentAlgorithms.ValueType  # 15
"""Matches the intent based on the parameter constellation and the current user context"""
global___IntentAlgorithms = IntentAlgorithms

@typing_extensions.final
class ExtractEntitiesRequest(google.protobuf.message.Message):
    """The request to detect parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_NAME_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    text: builtins.str
    """the input text"""
    language_code: builtins.str
    """the input language"""
    intent_name: builtins.str
    """Optional. The name of the relevant intent. Used to establish preference
    hierarchy for entities that correspond to intent parameters
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/intents/&lt;intent_uuid&gt;</code></pre>
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        text: builtins.str = ...,
        language_code: builtins.str = ...,
        intent_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["intent_name", b"intent_name", "language_code", b"language_code", "parent", b"parent", "text", b"text"]) -> None: ...

global___ExtractEntitiesRequest = ExtractEntitiesRequest

@typing_extensions.final
class ExtractEntitiesFuzzyRequest(google.protobuf.message.Message):
    """This message is a request to extract entities with Fuzzy Entity Recognizer"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    POTENTIAL_ENTITIES_FIELD_NUMBER: builtins.int
    MINIMAL_SCORE_FIELD_NUMBER: builtins.int
    ALLOW_OVERLAPS_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    text: builtins.str
    """The text to be analyzed"""
    @property
    def potential_entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EntityTypeFuzzyNerConfig]:
        """Potential entities to be extracted from the text with entity-specific configs"""
    minimal_score: builtins.float
    """Minimal similarity score to consider entity as "matched" """
    allow_overlaps: builtins.bool
    """Optional. Whether or not entities are allowed to overlap."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        text: builtins.str = ...,
        potential_entities: collections.abc.Iterable[global___EntityTypeFuzzyNerConfig] | None = ...,
        minimal_score: builtins.float = ...,
        allow_overlaps: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["allow_overlaps", b"allow_overlaps", "minimal_score", b"minimal_score", "parent", b"parent", "potential_entities", b"potential_entities", "text", b"text"]) -> None: ...

global___ExtractEntitiesFuzzyRequest = ExtractEntitiesFuzzyRequest

@typing_extensions.final
class EntityTypeFuzzyNerConfig(google.protobuf.message.Message):
    """Configuration for Fuzzy Entity Recognizer"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _FuzzyNerAlgorithm:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FuzzyNerAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[EntityTypeFuzzyNerConfig._FuzzyNerAlgorithm.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PREFILTER_LEVENSHTEIN: EntityTypeFuzzyNerConfig._FuzzyNerAlgorithm.ValueType  # 0
        """Levenshtein algorithm for fuzzy ner matching"""
        LOCAL_MAXIMUM: EntityTypeFuzzyNerConfig._FuzzyNerAlgorithm.ValueType  # 1
        """local maximum"""

    class FuzzyNerAlgorithm(_FuzzyNerAlgorithm, metaclass=_FuzzyNerAlgorithmEnumTypeWrapper):
        """Enum of fuzzy ner algorithms"""

    PREFILTER_LEVENSHTEIN: EntityTypeFuzzyNerConfig.FuzzyNerAlgorithm.ValueType  # 0
    """Levenshtein algorithm for fuzzy ner matching"""
    LOCAL_MAXIMUM: EntityTypeFuzzyNerConfig.FuzzyNerAlgorithm.ValueType  # 1
    """local maximum"""

    ENTITY_TYPE_FIELD_NUMBER: builtins.int
    MINIMAL_SCORE_FIELD_NUMBER: builtins.int
    ENTITY_VALUES_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    ALLOW_OVERLAPS_FIELD_NUMBER: builtins.int
    @property
    def entity_type(self) -> ondewo.nlu.entity_type_pb2.EntityType:
        """The Entity Type"""
    minimal_score: builtins.float
    """Optional. Overrides the minimal score in ExtractEntitiesFuzzyRequest."""
    @property
    def entity_values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. If defined, only entity value from this list are considered."""
    algorithm: global___EntityTypeFuzzyNerConfig.FuzzyNerAlgorithm.ValueType
    """Optional. Specify the Fuzzy Ner algorithm"""
    allow_overlaps: builtins.bool
    """Should not use allow_overlaps here, since its default value is False"""
    def __init__(
        self,
        *,
        entity_type: ondewo.nlu.entity_type_pb2.EntityType | None = ...,
        minimal_score: builtins.float = ...,
        entity_values: collections.abc.Iterable[builtins.str] | None = ...,
        algorithm: global___EntityTypeFuzzyNerConfig.FuzzyNerAlgorithm.ValueType = ...,
        allow_overlaps: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity_type", b"entity_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "allow_overlaps", b"allow_overlaps", "entity_type", b"entity_type", "entity_values", b"entity_values", "minimal_score", b"minimal_score"]) -> None: ...

global___EntityTypeFuzzyNerConfig = EntityTypeFuzzyNerConfig

@typing_extensions.final
class EntityDetected(google.protobuf.message.Message):
    """This message contains the entity detected"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    EXTRACTION_METHOD_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> ondewo.nlu.intent_pb2.Intent.TrainingPhrase.Entity:
        """The entity name that is detected"""
    extraction_method: builtins.str
    """The extractor name, e.g. SpacyNer"""
    score: builtins.float
    """The confidence score of the detected entity"""
    def __init__(
        self,
        *,
        entity: ondewo.nlu.intent_pb2.Intent.TrainingPhrase.Entity | None = ...,
        extraction_method: builtins.str = ...,
        score: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "extraction_method", b"extraction_method", "score", b"score"]) -> None: ...

global___EntityDetected = EntityDetected

@typing_extensions.final
class ExtractEntitiesResponse(google.protobuf.message.Message):
    """This message is a response of extracting entities"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITIES_DETECTED_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    @property
    def entities_detected(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EntityDetected]:
        """A list of entities detected"""
    text: builtins.str
    """The text containing the entities detected"""
    def __init__(
        self,
        *,
        entities_detected: collections.abc.Iterable[global___EntityDetected] | None = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entities_detected", b"entities_detected", "text", b"text"]) -> None: ...

global___ExtractEntitiesResponse = ExtractEntitiesResponse

@typing_extensions.final
class GetAlternativeSentencesRequest(google.protobuf.message.Message):
    """Request to get alternative sentences"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    SENTENCE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    PROTECTED_WORDS_FIELD_NUMBER: builtins.int
    WORDS_TO_CHANGE_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___DataEnrichmentConfig:
        """Configuration type of the enricher"""
    sentence: builtins.str
    """The sentence from which it is desired to get alternative sentences"""
    language_code: builtins.str
    """Language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    @property
    def protected_words(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Protected words in the augmentation process"""
    @property
    def words_to_change(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Words to be changed in the augmentation process"""
    def __init__(
        self,
        *,
        config: global___DataEnrichmentConfig | None = ...,
        sentence: builtins.str = ...,
        language_code: builtins.str = ...,
        parent: builtins.str = ...,
        protected_words: collections.abc.Iterable[builtins.str] | None = ...,
        words_to_change: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "language_code", b"language_code", "parent", b"parent", "protected_words", b"protected_words", "sentence", b"sentence", "words_to_change", b"words_to_change"]) -> None: ...

global___GetAlternativeSentencesRequest = GetAlternativeSentencesRequest

@typing_extensions.final
class GenerateUserSaysRequest(google.protobuf.message.Message):
    """Request to generate user sentences"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    N_REPEAT_SYNONYM_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    language_code: builtins.str
    """language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    n_repeat_synonym: builtins.int
    """The number of synonyms desired"""
    branch: builtins.str
    """Git branch"""
    def __init__(
        self,
        *,
        language_code: builtins.str = ...,
        parent: builtins.str = ...,
        n_repeat_synonym: builtins.int = ...,
        branch: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "language_code", b"language_code", "n_repeat_synonym", b"n_repeat_synonym", "parent", b"parent"]) -> None: ...

global___GenerateUserSaysRequest = GenerateUserSaysRequest

@typing_extensions.final
class GenerateResponsesRequest(google.protobuf.message.Message):
    """Request to generate responses"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    N_REPEAT_SYNONYM_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    DROP_UNKNOWN_PARAMETERS_FIELD_NUMBER: builtins.int
    language_code: builtins.str
    """language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    n_repeat_synonym: builtins.int
    """The number of synonyms desired"""
    branch: builtins.str
    """Git branch"""
    drop_unknown_parameters: builtins.bool
    def __init__(
        self,
        *,
        language_code: builtins.str = ...,
        parent: builtins.str = ...,
        n_repeat_synonym: builtins.int = ...,
        branch: builtins.str = ...,
        drop_unknown_parameters: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "drop_unknown_parameters", b"drop_unknown_parameters", "language_code", b"language_code", "n_repeat_synonym", b"n_repeat_synonym", "parent", b"parent"]) -> None: ...

global___GenerateResponsesRequest = GenerateResponsesRequest

@typing_extensions.final
class GetAlternativeTrainingPhrasesRequest(google.protobuf.message.Message):
    """Request to get alternative training phrases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_FIELD_NUMBER: builtins.int
    INTENT_NAME_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    DETECT_ENTITIES_FIELD_NUMBER: builtins.int
    SIMILARITY_THRESHOLD_FIELD_NUMBER: builtins.int
    PROTECTED_WORDS_FIELD_NUMBER: builtins.int
    WORDS_TO_CHANGE_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___DataEnrichmentConfig:
        """Configuration of the enricher"""
    @property
    def training_phrase(self) -> ondewo.nlu.intent_pb2.Intent.TrainingPhrase:
        """Training phrase from which an alternative one is got"""
    intent_name: builtins.str
    """The intent tag attached to the training phrase"""
    language_code: builtins.str
    """language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    detect_entities: builtins.bool
    """Flag to determine whether entities must or not be detected"""
    similarity_threshold: builtins.float
    """similarity threshold defines how similar sentences should be to drop generated training phrase
    as duplicate. Meaningful values of similarity_threshold are between 0.95 and 1.0
    """
    @property
    def protected_words(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Protected words in the augmentation process"""
    @property
    def words_to_change(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Words to be changed in the augmentation process"""
    branch: builtins.str
    """Git branch"""
    def __init__(
        self,
        *,
        config: global___DataEnrichmentConfig | None = ...,
        training_phrase: ondewo.nlu.intent_pb2.Intent.TrainingPhrase | None = ...,
        intent_name: builtins.str = ...,
        language_code: builtins.str = ...,
        parent: builtins.str = ...,
        detect_entities: builtins.bool = ...,
        similarity_threshold: builtins.float = ...,
        protected_words: collections.abc.Iterable[builtins.str] | None = ...,
        words_to_change: collections.abc.Iterable[builtins.str] | None = ...,
        branch: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config", "training_phrase", b"training_phrase"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "config", b"config", "detect_entities", b"detect_entities", "intent_name", b"intent_name", "language_code", b"language_code", "parent", b"parent", "protected_words", b"protected_words", "similarity_threshold", b"similarity_threshold", "training_phrase", b"training_phrase", "words_to_change", b"words_to_change"]) -> None: ...

global___GetAlternativeTrainingPhrasesRequest = GetAlternativeTrainingPhrasesRequest

@typing_extensions.final
class GetSynonymsRequest(google.protobuf.message.Message):
    """Request to get synonyms"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    WORD_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___DataEnrichmentConfig:
        """Configuration of the enricher"""
    word: builtins.str
    """Word from which a synonym is got"""
    language_code: builtins.str
    """language code specifies the language of the request, e.g. cz, de, en, es, fi, fr, it, nl, pl, pt, tr, ru"""
    parent: builtins.str
    """the parent of the request
    Format: <pre><code>projects/&lt;project_uuid&gt;</code></pre>
    """
    def __init__(
        self,
        *,
        config: global___DataEnrichmentConfig | None = ...,
        word: builtins.str = ...,
        language_code: builtins.str = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "language_code", b"language_code", "parent", b"parent", "word", b"word"]) -> None: ...

global___GetSynonymsRequest = GetSynonymsRequest

@typing_extensions.final
class GetSynonymsResponse(google.protobuf.message.Message):
    """Response containing synonyms"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SYNONYMS_FIELD_NUMBER: builtins.int
    @property
    def synonyms(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Synonym]:
        """A list of synonyms"""
    def __init__(
        self,
        *,
        synonyms: collections.abc.Iterable[global___Synonym] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["synonyms", b"synonyms"]) -> None: ...

global___GetSynonymsResponse = GetSynonymsResponse

@typing_extensions.final
class Synonym(google.protobuf.message.Message):
    """This message contains a Synonym"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SYNONYM_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    synonym: builtins.str
    """Synonym word"""
    score: builtins.int
    """Score associated to the synonym resulted"""
    def __init__(
        self,
        *,
        synonym: builtins.str = ...,
        score: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["score", b"score", "synonym", b"synonym"]) -> None: ...

global___Synonym = Synonym

@typing_extensions.final
class GetAlternativeSentencesResponse(google.protobuf.message.Message):
    """Response containing alternative sentences"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALTERNATIVE_SENTENCES_FIELD_NUMBER: builtins.int
    @property
    def alternative_sentences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AltSentence]:
        """A list of alternative sentences"""
    def __init__(
        self,
        *,
        alternative_sentences: collections.abc.Iterable[global___AltSentence] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["alternative_sentences", b"alternative_sentences"]) -> None: ...

global___GetAlternativeSentencesResponse = GetAlternativeSentencesResponse

@typing_extensions.final
class GenerateResponsesResponse(google.protobuf.message.Message):
    """Response containing responses"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def responses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of responses"""
    def __init__(
        self,
        *,
        responses: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["responses", b"responses"]) -> None: ...

global___GenerateResponsesResponse = GenerateResponsesResponse

@typing_extensions.final
class GenerateUserSaysResponse(google.protobuf.message.Message):
    """Response containing user sentences"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_SAYS_FIELD_NUMBER: builtins.int
    @property
    def user_says(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of sampled sentences"""
    def __init__(
        self,
        *,
        user_says: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["user_says", b"user_says"]) -> None: ...

global___GenerateUserSaysResponse = GenerateUserSaysResponse

@typing_extensions.final
class GetAlternativeTrainingPhrasesResponse(google.protobuf.message.Message):
    """Response containing alternative training phrases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALTERNATIVE_TRAINING_PHRASES_FIELD_NUMBER: builtins.int
    @property
    def alternative_training_phrases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AltTrainingPhrase]:
        """A list of alternative training phrases"""
    def __init__(
        self,
        *,
        alternative_training_phrases: collections.abc.Iterable[global___AltTrainingPhrase] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["alternative_training_phrases", b"alternative_training_phrases"]) -> None: ...

global___GetAlternativeTrainingPhrasesResponse = GetAlternativeTrainingPhrasesResponse

@typing_extensions.final
class AltSentence(google.protobuf.message.Message):
    """This message contains an alternative sentence"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SENTENCE_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    sentence: builtins.str
    """Alternative sentence"""
    score: builtins.float
    """Score associated to the alternative sentence resulted"""
    def __init__(
        self,
        *,
        sentence: builtins.str = ...,
        score: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["score", b"score", "sentence", b"sentence"]) -> None: ...

global___AltSentence = AltSentence

@typing_extensions.final
class AltTrainingPhrase(google.protobuf.message.Message):
    """This message contains an alternative training phrase"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAINING_PHRASE_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    @property
    def training_phrase(self) -> ondewo.nlu.intent_pb2.Intent.TrainingPhrase:
        """Alternative training phrase"""
    score: builtins.float
    """Score associated to training_phrase"""
    def __init__(
        self,
        *,
        training_phrase: ondewo.nlu.intent_pb2.Intent.TrainingPhrase | None = ...,
        score: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_phrase", b"training_phrase"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["score", b"score", "training_phrase", b"training_phrase"]) -> None: ...

global___AltTrainingPhrase = AltTrainingPhrase

@typing_extensions.final
class DataEnrichmentConfig(google.protobuf.message.Message):
    """This message contains the configuration of data enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_ENRICHMENT_FIELD_NUMBER: builtins.int
    THESAURUS_ENRICHMENT_FIELD_NUMBER: builtins.int
    WORD2VEC_ENRICHMENT_FIELD_NUMBER: builtins.int
    WORD_NET_ENRICHMENT_FIELD_NUMBER: builtins.int
    GPT2_ENRICHMENT_FIELD_NUMBER: builtins.int
    GLOVE_ENRICHMENT_FIELD_NUMBER: builtins.int
    BERT_ENRICHMENT_FIELD_NUMBER: builtins.int
    XLNET_ENRICHMENT_FIELD_NUMBER: builtins.int
    @property
    def entity_enrichment(self) -> global___EntityEnrichmentConfig:
        """Entity augmenter configuration"""
    @property
    def thesaurus_enrichment(self) -> global___ThesaurusEnrichmentConfig:
        """Thesaurus augmenter configuration"""
    @property
    def word2vec_enrichment(self) -> global___Word2VecEnrichmentConfig:
        """Word2Vec augmenter configuration"""
    @property
    def word_net_enrichment(self) -> global___WordNetAugEnrichmentConfig:
        """WordNet augmenter configuration"""
    @property
    def gpt2_enrichment(self) -> global___GPT2EnrichmentConfig:
        """GPT2 augmenter configuration"""
    @property
    def glove_enrichment(self) -> global___GloVeEnrichmentConfig:
        """GloVe augmenter configuration"""
    @property
    def bert_enrichment(self) -> global___BertAugEnrichmentConfig:
        """BERT augmenter configuration"""
    @property
    def xlnet_enrichment(self) -> global___XLNetAugEnrichmentConfig:
        """XLNet augmenter configuration"""
    def __init__(
        self,
        *,
        entity_enrichment: global___EntityEnrichmentConfig | None = ...,
        thesaurus_enrichment: global___ThesaurusEnrichmentConfig | None = ...,
        word2vec_enrichment: global___Word2VecEnrichmentConfig | None = ...,
        word_net_enrichment: global___WordNetAugEnrichmentConfig | None = ...,
        gpt2_enrichment: global___GPT2EnrichmentConfig | None = ...,
        glove_enrichment: global___GloVeEnrichmentConfig | None = ...,
        bert_enrichment: global___BertAugEnrichmentConfig | None = ...,
        xlnet_enrichment: global___XLNetAugEnrichmentConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bert_enrichment", b"bert_enrichment", "entity_enrichment", b"entity_enrichment", "glove_enrichment", b"glove_enrichment", "gpt2_enrichment", b"gpt2_enrichment", "thesaurus_enrichment", b"thesaurus_enrichment", "word2vec_enrichment", b"word2vec_enrichment", "word_net_enrichment", b"word_net_enrichment", "xlnet_enrichment", b"xlnet_enrichment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bert_enrichment", b"bert_enrichment", "entity_enrichment", b"entity_enrichment", "glove_enrichment", b"glove_enrichment", "gpt2_enrichment", b"gpt2_enrichment", "thesaurus_enrichment", b"thesaurus_enrichment", "word2vec_enrichment", b"word2vec_enrichment", "word_net_enrichment", b"word_net_enrichment", "xlnet_enrichment", b"xlnet_enrichment"]) -> None: ...

global___DataEnrichmentConfig = DataEnrichmentConfig

@typing_extensions.final
class EntityEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for Entity enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___EntityEnrichmentConfig = EntityEnrichmentConfig

@typing_extensions.final
class ThesaurusEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for Thesaurus enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___ThesaurusEnrichmentConfig = ThesaurusEnrichmentConfig

@typing_extensions.final
class BertAugEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for BERT augmenter enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___BertAugEnrichmentConfig = BertAugEnrichmentConfig

@typing_extensions.final
class GloVeEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for GloVe enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___GloVeEnrichmentConfig = GloVeEnrichmentConfig

@typing_extensions.final
class GPT2EnrichmentConfig(google.protobuf.message.Message):
    """Configuration for GPT2 enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___GPT2EnrichmentConfig = GPT2EnrichmentConfig

@typing_extensions.final
class Word2VecEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for Word2Vec enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___Word2VecEnrichmentConfig = Word2VecEnrichmentConfig

@typing_extensions.final
class WordNetAugEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for WordNet augmenter enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___WordNetAugEnrichmentConfig = WordNetAugEnrichmentConfig

@typing_extensions.final
class XLNetAugEnrichmentConfig(google.protobuf.message.Message):
    """Configuration for Thesaurus enrichment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_ACTIVE_FIELD_NUMBER: builtins.int
    ENRICHMENT_FACTOR_FIELD_NUMBER: builtins.int
    EXECUTION_ORDER_FIELD_NUMBER: builtins.int
    is_active: builtins.bool
    """Activation flag"""
    enrichment_factor: builtins.int
    """Factor of enrichment"""
    execution_order: builtins.int
    """Order of augmenter execution"""
    def __init__(
        self,
        *,
        is_active: builtins.bool = ...,
        enrichment_factor: builtins.int = ...,
        execution_order: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enrichment_factor", b"enrichment_factor", "execution_order", b"execution_order", "is_active", b"is_active"]) -> None: ...

global___XLNetAugEnrichmentConfig = XLNetAugEnrichmentConfig

@typing_extensions.final
class ClassifyIntentsRequest(google.protobuf.message.Message):
    """The request for intent classification."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ACTIVE_CONTEXTS_FIELD_NUMBER: builtins.int
    CONTEXT_NAMES_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    ALGORITHMS_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    text: builtins.str
    """the input text"""
    language_code: builtins.str
    """the input language"""
    active_contexts: builtins.bool
    """Optional: if restrict classification result with input contexts listed in the field `context_names`"""
    @property
    def context_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional: names of the input contexts to restrict the classification result with.
        Intents can only be classified if the intent's input context set is the subset of the given context set.
        """
    mode: global___Mode.ValueType
    """Optional: Which mode to use:
    EXCLUSIVE - skip algorithms listed in `algorithms` field,
    INCLUSIVE - run ONLY algorithms listed in `algorithms` field,
    UNSPECIFIED - default mode, described in agent config
    """
    @property
    def algorithms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___IntentAlgorithms.ValueType]:
        """Optional: Algorithm list"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        text: builtins.str = ...,
        language_code: builtins.str = ...,
        active_contexts: builtins.bool = ...,
        context_names: collections.abc.Iterable[builtins.str] | None = ...,
        mode: global___Mode.ValueType = ...,
        algorithms: collections.abc.Iterable[global___IntentAlgorithms.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["active_contexts", b"active_contexts", "algorithms", b"algorithms", "context_names", b"context_names", "language_code", b"language_code", "mode", b"mode", "parent", b"parent", "text", b"text"]) -> None: ...

global___ClassifyIntentsRequest = ClassifyIntentsRequest

@typing_extensions.final
class IntentClassified(google.protobuf.message.Message):
    """Intent classified by a certain intent classifier"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INTENT_NAME_FIELD_NUMBER: builtins.int
    INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    CLASSIFIER_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    intent_name: builtins.str
    """The unique identifier of this intent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/intents/&lt;intent_uuid&gt;</code></pre>
    """
    intent_display_name: builtins.str
    """The name of the intent."""
    classifier: builtins.str
    """The name of the classifier that detected the intent"""
    score: builtins.float
    """Score associated to the detection of the intent by the classifier"""
    def __init__(
        self,
        *,
        intent_name: builtins.str = ...,
        intent_display_name: builtins.str = ...,
        classifier: builtins.str = ...,
        score: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["classifier", b"classifier", "intent_display_name", b"intent_display_name", "intent_name", b"intent_name", "score", b"score"]) -> None: ...

global___IntentClassified = IntentClassified

@typing_extensions.final
class ClassifyIntentsResponse(google.protobuf.message.Message):
    """Response containing the intents classified in a sentence"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INTENTS_CLASSIFIED_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    ACTIVE_CONTEXTS_FIELD_NUMBER: builtins.int
    CONTEXT_NAMES_FIELD_NUMBER: builtins.int
    @property
    def intents_classified(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IntentClassified]:
        """A list of intents detected"""
    text: builtins.str
    """The text containing from which the intents were detected"""
    active_contexts: builtins.bool
    """Flag that enables the context through the conversation"""
    @property
    def context_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The context tags associated to the intents"""
    def __init__(
        self,
        *,
        intents_classified: collections.abc.Iterable[global___IntentClassified] | None = ...,
        text: builtins.str = ...,
        active_contexts: builtins.bool = ...,
        context_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["active_contexts", b"active_contexts", "context_names", b"context_names", "intents_classified", b"intents_classified", "text", b"text"]) -> None: ...

global___ClassifyIntentsResponse = ClassifyIntentsResponse
