"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SortingMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SortingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SortingMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASCENDING: _SortingMode.ValueType  # 0
    """ascending sorting"""
    DESCENDING: _SortingMode.ValueType  # 1
    """descending sorting"""

class SortingMode(_SortingMode, metaclass=_SortingModeEnumTypeWrapper):
    """Sorting mode"""

ASCENDING: SortingMode.ValueType  # 0
"""ascending sorting"""
DESCENDING: SortingMode.ValueType  # 1
"""descending sorting"""
global___SortingMode = SortingMode

class _NotificationFlaggedStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NotificationFlaggedStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NotificationFlaggedStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOTIFICATION_FLAGGED_STATUS_UNSPECIFIED: _NotificationFlaggedStatus.ValueType  # 0
    """Unspecified flagged status"""
    NOTIFICATION_FLAGGED_STATUS_FLAGGED: _NotificationFlaggedStatus.ValueType  # 1
    """Notification is flagged"""
    NOTIFICATION_FLAGGED_STATUS_UNFLAGGED: _NotificationFlaggedStatus.ValueType  # 2
    """Notification is unflagged"""

class NotificationFlaggedStatus(_NotificationFlaggedStatus, metaclass=_NotificationFlaggedStatusEnumTypeWrapper):
    """Enumerates the possible flagged statuses for a notification."""

NOTIFICATION_FLAGGED_STATUS_UNSPECIFIED: NotificationFlaggedStatus.ValueType  # 0
"""Unspecified flagged status"""
NOTIFICATION_FLAGGED_STATUS_FLAGGED: NotificationFlaggedStatus.ValueType  # 1
"""Notification is flagged"""
NOTIFICATION_FLAGGED_STATUS_UNFLAGGED: NotificationFlaggedStatus.ValueType  # 2
"""Notification is unflagged"""
global___NotificationFlaggedStatus = NotificationFlaggedStatus

class _NotificationReadStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NotificationReadStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NotificationReadStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOTIFICATION_READ_STATUS_UNSPECIFIED: _NotificationReadStatus.ValueType  # 0
    """Unspecified read status"""
    NOTIFICATION_READ_STATUS_READ: _NotificationReadStatus.ValueType  # 1
    """Notification is marked as read"""
    NOTIFICATION_READ_STATUS_UNREAD: _NotificationReadStatus.ValueType  # 2
    """Notification is marked as unread"""

class NotificationReadStatus(_NotificationReadStatus, metaclass=_NotificationReadStatusEnumTypeWrapper):
    """Enumerates the possible read statuses for a notification."""

NOTIFICATION_READ_STATUS_UNSPECIFIED: NotificationReadStatus.ValueType  # 0
"""Unspecified read status"""
NOTIFICATION_READ_STATUS_READ: NotificationReadStatus.ValueType  # 1
"""Notification is marked as read"""
NOTIFICATION_READ_STATUS_UNREAD: NotificationReadStatus.ValueType  # 2
"""Notification is marked as unread"""
global___NotificationReadStatus = NotificationReadStatus

class _NotificationVisibility:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NotificationVisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NotificationVisibility.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOTIFICATION_VISIBILITY_UNSPECIFIED: _NotificationVisibility.ValueType  # 0
    """unspecified"""
    NOTIFICATION_VISIBILITY_USER: _NotificationVisibility.ValueType  # 1
    """only user sees the notification - usually a notification of the user interface"""
    NOTIFICATION_VISIBILITY_PROJECT: _NotificationVisibility.ValueType  # 2
    """all members of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_OWNER: _NotificationVisibility.ValueType  # 3
    """all admins of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_ADMIN: _NotificationVisibility.ValueType  # 4
    """all admins of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_DEVELOPER: _NotificationVisibility.ValueType  # 5
    """all admins of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_USER: _NotificationVisibility.ValueType  # 6
    """all users of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_EXECUTOR: _NotificationVisibility.ValueType  # 7
    """all users of a project see this notification"""
    NOTIFICATION_VISIBILITY_PROJECT_INACTIVE: _NotificationVisibility.ValueType  # 8
    """all users of a project see this notification"""
    NOTIFICATION_VISIBILITY_SERVER_ADMIN: _NotificationVisibility.ValueType  # 9
    """all admins of the server"""
    NOTIFICATION_VISIBILITY_SERVER_MANAGER: _NotificationVisibility.ValueType  # 10
    """all admins of the server"""
    NOTIFICATION_VISIBILITY_SERVER_USER: _NotificationVisibility.ValueType  # 11
    """all admins of the server"""
    NOTIFICATION_VISIBILITY_SERVER_INACTIVE: _NotificationVisibility.ValueType  # 12
    """all admins of the server"""

class NotificationVisibility(_NotificationVisibility, metaclass=_NotificationVisibilityEnumTypeWrapper):
    """Enum for notification type"""

NOTIFICATION_VISIBILITY_UNSPECIFIED: NotificationVisibility.ValueType  # 0
"""unspecified"""
NOTIFICATION_VISIBILITY_USER: NotificationVisibility.ValueType  # 1
"""only user sees the notification - usually a notification of the user interface"""
NOTIFICATION_VISIBILITY_PROJECT: NotificationVisibility.ValueType  # 2
"""all members of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_OWNER: NotificationVisibility.ValueType  # 3
"""all admins of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_ADMIN: NotificationVisibility.ValueType  # 4
"""all admins of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_DEVELOPER: NotificationVisibility.ValueType  # 5
"""all admins of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_USER: NotificationVisibility.ValueType  # 6
"""all users of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_EXECUTOR: NotificationVisibility.ValueType  # 7
"""all users of a project see this notification"""
NOTIFICATION_VISIBILITY_PROJECT_INACTIVE: NotificationVisibility.ValueType  # 8
"""all users of a project see this notification"""
NOTIFICATION_VISIBILITY_SERVER_ADMIN: NotificationVisibility.ValueType  # 9
"""all admins of the server"""
NOTIFICATION_VISIBILITY_SERVER_MANAGER: NotificationVisibility.ValueType  # 10
"""all admins of the server"""
NOTIFICATION_VISIBILITY_SERVER_USER: NotificationVisibility.ValueType  # 11
"""all admins of the server"""
NOTIFICATION_VISIBILITY_SERVER_INACTIVE: NotificationVisibility.ValueType  # 12
"""all admins of the server"""
global___NotificationVisibility = NotificationVisibility

class _NotificationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NotificationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NotificationType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOTIFICATION_TYPE_UNSPECIFIED: _NotificationType.ValueType  # 0
    """Unspecified notification type"""
    NOTIFICATION_TYPE_DEBUG: _NotificationType.ValueType  # 1
    """Debug notification type"""
    NOTIFICATION_TYPE_WARNING: _NotificationType.ValueType  # 2
    """Warning notification type"""
    NOTIFICATION_TYPE_INFO: _NotificationType.ValueType  # 3
    """Informational notification type"""
    NOTIFICATION_TYPE_ERROR: _NotificationType.ValueType  # 4
    """Error notification type"""
    NOTIFICATION_TYPE_NEWS: _NotificationType.ValueType  # 5
    """News notification type"""

class NotificationType(_NotificationType, metaclass=_NotificationTypeEnumTypeWrapper):
    """Enumerates the possible types for a notification."""

NOTIFICATION_TYPE_UNSPECIFIED: NotificationType.ValueType  # 0
"""Unspecified notification type"""
NOTIFICATION_TYPE_DEBUG: NotificationType.ValueType  # 1
"""Debug notification type"""
NOTIFICATION_TYPE_WARNING: NotificationType.ValueType  # 2
"""Warning notification type"""
NOTIFICATION_TYPE_INFO: NotificationType.ValueType  # 3
"""Informational notification type"""
NOTIFICATION_TYPE_ERROR: NotificationType.ValueType  # 4
"""Error notification type"""
NOTIFICATION_TYPE_NEWS: NotificationType.ValueType  # 5
"""News notification type"""
global___NotificationType = NotificationType

class _NotificationOrigin:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NotificationOriginEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NotificationOrigin.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NOTIFICATION_ORIGIN_UNSPECIFIED: _NotificationOrigin.ValueType  # 0
    """unspecified"""
    NOTIFICATION_ORIGIN_ONDEWO_AIM: _NotificationOrigin.ValueType  # 1
    """ondewo-aim service"""
    NOTIFICATION_ORIGIN_ONDEWO_BPI: _NotificationOrigin.ValueType  # 2
    """ondewo-bpi service"""
    NOTIFICATION_ORIGIN_ONDEWO_CSI: _NotificationOrigin.ValueType  # 3
    """ondewo-csi service"""
    NOTIFICATION_ORIGIN_ONDEWO_NLU: _NotificationOrigin.ValueType  # 4
    """ondewo-nlu service"""
    NOTIFICATION_ORIGIN_ONDEWO_S2T: _NotificationOrigin.ValueType  # 5
    """ondewo-s2t service"""
    NOTIFICATION_ORIGIN_ONDEWO_SIP: _NotificationOrigin.ValueType  # 6
    """ondewo-sip service"""
    NOTIFICATION_ORIGIN_ONDEWO_T2S: _NotificationOrigin.ValueType  # 7
    """ondewo-t2s service"""
    NOTIFICATION_ORIGIN_ONDEWO_VTSI: _NotificationOrigin.ValueType  # 8
    """ondewo-vtsi service"""
    NOTIFICATION_ORIGIN_ONDEWO_VTSI_RABBITMQ: _NotificationOrigin.ValueType  # 9
    """ondewo-vtsi-rabbitmq service"""

class NotificationOrigin(_NotificationOrigin, metaclass=_NotificationOriginEnumTypeWrapper):
    """Enumerates the possible origins for a notification."""

NOTIFICATION_ORIGIN_UNSPECIFIED: NotificationOrigin.ValueType  # 0
"""unspecified"""
NOTIFICATION_ORIGIN_ONDEWO_AIM: NotificationOrigin.ValueType  # 1
"""ondewo-aim service"""
NOTIFICATION_ORIGIN_ONDEWO_BPI: NotificationOrigin.ValueType  # 2
"""ondewo-bpi service"""
NOTIFICATION_ORIGIN_ONDEWO_CSI: NotificationOrigin.ValueType  # 3
"""ondewo-csi service"""
NOTIFICATION_ORIGIN_ONDEWO_NLU: NotificationOrigin.ValueType  # 4
"""ondewo-nlu service"""
NOTIFICATION_ORIGIN_ONDEWO_S2T: NotificationOrigin.ValueType  # 5
"""ondewo-s2t service"""
NOTIFICATION_ORIGIN_ONDEWO_SIP: NotificationOrigin.ValueType  # 6
"""ondewo-sip service"""
NOTIFICATION_ORIGIN_ONDEWO_T2S: NotificationOrigin.ValueType  # 7
"""ondewo-t2s service"""
NOTIFICATION_ORIGIN_ONDEWO_VTSI: NotificationOrigin.ValueType  # 8
"""ondewo-vtsi service"""
NOTIFICATION_ORIGIN_ONDEWO_VTSI_RABBITMQ: NotificationOrigin.ValueType  # 9
"""ondewo-vtsi-rabbitmq service"""
global___NotificationOrigin = NotificationOrigin

@typing_extensions.final
class StatResponse(google.protobuf.message.Message):
    """statistic response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """Response wrapper for the "Get<Stat>" endpoints"""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

global___StatResponse = StatResponse

@typing_extensions.final
class Comment(google.protobuf.message.Message):
    """Comment message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    COMMENT_ABOUT_NAME_FIELD_NUMBER: builtins.int
    PARENT_COMMENT_NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """resource name of the comment"""
    text: builtins.str
    """text of the comment"""
    user_id: builtins.str
    """User id as resource name
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/users/&lt;user_uuid&gt;</code></pre>
    """
    comment_about_name: builtins.str
    """name of the resource for which the comment is about
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/&lt;resource_type&gt;/&lt;resource_uuid&gt;/.../</code></pre>
    """
    parent_comment_name: builtins.str
    """The resource name of the parent comment. A parent comment is a reply to a certain comment.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/&lt;resource_type&gt;/&lt;resource_uuid&gt;/.../</code></pre>
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        text: builtins.str = ...,
        user_id: builtins.str = ...,
        comment_about_name: builtins.str = ...,
        parent_comment_name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["comment_about_name", b"comment_about_name", "created_at", b"created_at", "created_by", b"created_by", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "parent_comment_name", b"parent_comment_name", "text", b"text", "user_id", b"user_id"]) -> None: ...

global___Comment = Comment

@typing_extensions.final
class Notification(google.protobuf.message.Message):
    """Notification message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    USER_NAME_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_SHORT_FIELD_NUMBER: builtins.int
    DESCRIPTION_LONG_FIELD_NUMBER: builtins.int
    NOTIFICATION_FLAGGED_STATUS_FIELD_NUMBER: builtins.int
    NOTIFICATION_FLAGGED_TIMESTAMP_FIELD_NUMBER: builtins.int
    NOTIFICATION_READ_STATUS_FIELD_NUMBER: builtins.int
    NOTIFICATION_READ_TIMESTAMP_FIELD_NUMBER: builtins.int
    NOTIFICATION_ORIGIN_FIELD_NUMBER: builtins.int
    ORIGIN_NAME_FIELD_NUMBER: builtins.int
    ORIGIN_LANGUAGE_FIELD_NUMBER: builtins.int
    NOTIFICATION_TYPE_FIELD_NUMBER: builtins.int
    NOTIFICATION_VISIBILITY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """resource name of the notification"""
    user_name: builtins.str
    """User id as resource name
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/users/&lt;user_uuid&gt;</code></pre>
    """
    title: builtins.str
    """User id as resource name
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/users/&lt;user_uuid&gt;</code></pre>
    """
    description_short: builtins.str
    """A short notification text is displayed directly with max. 50 chars which is a truncated version of the long message"""
    description_long: builtins.str
    """A long notification text"""
    notification_flagged_status: global___NotificationFlaggedStatus.ValueType
    """Has a notification been flagged by a specific user"""
    @property
    def notification_flagged_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the user marked the notification as read"""
    notification_read_status: global___NotificationReadStatus.ValueType
    """Has a notification been read by a specific user"""
    @property
    def notification_read_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the user marked the notification as read, i.e. read the notification"""
    notification_origin: global___NotificationOrigin.ValueType
    """The origin of a notification
    A Notification origin can be from a product (service), e.g. ondewo-nlu, ondewo-s2t, ondewo-t2s, etc.
    """
    origin_name: builtins.str
    """The name of resource of where the notification originated"""
    origin_language: builtins.str
    """language of the origin resource e.g. language of the nlu agent or language of the speech-to-text service"""
    notification_type: global___NotificationType.ValueType
    """The type of notification"""
    notification_visibility: global___NotificationVisibility.ValueType
    """The visibility level of the notification"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        user_name: builtins.str = ...,
        title: builtins.str = ...,
        description_short: builtins.str = ...,
        description_long: builtins.str = ...,
        notification_flagged_status: global___NotificationFlaggedStatus.ValueType = ...,
        notification_flagged_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        notification_read_status: global___NotificationReadStatus.ValueType = ...,
        notification_read_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        notification_origin: global___NotificationOrigin.ValueType = ...,
        origin_name: builtins.str = ...,
        origin_language: builtins.str = ...,
        notification_type: global___NotificationType.ValueType = ...,
        notification_visibility: global___NotificationVisibility.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at", "notification_flagged_timestamp", b"notification_flagged_timestamp", "notification_read_timestamp", b"notification_read_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "description_long", b"description_long", "description_short", b"description_short", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "notification_flagged_status", b"notification_flagged_status", "notification_flagged_timestamp", b"notification_flagged_timestamp", "notification_origin", b"notification_origin", "notification_read_status", b"notification_read_status", "notification_read_timestamp", b"notification_read_timestamp", "notification_type", b"notification_type", "notification_visibility", b"notification_visibility", "origin_language", b"origin_language", "origin_name", b"origin_name", "title", b"title", "user_name", b"user_name"]) -> None: ...

global___Notification = Notification

@typing_extensions.final
class AddNotificationsRequest(google.protobuf.message.Message):
    """Message for adding notifications in a batch."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FIELD_NUMBER: builtins.int
    @property
    def notification(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Notification]:
        """List of notifications to be added."""
    def __init__(
        self,
        *,
        notification: collections.abc.Iterable[global___Notification] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification", b"notification"]) -> None: ...

global___AddNotificationsRequest = AddNotificationsRequest

@typing_extensions.final
class AddNotificationsResponse(google.protobuf.message.Message):
    """Message containing the response to adding notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FIELD_NUMBER: builtins.int
    @property
    def notification(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Notification]:
        """List of notifications that have been added."""
    def __init__(
        self,
        *,
        notification: collections.abc.Iterable[global___Notification] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification", b"notification"]) -> None: ...

global___AddNotificationsResponse = AddNotificationsResponse

@typing_extensions.final
class NotificationFilter(google.protobuf.message.Message):
    """Message for filtering notifications based on various criteria."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    NOTIFICATION_ORIGINS_FIELD_NUMBER: builtins.int
    NOTIFICATION_VISIBILITIES_FIELD_NUMBER: builtins.int
    NOTIFICATION_FLAGGED_STATUS_FIELD_NUMBER: builtins.int
    NOTIFICATION_READ_STATUS_FIELD_NUMBER: builtins.int
    EARLIEST_FIELD_NUMBER: builtins.int
    LATEST_FIELD_NUMBER: builtins.int
    USER_NAMES_FIELD_NUMBER: builtins.int
    ORIGIN_NAMES_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Language codes of the projects for which notifications are filtered."""
    @property
    def notification_origins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___NotificationOrigin.ValueType]:
        """Origins of the notifications to filter."""
    @property
    def notification_visibilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___NotificationVisibility.ValueType]:
        """Visibilities of the notifications to filter."""
    @property
    def notification_flagged_status(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___NotificationFlaggedStatus.ValueType]:
        """Flagged status of the notifications to filter."""
    @property
    def notification_read_status(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___NotificationReadStatus.ValueType]:
        """Read status of the notifications to filter."""
    @property
    def earliest(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Filter notifications with a time range starting from the specified earliest time."""
    @property
    def latest(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Filter notifications with a time range ending at the specified latest time."""
    @property
    def user_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Resource names of users to filter notifications for."""
    @property
    def origin_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Resource names of the origin of the notification to filter notifications."""
    def __init__(
        self,
        *,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        notification_origins: collections.abc.Iterable[global___NotificationOrigin.ValueType] | None = ...,
        notification_visibilities: collections.abc.Iterable[global___NotificationVisibility.ValueType] | None = ...,
        notification_flagged_status: collections.abc.Iterable[global___NotificationFlaggedStatus.ValueType] | None = ...,
        notification_read_status: collections.abc.Iterable[global___NotificationReadStatus.ValueType] | None = ...,
        earliest: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        latest: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_names: collections.abc.Iterable[builtins.str] | None = ...,
        origin_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["earliest", b"earliest", "latest", b"latest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["earliest", b"earliest", "language_codes", b"language_codes", "latest", b"latest", "notification_flagged_status", b"notification_flagged_status", "notification_origins", b"notification_origins", "notification_read_status", b"notification_read_status", "notification_visibilities", b"notification_visibilities", "origin_names", b"origin_names", "user_names", b"user_names"]) -> None: ...

global___NotificationFilter = NotificationFilter

@typing_extensions.final
class ListNotificationsRequest(google.protobuf.message.Message):
    """Message for listing notifications based on certain criteria."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FILTER_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    @property
    def notification_filter(self) -> global___NotificationFilter:
        """Optional filter to narrow the response down to specific notifications."""
    page_token: builtins.str
    """Optional. Token for pagination, obtained from a previous list request.
    The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. Mask to control which fields will be filled with data.
        Example: path=["notification.user_names"]
        """
    def __init__(
        self,
        *,
        notification_filter: global___NotificationFilter | None = ...,
        page_token: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "notification_filter", b"notification_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "notification_filter", b"notification_filter", "page_token", b"page_token"]) -> None: ...

global___ListNotificationsRequest = ListNotificationsRequest

@typing_extensions.final
class ListNotificationsResponse(google.protobuf.message.Message):
    """Message containing the response to a list request for notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FIELD_NUMBER: builtins.int
    @property
    def notification(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Notification]:
        """List of notifications that meet the specified criteria."""
    def __init__(
        self,
        *,
        notification: collections.abc.Iterable[global___Notification] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification", b"notification"]) -> None: ...

global___ListNotificationsResponse = ListNotificationsResponse

@typing_extensions.final
class SetNotificationsFlaggedStatusRequest(google.protobuf.message.Message):
    """Message for setting the flagged status of notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_NAME_FIELD_NUMBER: builtins.int
    FLAGGED_FIELD_NUMBER: builtins.int
    @property
    def notification_name(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of notifications to set the flagged status for."""
    @property
    def flagged(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Flagged status to set for the specified notifications."""
    def __init__(
        self,
        *,
        notification_name: collections.abc.Iterable[builtins.str] | None = ...,
        flagged: collections.abc.Iterable[builtins.bool] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["flagged", b"flagged", "notification_name", b"notification_name"]) -> None: ...

global___SetNotificationsFlaggedStatusRequest = SetNotificationsFlaggedStatusRequest

@typing_extensions.final
class SetNotificationsReadStatusRequest(google.protobuf.message.Message):
    """Message for setting the read status of notifications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_NAME_FIELD_NUMBER: builtins.int
    FLAGGED_FIELD_NUMBER: builtins.int
    @property
    def notification_name(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of notifications to set the read status for."""
    @property
    def flagged(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """Read status to set for the specified notifications."""
    def __init__(
        self,
        *,
        notification_name: collections.abc.Iterable[builtins.str] | None = ...,
        flagged: collections.abc.Iterable[builtins.bool] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["flagged", b"flagged", "notification_name", b"notification_name"]) -> None: ...

global___SetNotificationsReadStatusRequest = SetNotificationsReadStatusRequest

@typing_extensions.final
class KeyValuePair(google.protobuf.message.Message):
    """Key-Value pair message, where the value can be one of various types (int, float, double, string, etc.)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    FLOAT_VALUE_FIELD_NUMBER: builtins.int
    DOUBLE_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The key of the key-value pair."""
    int_value: builtins.int
    """The integer value (if applicable)."""
    float_value: builtins.float
    """The float value (if applicable)."""
    double_value: builtins.float
    """The double value (if applicable)."""
    string_value: builtins.str
    """The string value (if applicable)."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp value (if applicable)."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        int_value: builtins.int = ...,
        float_value: builtins.float = ...,
        double_value: builtins.float = ...,
        string_value: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "double_value", b"double_value", "float_value", b"float_value", "int_value", b"int_value", "string_value", b"string_value", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "double_value", b"double_value", "float_value", b"float_value", "int_value", b"int_value", "key", b"key", "string_value", b"string_value", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["int_value", "float_value", "double_value", "string_value", "created_at"] | None: ...

global___KeyValuePair = KeyValuePair
