"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class OperationMetadata(google.protobuf.message.Message):
    """Represents the metadata of the long-running operation that can be a parent operation for sub-operations or
    can be a sub-operation itself
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OperationMetadata._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: OperationMetadata._Status.ValueType  # 0
        """unspecified status code"""
        NOT_STARTED: OperationMetadata._Status.ValueType  # 1
        """operation haven't started yet"""
        IN_PROGRESS: OperationMetadata._Status.ValueType  # 2
        """operation currently in progress"""
        DONE: OperationMetadata._Status.ValueType  # 3
        """operation has completed without any error"""
        CANCELLED: OperationMetadata._Status.ValueType  # 4
        """operation has completed with cancellation by user"""
        FAILED: OperationMetadata._Status.ValueType  # 5
        """operation has completed with errors"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Structure to set status of operation. An operation may not be started if NOT_STARTED is set, in
        progress if IN_PROGRESS, finished if DONE, interrupted if CANCELED or failed if FAILED.
        """

    STATUS_UNSPECIFIED: OperationMetadata.Status.ValueType  # 0
    """unspecified status code"""
    NOT_STARTED: OperationMetadata.Status.ValueType  # 1
    """operation haven't started yet"""
    IN_PROGRESS: OperationMetadata.Status.ValueType  # 2
    """operation currently in progress"""
    DONE: OperationMetadata.Status.ValueType  # 3
    """operation has completed without any error"""
    CANCELLED: OperationMetadata.Status.ValueType  # 4
    """operation has completed with cancellation by user"""
    FAILED: OperationMetadata.Status.ValueType  # 5
    """operation has completed with errors"""

    class _OperationType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OperationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OperationMetadata._OperationType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPERATION_TYPE_UNSPECIFIED: OperationMetadata._OperationType.ValueType  # 0
        """unspecified operation type"""
        CREATE_AGENT: OperationMetadata._OperationType.ValueType  # 1
        """create a new agent with specified configuration"""
        IMPORT_AGENT: OperationMetadata._OperationType.ValueType  # 2
        """import agent from a zip file"""
        EXPORT_AGENT: OperationMetadata._OperationType.ValueType  # 3
        """export agent to a zip file"""
        DELETE_AGENT: OperationMetadata._OperationType.ValueType  # 4
        """delete agent"""
        RESTORE_AGENT: OperationMetadata._OperationType.ValueType  # 5
        """restore agent"""
        BUILD_AGENT_CACHE: OperationMetadata._OperationType.ValueType  # 6
        """build agent cache"""
        TRAIN_AGENT: OperationMetadata._OperationType.ValueType  # 7
        """train agent"""
        EXPORT_BENCHMARK_AGENT: OperationMetadata._OperationType.ValueType  # 8
        """export benchmark agent to a zip file"""
        INDEX_AGENT: OperationMetadata._OperationType.ValueType  # 9
        """force loading agent data for full text search"""

    class OperationType(_OperationType, metaclass=_OperationTypeEnumTypeWrapper):
        """Type of operation. It can be creating, importing, exporting, deleting, restoring, building cache,
        training or exporting benchmark an agent
        """

    OPERATION_TYPE_UNSPECIFIED: OperationMetadata.OperationType.ValueType  # 0
    """unspecified operation type"""
    CREATE_AGENT: OperationMetadata.OperationType.ValueType  # 1
    """create a new agent with specified configuration"""
    IMPORT_AGENT: OperationMetadata.OperationType.ValueType  # 2
    """import agent from a zip file"""
    EXPORT_AGENT: OperationMetadata.OperationType.ValueType  # 3
    """export agent to a zip file"""
    DELETE_AGENT: OperationMetadata.OperationType.ValueType  # 4
    """delete agent"""
    RESTORE_AGENT: OperationMetadata.OperationType.ValueType  # 5
    """restore agent"""
    BUILD_AGENT_CACHE: OperationMetadata.OperationType.ValueType  # 6
    """build agent cache"""
    TRAIN_AGENT: OperationMetadata.OperationType.ValueType  # 7
    """train agent"""
    EXPORT_BENCHMARK_AGENT: OperationMetadata.OperationType.ValueType  # 8
    """export benchmark agent to a zip file"""
    INDEX_AGENT: OperationMetadata.OperationType.ValueType  # 9
    """force loading agent data for full text search"""

    STATUS_FIELD_NUMBER: builtins.int
    PARENT_OPERATION_NAME_FIELD_NUMBER: builtins.int
    SUB_OPERATION_NAMES_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    IS_CANCELLATION_REQUESTED_FIELD_NUMBER: builtins.int
    CANCEL_COMMAND_FIELD_NUMBER: builtins.int
    USER_ID_CREATED_FIELD_NUMBER: builtins.int
    USER_ID_CANCELLED_FIELD_NUMBER: builtins.int
    PROJECT_PARENT_FIELD_NUMBER: builtins.int
    OPERATION_TYPE_FIELD_NUMBER: builtins.int
    HOST_NAME_FIELD_NUMBER: builtins.int
    NUM_RERUNS_FIELD_NUMBER: builtins.int
    MAX_NUM_RERUNS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LOG_FIELD_NUMBER: builtins.int
    LOG_LIMIT_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    status: global___OperationMetadata.Status.ValueType
    """long-running operation status code"""
    parent_operation_name: builtins.str
    """optional parent operation name"""
    @property
    def sub_operation_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list of the sub-operations' names of the operation"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time the operation was submitted."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time operation processing started."""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time operation processing completed."""
    is_cancellation_requested: builtins.bool
    """indicates whether a request to cancel this operation has been made."""
    cancel_command: builtins.str
    """command executed at cancel operation"""
    user_id_created: builtins.str
    """id of the user who created the operation"""
    user_id_cancelled: builtins.str
    """id of the user who cancelled the operation"""
    project_parent: builtins.str
    """project parent name, e.g. "projects/pepper/agent" """
    operation_type: global___OperationMetadata.OperationType.ValueType
    """operation type"""
    host_name: builtins.str
    """name of the host where the operation was executed"""
    num_reruns: builtins.int
    """number of times the operation was re-run"""
    max_num_reruns: builtins.int
    """maximum number of re-runs in case the operation fails"""
    description: builtins.str
    """description, normally needed for sub operations when type is OPERATION_TYPE_UNSPECIFIED"""
    @property
    def log(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The log output of an operation"""
    log_limit: builtins.int
    """The log output of an operation limited to the last x log entries"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        status: global___OperationMetadata.Status.ValueType = ...,
        parent_operation_name: builtins.str = ...,
        sub_operation_names: collections.abc.Iterable[builtins.str] | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_cancellation_requested: builtins.bool = ...,
        cancel_command: builtins.str = ...,
        user_id_created: builtins.str = ...,
        user_id_cancelled: builtins.str = ...,
        project_parent: builtins.str = ...,
        operation_type: global___OperationMetadata.OperationType.ValueType = ...,
        host_name: builtins.str = ...,
        num_reruns: builtins.int = ...,
        max_num_reruns: builtins.int = ...,
        description: builtins.str = ...,
        log: collections.abc.Iterable[builtins.str] | None = ...,
        log_limit: builtins.int = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "created_at", b"created_at", "end_time", b"end_time", "modified_at", b"modified_at", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cancel_command", b"cancel_command", "create_time", b"create_time", "created_at", b"created_at", "created_by", b"created_by", "description", b"description", "end_time", b"end_time", "host_name", b"host_name", "is_cancellation_requested", b"is_cancellation_requested", "log", b"log", "log_limit", b"log_limit", "max_num_reruns", b"max_num_reruns", "modified_at", b"modified_at", "modified_by", b"modified_by", "num_reruns", b"num_reruns", "operation_type", b"operation_type", "parent_operation_name", b"parent_operation_name", "project_parent", b"project_parent", "start_time", b"start_time", "status", b"status", "sub_operation_names", b"sub_operation_names", "user_id_cancelled", b"user_id_cancelled", "user_id_created", b"user_id_created"]) -> None: ...

global___OperationMetadata = OperationMetadata
