"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DefaultProjectRole:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DefaultProjectRoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DefaultProjectRole.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PROJECT_UNSPECIFIED: _DefaultProjectRole.ValueType  # 0
    """These roles have permissions valid only on a specific project unspecified, default value depends on endpoint"""
    PROJECT_USER: _DefaultProjectRole.ValueType  # 1
    """read-only access"""
    PROJECT_EXECUTOR: _DefaultProjectRole.ValueType  # 2
    """permissions of PROJECT_USER + execution rights (detect intent, extract entities, train, etc)"""
    PROJECT_DEVELOPER: _DefaultProjectRole.ValueType  # 3
    """permissions of PROJECT_EXECUTOR + CRUD rights"""
    PROJECT_ADMIN: _DefaultProjectRole.ValueType  # 4
    """this role can do everything. The creator of a project is set automatically as PROJECT_ADMIN of it."""
    PROJECT_INACTIVE: _DefaultProjectRole.ValueType  # 5
    """This role can do nothing.  Used to set a user as inactive inside a project"""

class DefaultProjectRole(_DefaultProjectRole, metaclass=_DefaultProjectRoleEnumTypeWrapper):
    """Structure of project role"""

PROJECT_UNSPECIFIED: DefaultProjectRole.ValueType  # 0
"""These roles have permissions valid only on a specific project unspecified, default value depends on endpoint"""
PROJECT_USER: DefaultProjectRole.ValueType  # 1
"""read-only access"""
PROJECT_EXECUTOR: DefaultProjectRole.ValueType  # 2
"""permissions of PROJECT_USER + execution rights (detect intent, extract entities, train, etc)"""
PROJECT_DEVELOPER: DefaultProjectRole.ValueType  # 3
"""permissions of PROJECT_EXECUTOR + CRUD rights"""
PROJECT_ADMIN: DefaultProjectRole.ValueType  # 4
"""this role can do everything. The creator of a project is set automatically as PROJECT_ADMIN of it."""
PROJECT_INACTIVE: DefaultProjectRole.ValueType  # 5
"""This role can do nothing.  Used to set a user as inactive inside a project"""
global___DefaultProjectRole = DefaultProjectRole

class _ProjectRoleView:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ProjectRoleViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ProjectRoleView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PROJECT_ROLE_VIEW_UNSPECIFIED: _ProjectRoleView.ValueType  # 0
    """The view depends on the endpoint:
    * CreateProjectRole: FULL
    * GetProjectRole: FULL
    * UpdateProjectRole: FULL
    * ListProjectRoles: FULL
    """
    PROJECT_ROLE_VIEW_SHALLOW: _ProjectRoleView.ValueType  # 1
    """only role ID and name fields are populated"""
    PROJECT_ROLE_VIEW_FULL: _ProjectRoleView.ValueType  # 2
    """all fields including permissions are populated"""

class ProjectRoleView(_ProjectRoleView, metaclass=_ProjectRoleViewEnumTypeWrapper):
    """Structure of project role view"""

PROJECT_ROLE_VIEW_UNSPECIFIED: ProjectRoleView.ValueType  # 0
"""The view depends on the endpoint:
* CreateProjectRole: FULL
* GetProjectRole: FULL
* UpdateProjectRole: FULL
* ListProjectRoles: FULL
"""
PROJECT_ROLE_VIEW_SHALLOW: ProjectRoleView.ValueType  # 1
"""only role ID and name fields are populated"""
PROJECT_ROLE_VIEW_FULL: ProjectRoleView.ValueType  # 2
"""all fields including permissions are populated"""
global___ProjectRoleView = ProjectRoleView

@typing_extensions.final
class ProjectRole(google.protobuf.message.Message):
    """Project Role messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    role_id: builtins.int
    """unique identifier of the role"""
    name: builtins.str
    """unique name of the role"""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """defines the permissions for the given role (the strings can be gotten from the ListProjectPermissions)"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        role_id: builtins.int = ...,
        name: builtins.str = ...,
        permissions: collections.abc.Iterable[builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "permissions", b"permissions", "role_id", b"role_id"]) -> None: ...

global___ProjectRole = ProjectRole

@typing_extensions.final
class CreateProjectRoleRequest(google.protobuf.message.Message):
    """This message is a request to create project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    @property
    def role(self) -> global___ProjectRole:
        """If the role_id is not provided, an incremental value will be assigned
        The "name" and "role_type" are mandatory values
        The permissions all default to False if not provided specifically
        """
    project_role_view: global___ProjectRoleView.ValueType
    """Optional. specify the view of the created project role, PROJECT_ROLE_VIEW_FULL by default"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        role: global___ProjectRole | None = ...,
        project_role_view: global___ProjectRoleView.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["role", b"role"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "project_role_view", b"project_role_view", "role", b"role"]) -> None: ...

global___CreateProjectRoleRequest = CreateProjectRoleRequest

@typing_extensions.final
class UpdateProjectRoleRequest(google.protobuf.message.Message):
    """This message is a request to update project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    @property
    def role(self) -> global___ProjectRole:
        """role_id in the Role message should be given, if empty will throw an error in the backend
        other fields in the Role are optional. Only the fields to be updated should be provided
        """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which fields get updated."""
    project_role_view: global___ProjectRoleView.ValueType
    """Optional. specify the view of the updated project role, PROJECT_ROLE_VIEW_FULL by default"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        role: global___ProjectRole | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        project_role_view: global___ProjectRoleView.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["role", b"role", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "project_role_view", b"project_role_view", "role", b"role", "update_mask", b"update_mask"]) -> None: ...

global___UpdateProjectRoleRequest = UpdateProjectRoleRequest

@typing_extensions.final
class GetProjectRoleRequest(google.protobuf.message.Message):
    """This message is a request to get project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    ROLE_NAME_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    role_id: builtins.int
    """role is identified by role id"""
    role_name: builtins.str
    """role can also be uniquely identified by its name"""
    project_role_view: global___ProjectRoleView.ValueType
    """Optional. specify the view of the project role, PROJECT_ROLE_VIEW_FULL by default"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        role_id: builtins.int = ...,
        role_name: builtins.str = ...,
        project_role_view: global___ProjectRoleView.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["project_role_identifier", b"project_role_identifier", "role_id", b"role_id", "role_name", b"role_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "project_role_identifier", b"project_role_identifier", "project_role_view", b"project_role_view", "role_id", b"role_id", "role_name", b"role_name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["project_role_identifier", b"project_role_identifier"]) -> typing_extensions.Literal["role_id", "role_name"] | None: ...

global___GetProjectRoleRequest = GetProjectRoleRequest

@typing_extensions.final
class DeleteProjectRoleRequest(google.protobuf.message.Message):
    """This message is a request to delete project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    role_id: builtins.int
    """role is identified by role id, if empty will throw an error in the backend"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        role_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "role_id", b"role_id"]) -> None: ...

global___DeleteProjectRoleRequest = DeleteProjectRoleRequest

@typing_extensions.final
class ListProjectRolesRequest(google.protobuf.message.Message):
    """This message is a request to list project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    project_role_view: global___ProjectRoleView.ValueType
    """Optional. specify the view of the project roles, PROJECT_ROLE_VIEW_FULL by default"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        page_token: builtins.str = ...,
        project_role_view: global___ProjectRoleView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token", "parent", b"parent", "project_role_view", b"project_role_view"]) -> None: ...

global___ListProjectRolesRequest = ListProjectRolesRequest

@typing_extensions.final
class ListProjectRolesResponse(google.protobuf.message.Message):
    """This message is a response of listing project role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ROLES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def project_roles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProjectRole]:
        """The list of project roles. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """
    def __init__(
        self,
        *,
        project_roles: collections.abc.Iterable[global___ProjectRole] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "project_roles", b"project_roles"]) -> None: ...

global___ListProjectRolesResponse = ListProjectRolesResponse
