"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 Google Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Modifications Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import google.rpc.status_pb2
import google.type.latlng_pb2
import ondewo.nlu.common_pb2
import ondewo.nlu.context_pb2
import ondewo.nlu.entity_type_pb2
import ondewo.nlu.intent_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TranscriptionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TranscriptionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TranscriptionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRANSCRIPTION_TYPE_UNSPECIFIED: _TranscriptionType.ValueType  # 0
    """unspecified"""
    TRANSCRIPTION_TYPE_S2T: _TranscriptionType.ValueType  # 1
    """Automatic transcription by a speech to text system"""
    TRANSCRIPTION_TYPE_HUMAN: _TranscriptionType.ValueType  # 2
    """Manual human transcription"""

class TranscriptionType(_TranscriptionType, metaclass=_TranscriptionTypeEnumTypeWrapper): ...

TRANSCRIPTION_TYPE_UNSPECIFIED: TranscriptionType.ValueType  # 0
"""unspecified"""
TRANSCRIPTION_TYPE_S2T: TranscriptionType.ValueType  # 1
"""Automatic transcription by a speech to text system"""
TRANSCRIPTION_TYPE_HUMAN: TranscriptionType.ValueType  # 2
"""Manual human transcription"""
global___TranscriptionType = TranscriptionType

class _AudioEncoding:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AudioEncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AudioEncoding.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUDIO_ENCODING_UNSPECIFIED: _AudioEncoding.ValueType  # 0
    """Not specified."""
    AUDIO_ENCODING_LINEAR_16: _AudioEncoding.ValueType  # 1
    """Uncompressed 16-bit signed little-endian samples (Linear PCM)."""
    AUDIO_ENCODING_FLAC: _AudioEncoding.ValueType  # 2
    """[`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
    Codec) is the recommended encoding because it is lossless (therefore
    recognition is not compromised) and requires only about half the
    bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
    24-bit samples, however, not all fields in `STREAMINFO` are supported.
    """
    AUDIO_ENCODING_MULAW: _AudioEncoding.ValueType  # 3
    """8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law."""
    AUDIO_ENCODING_AMR: _AudioEncoding.ValueType  # 4
    """Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000."""
    AUDIO_ENCODING_AMR_WB: _AudioEncoding.ValueType  # 5
    """Adaptive Multi-Rate wideband codec. `sample_rate_hertz` must be 16000."""
    AUDIO_ENCODING_OGG_OPUS: _AudioEncoding.ValueType  # 6
    """Opus encoded audio frames in Ogg container
    ([OggOpus](https://wiki.xiph.org/OggOpus)).
    `sample_rate_hertz` must be 16000.
    """
    AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE: _AudioEncoding.ValueType  # 7
    """Although the use of lossy encodings is not recommended, if a very low
    bitrate encoding is required, `OGG_OPUS` is highly preferred over
    Speex encoding. The [Speex](https://speex.org/) encoding supported by
    Dialogflow API has a header byte in each block, as in MIME type
    `audio/x-speex-with-header-byte`.
    It is a variant of the RTP Speex encoding defined in
    [RFC 5574](https://tools.ietf.org/html/rfc5574).
    The stream is a sequence of blocks, one block per RTP packet. Each block
    starts with a byte containing the length of the block, in bytes, followed
    by one or more frames of Speex data, padded to an integral number of
    bytes (octets) as specified in RFC 5574. In other words, each RTP header
    is replaced with a single byte containing the block length. Only Speex
    wideband is supported. `sample_rate_hertz` must be 16000.
    """

class AudioEncoding(_AudioEncoding, metaclass=_AudioEncodingEnumTypeWrapper):
    """Audio encoding of the audio content sent in the conversational query request.
    Refer to the [Cloud Speech API documentation](/speech/docs/basics) for more
    details.
    """

AUDIO_ENCODING_UNSPECIFIED: AudioEncoding.ValueType  # 0
"""Not specified."""
AUDIO_ENCODING_LINEAR_16: AudioEncoding.ValueType  # 1
"""Uncompressed 16-bit signed little-endian samples (Linear PCM)."""
AUDIO_ENCODING_FLAC: AudioEncoding.ValueType  # 2
"""[`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
Codec) is the recommended encoding because it is lossless (therefore
recognition is not compromised) and requires only about half the
bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
24-bit samples, however, not all fields in `STREAMINFO` are supported.
"""
AUDIO_ENCODING_MULAW: AudioEncoding.ValueType  # 3
"""8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law."""
AUDIO_ENCODING_AMR: AudioEncoding.ValueType  # 4
"""Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000."""
AUDIO_ENCODING_AMR_WB: AudioEncoding.ValueType  # 5
"""Adaptive Multi-Rate wideband codec. `sample_rate_hertz` must be 16000."""
AUDIO_ENCODING_OGG_OPUS: AudioEncoding.ValueType  # 6
"""Opus encoded audio frames in Ogg container
([OggOpus](https://wiki.xiph.org/OggOpus)).
`sample_rate_hertz` must be 16000.
"""
AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE: AudioEncoding.ValueType  # 7
"""Although the use of lossy encodings is not recommended, if a very low
bitrate encoding is required, `OGG_OPUS` is highly preferred over
Speex encoding. The [Speex](https://speex.org/) encoding supported by
Dialogflow API has a header byte in each block, as in MIME type
`audio/x-speex-with-header-byte`.
It is a variant of the RTP Speex encoding defined in
[RFC 5574](https://tools.ietf.org/html/rfc5574).
The stream is a sequence of blocks, one block per RTP packet. Each block
starts with a byte containing the length of the block, in bytes, followed
by one or more frames of Speex data, padded to an integral number of
bytes (octets) as specified in RFC 5574. In other words, each RTP header
is replaced with a single byte containing the block length. Only Speex
wideband is supported. `sample_rate_hertz` must be 16000.
"""
global___AudioEncoding = AudioEncoding

class _ComparisonOperator:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ComparisonOperatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ComparisonOperator.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EQUAL: _ComparisonOperator.ValueType  # 0
    """equal operator"""
    GREATER: _ComparisonOperator.ValueType  # 1
    """greater operator, e.g. for numbers, dates, and strings"""
    GREATER_OR_EQUAL: _ComparisonOperator.ValueType  # 2
    """greater or equal operator, e.g. for numbers, dates, and strings"""
    LESS_OR_EQUAL: _ComparisonOperator.ValueType  # 3
    """less or equal operator, e.g. for numbers, dates, and strings"""
    CONTAINS: _ComparisonOperator.ValueType  # 4
    """contains operator, e.g. part of string, or one of the elements in an iterable such as set or list"""
    STARTS_WITH: _ComparisonOperator.ValueType  # 5
    """starts with operator for string comparison only"""
    ENDS_WITH: _ComparisonOperator.ValueType  # 6
    """ends with operator for string comparison only"""

class ComparisonOperator(_ComparisonOperator, metaclass=_ComparisonOperatorEnumTypeWrapper):
    """Type of operator to compare"""

EQUAL: ComparisonOperator.ValueType  # 0
"""equal operator"""
GREATER: ComparisonOperator.ValueType  # 1
"""greater operator, e.g. for numbers, dates, and strings"""
GREATER_OR_EQUAL: ComparisonOperator.ValueType  # 2
"""greater or equal operator, e.g. for numbers, dates, and strings"""
LESS_OR_EQUAL: ComparisonOperator.ValueType  # 3
"""less or equal operator, e.g. for numbers, dates, and strings"""
CONTAINS: ComparisonOperator.ValueType  # 4
"""contains operator, e.g. part of string, or one of the elements in an iterable such as set or list"""
STARTS_WITH: ComparisonOperator.ValueType  # 5
"""starts with operator for string comparison only"""
ENDS_WITH: ComparisonOperator.ValueType  # 6
"""ends with operator for string comparison only"""
global___ComparisonOperator = ComparisonOperator

class _ResourceView:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResourceViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResourceView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RESOURCE_VIEW_UNSPECIFIED: _ResourceView.ValueType  # 0
    """Resource view not specified"""
    RESOURCE_VIEW_FULL: _ResourceView.ValueType  # 1
    """All fields are populated including bytes e.g., for audio files"""
    RESOURCE_VIEW_PARTIAL: _ResourceView.ValueType  # 2
    """Fields include metadata but no bytes"""
    RESOURCE_VIEW_MINIMUM: _ResourceView.ValueType  # 3
    """Minimum view only without bytes and metadata"""

class ResourceView(_ResourceView, metaclass=_ResourceViewEnumTypeWrapper):
    """Represents the options for views of resources."""

RESOURCE_VIEW_UNSPECIFIED: ResourceView.ValueType  # 0
"""Resource view not specified"""
RESOURCE_VIEW_FULL: ResourceView.ValueType  # 1
"""All fields are populated including bytes e.g., for audio files"""
RESOURCE_VIEW_PARTIAL: ResourceView.ValueType  # 2
"""Fields include metadata but no bytes"""
RESOURCE_VIEW_MINIMUM: ResourceView.ValueType  # 3
"""Minimum view only without bytes and metadata"""
global___ResourceView = ResourceView

class _AudioFileResourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AudioFileResourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AudioFileResourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUDIO_FILE_RESOURCE_TYPE_UNSPECIFIED: _AudioFileResourceType.ValueType  # 0
    """Unspecified audio file type"""
    AUDIO_FILE_RESOURCE_TYPE_T2S: _AudioFileResourceType.ValueType  # 1
    """Audio file from text to speech"""
    AUDIO_FILE_RESOURCE_TYPE_S2T: _AudioFileResourceType.ValueType  # 2
    """Audio file from speech to text"""
    AUDIO_FILE_RESOURCE_TYPE_S2T_AND_T2S: _AudioFileResourceType.ValueType  # 3
    """Audio file from speech to text and text to speech"""

class AudioFileResourceType(_AudioFileResourceType, metaclass=_AudioFileResourceTypeEnumTypeWrapper):
    """File type of an audio resource"""

AUDIO_FILE_RESOURCE_TYPE_UNSPECIFIED: AudioFileResourceType.ValueType  # 0
"""Unspecified audio file type"""
AUDIO_FILE_RESOURCE_TYPE_T2S: AudioFileResourceType.ValueType  # 1
"""Audio file from text to speech"""
AUDIO_FILE_RESOURCE_TYPE_S2T: AudioFileResourceType.ValueType  # 2
"""Audio file from speech to text"""
AUDIO_FILE_RESOURCE_TYPE_S2T_AND_T2S: AudioFileResourceType.ValueType  # 3
"""Audio file from speech to text and text to speech"""
global___AudioFileResourceType = AudioFileResourceType

@typing_extensions.final
class DetectIntentRequest(google.protobuf.message.Message):
    """The request to detect user's intent."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_FIELD_NUMBER: builtins.int
    QUERY_PARAMS_FIELD_NUMBER: builtins.int
    QUERY_INPUT_FIELD_NUMBER: builtins.int
    INPUT_AUDIO_FIELD_NUMBER: builtins.int
    session: builtins.str
    """Required. The name of the session this query is sent to. Format:
    `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
    caller to choose an appropriate session ID. It can be a random number or
    some type of user identifier (preferably hashed). The length of the session
    ID must not exceed 36 bytes.
    """
    @property
    def query_params(self) -> global___QueryParameters:
        """Optional. The parameters of this query."""
    @property
    def query_input(self) -> global___QueryInput:
        """Required. The input specification. It can be set to:

        1.  an audio config
            which instructs the speech recognizer how to process the speech audio,

        2.  a conversational query in the form of text, or

        3.  an event that specifies which intent to trigger.
        """
    input_audio: builtins.bytes
    """Optional. The natural language speech audio to be processed. This field
    should be populated iff `query_input` is set to an input audio config.
    A single request can contain up to 1 minute of speech audio data.
    """
    def __init__(
        self,
        *,
        session: builtins.str = ...,
        query_params: global___QueryParameters | None = ...,
        query_input: global___QueryInput | None = ...,
        input_audio: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_input", b"query_input", "query_params", b"query_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["input_audio", b"input_audio", "query_input", b"query_input", "query_params", b"query_params", "session", b"session"]) -> None: ...

global___DetectIntentRequest = DetectIntentRequest

@typing_extensions.final
class DetectIntentResponse(google.protobuf.message.Message):
    """The message returned from the DetectIntent method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_ID_FIELD_NUMBER: builtins.int
    QUERY_RESULT_FIELD_NUMBER: builtins.int
    WEBHOOK_STATUS_FIELD_NUMBER: builtins.int
    response_id: builtins.str
    """The unique identifier of the response. It can be used to
    locate a response in the training example set or for reporting issues.
    """
    @property
    def query_result(self) -> global___QueryResult:
        """The results of the conversational query or event processing."""
    @property
    def webhook_status(self) -> google.rpc.status_pb2.Status:
        """Specifies the status of the webhook request. `webhook_status`
        is never populated in webhook requests.
        """
    def __init__(
        self,
        *,
        response_id: builtins.str = ...,
        query_result: global___QueryResult | None = ...,
        webhook_status: google.rpc.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_result", b"query_result", "webhook_status", b"webhook_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["query_result", b"query_result", "response_id", b"response_id", "webhook_status", b"webhook_status"]) -> None: ...

global___DetectIntentResponse = DetectIntentResponse

@typing_extensions.final
class QueryParameters(google.protobuf.message.Message):
    """Represents the parameters of the conversational query."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_ZONE_FIELD_NUMBER: builtins.int
    GEO_LOCATION_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    RESET_CONTEXTS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PLATFORMS_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    PROPERTY_ID_FIELD_NUMBER: builtins.int
    DATASTREAM_ID_FIELD_NUMBER: builtins.int
    ORIGIN_ID_FIELD_NUMBER: builtins.int
    IDENTIFIED_USER_ID_FIELD_NUMBER: builtins.int
    TRANSCRIPTIONS_FIELD_NUMBER: builtins.int
    time_zone: builtins.str
    """Optional. The time zone of this conversational query from the
    [time zone database](https://www.iana.org/time-zones), e.g.,
    America/New_York, Europe/Paris. If not provided, the time zone specified in
    agent settings is used.
    """
    @property
    def geo_location(self) -> google.type.latlng_pb2.LatLng:
        """Optional. The geo location of this conversational query."""
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """Optional. The collection of contexts to be activated before this query is
        executed.
        """
    reset_contexts: builtins.bool
    """Optional. Specifies whether to delete all contexts in the current session
    before the new ones are activated.
    """
    @property
    def payload(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. This field can be used to pass custom data into the webhook
        associated with the agent. Arbitrary JSON objects are supported.
        key:<pre>language=LanguageCode.de.value</pre>
        key:<pre>timestamp=time.time()</pre>
        key:<pre>source='https://ondewo.com'</pre>
        key:<pre>configuration='config_example_123'</pre>
        """
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """labels associated to this request"""
    @property
    def platforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType]:
        """Only messages for the specified Intent.Message.Platform platforms are sent to the user in the
        <code>DetectIntentResponse</code>
        """
    account_id: builtins.str
    """Id of the account, e.g. Company Ondewo"""
    property_id: builtins.str
    """Id of the property of the account, e.g. Domain ondewo.com
    This field can also be used for a customized tracking id or tag id
    """
    datastream_id: builtins.str
    """Id of the datastream of the property of the account, e.g. Subdomain sub1.ondewo.com or sub2.ondewo.com
    This field can also be used for a customized tracking id or tag id
    """
    origin_id: builtins.str
    """Id of the the origin of the user request

    For a phone bot, this is the phone number +123456789 the user called (Note: This is not the user's phone number)
    For a chatbot or voicebot on the web, this is the URL on which the bo, e.g. https://ondewo.com/webchat
    For a voice assistant device, this is the device-id or the app id
    This field can also be used for a customized tracking id or tag id
    https://aim-develop.ondewo.com/
    """
    identified_user_id: builtins.str
    """Id of the "identified user" e.g. for a chatbot the email address or for a phone bot the phone number of the user
    This field can also be used for a customized tracking id or tag id
    """
    @property
    def transcriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S2tTranscription]:
        """transcriptions of the user input sorted by score"""
    def __init__(
        self,
        *,
        time_zone: builtins.str = ...,
        geo_location: google.type.latlng_pb2.LatLng | None = ...,
        contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        reset_contexts: builtins.bool = ...,
        payload: google.protobuf.struct_pb2.Struct | None = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
        platforms: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType] | None = ...,
        account_id: builtins.str = ...,
        property_id: builtins.str = ...,
        datastream_id: builtins.str = ...,
        origin_id: builtins.str = ...,
        identified_user_id: builtins.str = ...,
        transcriptions: collections.abc.Iterable[global___S2tTranscription] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geo_location", b"geo_location", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id", b"account_id", "contexts", b"contexts", "datastream_id", b"datastream_id", "geo_location", b"geo_location", "identified_user_id", b"identified_user_id", "labels", b"labels", "origin_id", b"origin_id", "payload", b"payload", "platforms", b"platforms", "property_id", b"property_id", "reset_contexts", b"reset_contexts", "time_zone", b"time_zone", "transcriptions", b"transcriptions"]) -> None: ...

global___QueryParameters = QueryParameters

@typing_extensions.final
class S2tTranscription(google.protobuf.message.Message):
    """Represents a speech-to-text transcription."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    AUDIO_RESOURCE_NAME_FIELD_NUMBER: builtins.int
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    DURATION_IN_S_FIELD_NUMBER: builtins.int
    TRANSCRIPTION_TYPE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """resource name of the transcription"""
    text: builtins.str
    """The transcribed text content."""
    score: builtins.float
    """Optional. A confidence score associated with the transcription.
    The score indicates the level of confidence in the accuracy of the transcription.
    It is a floating-point number, typically ranging from 0.0 (low confidence) to 1.0 (high confidence).
    """
    language_code: builtins.str
    """Optional. The detected language of the transcription.
    The language is represented by a string following language codes (e.g., "en" for English, "es" for Spanish).
    """
    audio_resource_name: builtins.str
    """the resource name of the audio file of the transcription"""
    pipeline_id: builtins.str
    """Optional. pipeline used for transcription. A pipeline ID. Example: "pipeline_1" """
    duration_in_s: builtins.float
    """Optional. Duration in seconds for transcription"""
    transcription_type: global___TranscriptionType.ValueType
    """Whether a speech-to-text engine or a human has transcribed the audio"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        text: builtins.str = ...,
        score: builtins.float = ...,
        language_code: builtins.str = ...,
        audio_resource_name: builtins.str = ...,
        pipeline_id: builtins.str = ...,
        duration_in_s: builtins.float = ...,
        transcription_type: global___TranscriptionType.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_resource_name", b"audio_resource_name", "created_at", b"created_at", "created_by", b"created_by", "duration_in_s", b"duration_in_s", "language_code", b"language_code", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "pipeline_id", b"pipeline_id", "score", b"score", "text", b"text", "transcription_type", b"transcription_type"]) -> None: ...

global___S2tTranscription = S2tTranscription

@typing_extensions.final
class QueryInput(google.protobuf.message.Message):
    """Represents the query input. It can contain either:

    1.  An audio config which
        instructs the speech recognizer how to process the speech audio.

    2.  A conversational query in the form of text,.

    3.  An event that specifies which intent to trigger.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_CONFIG_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    @property
    def audio_config(self) -> global___InputAudioConfig:
        """Instructs the speech recognizer how to process the speech audio."""
    @property
    def text(self) -> global___TextInput:
        """The natural language text to be processed."""
    @property
    def event(self) -> global___EventInput:
        """The event to be processed."""
    def __init__(
        self,
        *,
        audio_config: global___InputAudioConfig | None = ...,
        text: global___TextInput | None = ...,
        event: global___EventInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["audio_config", b"audio_config", "event", b"event", "input", b"input", "text", b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_config", b"audio_config", "event", b"event", "input", b"input", "text", b"text"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input", b"input"]) -> typing_extensions.Literal["audio_config", "text", "event"] | None: ...

global___QueryInput = QueryInput

@typing_extensions.final
class QueryResult(google.protobuf.message.Message):
    """Represents the result of conversational query or event processing."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_TEXT_FIELD_NUMBER: builtins.int
    SPEECH_RECOGNITION_CONFIDENCE_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    ALL_REQUIRED_PARAMS_PRESENT_FIELD_NUMBER: builtins.int
    FULFILLMENT_TEXT_FIELD_NUMBER: builtins.int
    FULFILLMENT_MESSAGES_FIELD_NUMBER: builtins.int
    WEBHOOK_SOURCE_FIELD_NUMBER: builtins.int
    WEBHOOK_PAYLOAD_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    INTENT_FIELD_NUMBER: builtins.int
    INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER: builtins.int
    QUERY_TEXT_ORIGINAL_FIELD_NUMBER: builtins.int
    DIAGNOSTIC_INFO_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    query_text: builtins.str
    """The original conversational query text:
    - If natural language text was provided as input, `query_text` contains
      a copy of the input.
    - If natural language speech audio was provided as input, `query_text`
      contains the speech recognition result. If speech recognizer produced
      multiple alternatives, a particular one is picked.
    - If an event was provided as input, `query_text` is not set.
    """
    speech_recognition_confidence: builtins.float
    """The Speech recognition confidence between 0.0 and 1.0. A higher number
    indicates an estimated greater likelihood that the recognized words are
    correct. The default of 0.0 is a sentinel value indicating that confidence
    was not set.

    You should not rely on this field as it isn't guaranteed to be accurate, or
    even set. In particular this field isn't set in Webhook calls and for
    StreamingDetectIntent since the streaming endpoint has separate confidence
    estimates per portion of the audio in StreamingRecognitionResult.
    """
    action: builtins.str
    """The action name from the matched intent."""
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """The collection of extracted parameters."""
    all_required_params_present: builtins.bool
    """This field is set to:
    - `false` if the matched intent has required parameters and not all of
       the required parameter values have been collected.
    - `true` if all required parameter values have been collected, or if the
       matched intent doesn't contain any required parameters.
    """
    fulfillment_text: builtins.str
    """The text to be pronounced to the user or shown on the screen."""
    @property
    def fulfillment_messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent.Message]:
        """The collection of rich messages to present to the user."""
    webhook_source: builtins.str
    """If the query was fulfilled by a webhook call, this field is set to the
    value of the `source` field returned in the webhook response.
    """
    @property
    def webhook_payload(self) -> google.protobuf.struct_pb2.Struct:
        """If the query was fulfilled by a webhook call, this field is set to the
        value of the `payload` field returned in the webhook response.
        """
    @property
    def output_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The collection of output contexts. If applicable,
        `output_contexts.parameters` contains entries with name
        `<parameter name>.original` containing the original parameter values
        before the query.
        """
    @property
    def intent(self) -> ondewo.nlu.intent_pb2.Intent:
        """The intent that matched the conversational query. Some, not
        all fields are filled in this message, including but not limited to:
        `name`, `display_name` and `webhook_state`.
        """
    intent_detection_confidence: builtins.float
    """The intent detection confidence. Values range from 0.0
    (completely uncertain) to 1.0 (completely certain).
    """
    query_text_original: builtins.str
    """The user input gets pre-processed by spelling correction, stop word removal etc. This property holds
    the string that is passed to the entity recognition and intent detection
    """
    @property
    def diagnostic_info(self) -> google.protobuf.struct_pb2.Struct:
        """The free-form diagnostic info. For example, this field
        could contain webhook call latency.
        """
    language_code: builtins.str
    """The language that was triggered during intent detection.
    See [Language Support](https://dialogflow.com/docs/reference/language)
    for a list of the currently supported language codes.
    """
    def __init__(
        self,
        *,
        query_text: builtins.str = ...,
        speech_recognition_confidence: builtins.float = ...,
        action: builtins.str = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
        all_required_params_present: builtins.bool = ...,
        fulfillment_text: builtins.str = ...,
        fulfillment_messages: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message] | None = ...,
        webhook_source: builtins.str = ...,
        webhook_payload: google.protobuf.struct_pb2.Struct | None = ...,
        output_contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        intent: ondewo.nlu.intent_pb2.Intent | None = ...,
        intent_detection_confidence: builtins.float = ...,
        query_text_original: builtins.str = ...,
        diagnostic_info: google.protobuf.struct_pb2.Struct | None = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["diagnostic_info", b"diagnostic_info", "intent", b"intent", "parameters", b"parameters", "webhook_payload", b"webhook_payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "all_required_params_present", b"all_required_params_present", "diagnostic_info", b"diagnostic_info", "fulfillment_messages", b"fulfillment_messages", "fulfillment_text", b"fulfillment_text", "intent", b"intent", "intent_detection_confidence", b"intent_detection_confidence", "language_code", b"language_code", "output_contexts", b"output_contexts", "parameters", b"parameters", "query_text", b"query_text", "query_text_original", b"query_text_original", "speech_recognition_confidence", b"speech_recognition_confidence", "webhook_payload", b"webhook_payload", "webhook_source", b"webhook_source"]) -> None: ...

global___QueryResult = QueryResult

@typing_extensions.final
class StreamingDetectIntentRequest(google.protobuf.message.Message):
    """The top-level message sent by the client to the
    `StreamingDetectIntent` method.

    Multiple request messages should be sent in order:

    1.  The first message must contain `session`, `query_input` plus optionally
        `query_params` and/or `single_utterance`. The message must not contain `input_audio`.

    2.  If `query_input` was set to a streaming input audio config,
        all subsequent messages must contain only `input_audio`.
        Otherwise, finish the request stream.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_FIELD_NUMBER: builtins.int
    QUERY_PARAMS_FIELD_NUMBER: builtins.int
    QUERY_INPUT_FIELD_NUMBER: builtins.int
    SINGLE_UTTERANCE_FIELD_NUMBER: builtins.int
    INPUT_AUDIO_FIELD_NUMBER: builtins.int
    session: builtins.str
    """Required. The name of the session the query is sent to.
    Format of the session name:
    `projects/<Project ID>/agent/sessions/<Session ID>`. It’s up to the API
    caller to choose an appropriate <Session ID>. It can be a random number or
    some type of user identifier (preferably hashed). The length of the session
    ID must not exceed 36 characters.
    """
    @property
    def query_params(self) -> global___QueryParameters:
        """Optional. The parameters of this query."""
    @property
    def query_input(self) -> global___QueryInput:
        """Required. The input specification. It can be set to:

        1.  an audio config which instructs the speech recognizer how to process
            the speech audio,

        2.  a conversational query in the form of text, or

        3.  an event that specifies which intent to trigger.
        """
    single_utterance: builtins.bool
    """Optional. If `false` (default), recognition does not cease until the
    client closes the stream.
    If `true`, the recognizer will detect a single spoken utterance in input
    audio. Recognition ceases when it detects the audio's voice has
    stopped or paused. In this case, once a detected intent is received, the
    client should close the stream and start a new request with a new stream as
    needed.
    This setting is ignored when `query_input` is a piece of text or an event.
    """
    input_audio: builtins.bytes
    """Optional. The input audio content to be recognized. Must be sent if
    `query_input` was set to a streaming input audio config. The complete audio
    over all streaming messages must not exceed 1 minute.
    """
    def __init__(
        self,
        *,
        session: builtins.str = ...,
        query_params: global___QueryParameters | None = ...,
        query_input: global___QueryInput | None = ...,
        single_utterance: builtins.bool = ...,
        input_audio: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_input", b"query_input", "query_params", b"query_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["input_audio", b"input_audio", "query_input", b"query_input", "query_params", b"query_params", "session", b"session", "single_utterance", b"single_utterance"]) -> None: ...

global___StreamingDetectIntentRequest = StreamingDetectIntentRequest

@typing_extensions.final
class StreamingDetectIntentResponse(google.protobuf.message.Message):
    """The top-level message returned from the
    `StreamingDetectIntent` method.

    Multiple response messages can be returned in order:

    1.  If the input was set to streaming audio, the first one or more messages
        contain `recognition_result`. Each `recognition_result` represents a more
        complete transcript of what the user said. The last `recognition_result`
        has `is_final` set to `true`.

    2.  The next message contains `response_id`, `query_result`
        and optionally `webhook_status` if a WebHook was called.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_ID_FIELD_NUMBER: builtins.int
    RECOGNITION_RESULT_FIELD_NUMBER: builtins.int
    QUERY_RESULT_FIELD_NUMBER: builtins.int
    WEBHOOK_STATUS_FIELD_NUMBER: builtins.int
    response_id: builtins.str
    """The unique identifier of the response. It can be used to
    locate a response in the training example set or for reporting issues.
    """
    @property
    def recognition_result(self) -> global___StreamingRecognitionResult:
        """The result of speech recognition."""
    @property
    def query_result(self) -> global___QueryResult:
        """The result of the conversational query or event processing."""
    @property
    def webhook_status(self) -> google.rpc.status_pb2.Status:
        """Specifies the status of the webhook request."""
    def __init__(
        self,
        *,
        response_id: builtins.str = ...,
        recognition_result: global___StreamingRecognitionResult | None = ...,
        query_result: global___QueryResult | None = ...,
        webhook_status: google.rpc.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_result", b"query_result", "recognition_result", b"recognition_result", "webhook_status", b"webhook_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["query_result", b"query_result", "recognition_result", b"recognition_result", "response_id", b"response_id", "webhook_status", b"webhook_status"]) -> None: ...

global___StreamingDetectIntentResponse = StreamingDetectIntentResponse

@typing_extensions.final
class StreamingRecognitionResult(google.protobuf.message.Message):
    """Contains a speech recognition result corresponding to a portion of the audio
    that is currently being processed or an indication that this is the end
    of the single requested utterance.

    Example:

    1.  transcript: "tube"

    2.  transcript: "to be a"

    3.  transcript: "to be"

    4.  transcript: "to be or not to be"
        is_final: true

    5.  transcript: " that's"

    6.  transcript: " that is"

    7.  recognition_event_type: `RECOGNITION_EVENT_END_OF_SINGLE_UTTERANCE`

    8.  transcript: " that is the question"
        is_final: true

    Only two of the responses contain final results (#4 and #8 indicated by
    `is_final: true`). Concatenating these generates the full transcript: "to be
    or not to be that is the question".

    In each response we populate:

    *  for `MESSAGE_TYPE_TRANSCRIPT`: `transcript` and possibly `is_final`.

    *  for `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`: only `event_type`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MessageType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MessageTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamingRecognitionResult._MessageType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESSAGE_TYPE_UNSPECIFIED: StreamingRecognitionResult._MessageType.ValueType  # 0
        """Not specified. Should never be used."""
        TRANSCRIPT: StreamingRecognitionResult._MessageType.ValueType  # 1
        """Message contains a (possibly partial) transcript."""
        END_OF_SINGLE_UTTERANCE: StreamingRecognitionResult._MessageType.ValueType  # 2
        """Event indicates that the server has detected the end of the user's speech
        utterance and expects no additional speech. Therefore, the server will
        not process additional audio (although it may subsequently return
        additional results). The client should stop sending additional audio
        data, half-close the gRPC connection, and wait for any additional results
        until the server closes the gRPC connection. This message is only sent if
        `single_utterance` was set to `true`, and is not used otherwise.
        """

    class MessageType(_MessageType, metaclass=_MessageTypeEnumTypeWrapper):
        """Type of the response message."""

    MESSAGE_TYPE_UNSPECIFIED: StreamingRecognitionResult.MessageType.ValueType  # 0
    """Not specified. Should never be used."""
    TRANSCRIPT: StreamingRecognitionResult.MessageType.ValueType  # 1
    """Message contains a (possibly partial) transcript."""
    END_OF_SINGLE_UTTERANCE: StreamingRecognitionResult.MessageType.ValueType  # 2
    """Event indicates that the server has detected the end of the user's speech
    utterance and expects no additional speech. Therefore, the server will
    not process additional audio (although it may subsequently return
    additional results). The client should stop sending additional audio
    data, half-close the gRPC connection, and wait for any additional results
    until the server closes the gRPC connection. This message is only sent if
    `single_utterance` was set to `true`, and is not used otherwise.
    """

    MESSAGE_TYPE_FIELD_NUMBER: builtins.int
    TRANSCRIPT_FIELD_NUMBER: builtins.int
    IS_FINAL_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    message_type: global___StreamingRecognitionResult.MessageType.ValueType
    """Type of the result message."""
    transcript: builtins.str
    """Transcript text representing the words that the user spoke.
    Populated if and only if `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
    """
    is_final: builtins.bool
    """The default of 0.0 is a sentinel value indicating `confidence` was not set.
    If `false`, the `StreamingRecognitionResult` represents an
    interim result that may change. If `true`, the recognizer will not return
    any further hypotheses about this piece of the audio. May only be populated
    for `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
    """
    confidence: builtins.float
    """The Speech confidence between 0.0 and 1.0 for the current portion of audio.
    A higher number indicates an estimated greater likelihood that the
    recognized words are correct. The default of 0.0 is a sentinel value
    indicating that confidence was not set.

    This field is typically only provided if `is_final` is true and you should
    not rely on it being accurate or even set.
    """
    def __init__(
        self,
        *,
        message_type: global___StreamingRecognitionResult.MessageType.ValueType = ...,
        transcript: builtins.str = ...,
        is_final: builtins.bool = ...,
        confidence: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["confidence", b"confidence", "is_final", b"is_final", "message_type", b"message_type", "transcript", b"transcript"]) -> None: ...

global___StreamingRecognitionResult = StreamingRecognitionResult

@typing_extensions.final
class InputAudioConfig(google.protobuf.message.Message):
    """Instructs the speech recognizer how to process the audio content."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_ENCODING_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_HERTZ_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PHRASE_HINTS_FIELD_NUMBER: builtins.int
    audio_encoding: global___AudioEncoding.ValueType
    """Required. Audio encoding of the audio content to process."""
    sample_rate_hertz: builtins.int
    """Required. Sample rate (in Hertz) of the audio content sent in the query.
    Refer to [Cloud Speech API documentation](/speech/docs/basics) for more
    details.
    """
    language_code: builtins.str
    """Required. The language of the supplied audio. Dialogflow does not do
    translations. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """
    @property
    def phrase_hints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The collection of phrase hints which are used to boost accuracy
        of speech recognition.
        Refer to [Cloud Speech API documentation](/speech/docs/basics#phrase-hints)
        for more details.
        """
    def __init__(
        self,
        *,
        audio_encoding: global___AudioEncoding.ValueType = ...,
        sample_rate_hertz: builtins.int = ...,
        language_code: builtins.str = ...,
        phrase_hints: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_encoding", b"audio_encoding", "language_code", b"language_code", "phrase_hints", b"phrase_hints", "sample_rate_hertz", b"sample_rate_hertz"]) -> None: ...

global___InputAudioConfig = InputAudioConfig

@typing_extensions.final
class TextInput(google.protobuf.message.Message):
    """Represents the natural language text to be processed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Required. The UTF-8 encoded natural language text to be processed.
    Text length must not exceed 256 bytes.
    """
    language_code: builtins.str
    """Required. The language of this conversational query. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "text", b"text"]) -> None: ...

global___TextInput = TextInput

@typing_extensions.final
class EventInput(google.protobuf.message.Message):
    """Events allow for matching intents by event name instead of the natural
    language input. For instance, input `<event: { name: “welcome_event”,
    parameters: { name: “Sam” } }>` can trigger a personalized welcome response.
    The parameter `name` may be used by the agent in the response:
    `“Hello #welcome_event.name! What can I do for you today?”`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Required. The unique identifier of the event."""
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. The collection of parameters associated with the event."""
    language_code: builtins.str
    """Required. The language of this query. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
        language_code: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code", b"language_code", "name", b"name", "parameters", b"parameters"]) -> None: ...

global___EventInput = EventInput

@typing_extensions.final
class Session(google.protobuf.message.Message):
    """*** SESSION RELATED MESSAGES *** //

    Session of a user interaction
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Session._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: Session._View.ValueType  # 0
        """Endpoints decide whether to return the full or the sparse view"""
        VIEW_FULL: Session._View.ValueType  # 1
        """All fields are populated."""
        VIEW_SPARSE: Session._View.ValueType  # 2
        """Only some fields are populated in the response."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """Represents the options for views of a session.
        A session can be a sizable object. Therefore, we provide a resource view that
        does not return all data
        """

    VIEW_UNSPECIFIED: Session.View.ValueType  # 0
    """Endpoints decide whether to return the full or the sparse view"""
    VIEW_FULL: Session.View.ValueType  # 1
    """All fields are populated."""
    VIEW_SPARSE: Session.View.ValueType  # 2
    """Only some fields are populated in the response."""

    NAME_FIELD_NUMBER: builtins.int
    SESSION_STEPS_FIELD_NUMBER: builtins.int
    SESSION_INFO_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique identifier of the session
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    @property
    def session_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionStep]:
        """The list of all the steps of the session"""
    @property
    def session_info(self) -> global___SessionInfo:
        """session information"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        session_steps: collections.abc.Iterable[global___SessionStep] | None = ...,
        session_info: global___SessionInfo | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at", "session_info", b"session_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "session_info", b"session_info", "session_steps", b"session_steps"]) -> None: ...

global___Session = Session

@typing_extensions.final
class SessionStep(google.protobuf.message.Message):
    """SessionStep is a single user interaction as part of a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DETECT_INTENT_REQUEST_FIELD_NUMBER: builtins.int
    DETECT_INTENT_RESPONSE_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    AUDIO_FILE_RESOURCES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique identifier for the given review
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/steps/&lt;session_step_uuid&gt;</code></pre>
    """
    @property
    def detect_intent_request(self) -> global___DetectIntentRequest:
        """The detect intent request of the session step"""
    @property
    def detect_intent_response(self) -> global___DetectIntentResponse:
        """The detect intent response  of the session step"""
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The contexts which were active at the beginning of this step"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of session step"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    @property
    def audio_file_resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """audio file resources associated with the session step"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        detect_intent_request: global___DetectIntentRequest | None = ...,
        detect_intent_response: global___DetectIntentResponse | None = ...,
        contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
        audio_file_resources: collections.abc.Iterable[global___AudioFileResource] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "detect_intent_request", b"detect_intent_request", "detect_intent_response", b"detect_intent_response", "modified_at", b"modified_at", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_file_resources", b"audio_file_resources", "contexts", b"contexts", "created_at", b"created_at", "created_by", b"created_by", "detect_intent_request", b"detect_intent_request", "detect_intent_response", b"detect_intent_response", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "timestamp", b"timestamp"]) -> None: ...

global___SessionStep = SessionStep

@typing_extensions.final
class TrackSessionStepRequest(google.protobuf.message.Message):
    """TrackSessionStepRequest stores a session step into the session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_STEP_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The unique identifier for the given review
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/steps/&lt;session_step_uuid&gt;</code></pre>.
    """
    @property
    def session_step(self) -> global___SessionStep:
        """The session step to be added"""
    session_view: global___Session.View.ValueType
    """Defines which fields of the session should be returned in the response"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        session_step: global___SessionStep | None = ...,
        session_view: global___Session.View.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_step", b"session_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id", b"session_id", "session_step", b"session_step", "session_view", b"session_view"]) -> None: ...

global___TrackSessionStepRequest = TrackSessionStepRequest

@typing_extensions.final
class ListSessionsRequest(google.protobuf.message.Message):
    """This message is a request to list sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    session_view: global___Session.View.ValueType
    """An enum specifying the amount of information to be returned per session"""
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which fields will be filled with data.
        Example: path=["session_info.duration_in_s_min"]
        """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_view: global___Session.View.ValueType = ...,
        page_token: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "page_token", b"page_token", "parent", b"parent", "session_filter", b"session_filter", "session_view", b"session_view"]) -> None: ...

global___ListSessionsRequest = ListSessionsRequest

@typing_extensions.final
class ContextFilter(google.protobuf.message.Message):
    """Message used to filter sessions based on contextual information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXT_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    OPERATOR_FIELD_NUMBER: builtins.int
    context_name: builtins.str
    """name of the context"""
    key: builtins.str
    """name of the key of the context parameter"""
    value: builtins.str
    """value of the parameter"""
    operator: global___ComparisonOperator.ValueType
    def __init__(
        self,
        *,
        context_name: builtins.str = ...,
        key: builtins.str = ...,
        value: builtins.str = ...,
        operator: global___ComparisonOperator.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["context_name", b"context_name", "key", b"key", "operator", b"operator", "value", b"value"]) -> None: ...

global___ContextFilter = ContextFilter

@typing_extensions.final
class SessionFilter(google.protobuf.message.Message):
    """This message contains a session filter"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    MATCHED_INTENTS_FIELD_NUMBER: builtins.int
    MATCHED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_MIN_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_MAX_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_MIN_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_MAX_FIELD_NUMBER: builtins.int
    EARLIEST_FIELD_NUMBER: builtins.int
    LATEST_FIELD_NUMBER: builtins.int
    MIN_NUMBER_TURNS_FIELD_NUMBER: builtins.int
    MAX_NUMBER_TURNS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    INTENT_TAGS_FIELD_NUMBER: builtins.int
    SESSION_IDS_FIELD_NUMBER: builtins.int
    INPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    DURATION_IN_S_MIN_FIELD_NUMBER: builtins.int
    DURATION_IN_S_MAX_FIELD_NUMBER: builtins.int
    DURATION_IN_M_MIN_FIELD_NUMBER: builtins.int
    DURATION_IN_M_MAX_FIELD_NUMBER: builtins.int
    DURATION_IN_M_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_IN_M_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_15S_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_15S_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_30S_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_30S_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_45S_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_45S_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HOUR_MIN_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HOUR_MAX_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_QUARTER_HOUR_MIN_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_QUARTER_HOUR_MAX_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HALF_HOUR_MIN_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HALF_HOUR_MAX_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_DAY_PHASE_MIN_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_DAY_PHASE_MAX_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_MINUTE_MIN_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_MINUTE_MAX_FIELD_NUMBER: builtins.int
    DURATION_IN_S_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_IN_S_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    PLATFORMS_FIELD_NUMBER: builtins.int
    ACCOUNT_IDS_FIELD_NUMBER: builtins.int
    PROPERTY_IDS_FIELD_NUMBER: builtins.int
    DATASTREAM_IDS_FIELD_NUMBER: builtins.int
    ORIGIN_IDS_FIELD_NUMBER: builtins.int
    IDENTIFIED_USER_IDS_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_60S_ROUNDED_MIN_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_60S_ROUNDED_MAX_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A SessionFilter can be used in some requests to return only sessions matching certain filter conditions.
        All fields below are optional. Multiple fields specified at the same time are chained via AND.
        Match only sessions with all of the following language_codes
        """
    @property
    def matched_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent]:
        """Match only sessions during which all of the following intents were detected
        NOTE: only name and display name fields are used for comparison
        """
    @property
    def matched_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """Match only sessions during which all of the following entity types were recognized
        NOTE: only name and display name fields are used for comparison
        """
    min_intents_confidence_min: builtins.float
    """Match only sessions where the minimum confidence for intent detection along the session falls
    in the following range. Defaults to -1 if not set.
    """
    min_intents_confidence_max: builtins.float
    """Match only sessions where the minimum confidence for intent detection along the session falls
    in the following range. Defaults to +1 if not set.
    """
    min_entity_types_confidence_min: builtins.float
    """Match only sessions where the minimum confidence for entity recognition along the session falls
     in the following range. Defaults to -1 if not set.
    """
    min_entity_types_confidence_max: builtins.float
    """Match only sessions where the minimum confidence for entity recognition along the session falls
     in the following range. Defaults to +1 if not set.
    """
    earliest: builtins.float
    """Match only sessions whose time range falls within the following range (in UNIX epochs).
    Defaults to 0 if not set.
    """
    latest: builtins.float
    """Match only sessions whose time range falls within the following range (in UNIX epochs).
    Defaults to current epoch if not set
    """
    min_number_turns: builtins.int
    """Match only sessions for which the number of turns (interaction steps) falls in the following range
    Defaults to 0 if not set.
    """
    max_number_turns: builtins.int
    """Match only sessions for which the number of turns (interaction steps) falls in the following range
    Defaults to MAXINT if not set.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Match only session which have all of the following labels assigned"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Match only session which had all of the following user_ids interacting with them."""
    @property
    def intent_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Match only session which have all of the following intent tags assigned"""
    @property
    def session_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Match only sessions whose IDs are specified here"""
    @property
    def input_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """Match only sessions whose session info contains at least one step having all the contexts specified here
        The input contexts are pre-conditions for detecting intents
        """
    @property
    def output_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The output contexts are the result of the intent matching and track the contextual state of a conversation"""
    duration_in_s_min: builtins.float
    """Match only sessions for which the duration in seconds are larger or equal"""
    duration_in_s_max: builtins.float
    """Match only sessions for which the duration in seconds are smaller or equal"""
    duration_in_m_min: builtins.float
    """Match only sessions for which the duration in minutes are larger or equal"""
    duration_in_m_max: builtins.float
    """Match only sessions for which the duration in minutes are smaller or equal"""
    duration_in_m_rounded_min: builtins.float
    """Match only sessions for which the duration in minutes rounded are larger or equal"""
    duration_in_m_rounded_max: builtins.float
    """Match only sessions for which the duration in minutes rounded are smaller or equal"""
    duration_interval_15s_rounded_min: builtins.float
    """Match only sessions for which the duration in 15 seconds rounded are larger or equal"""
    duration_interval_15s_rounded_max: builtins.float
    """Match only sessions for which the duration in 15 seconds rounded are smaller or equal"""
    duration_interval_30s_rounded_min: builtins.float
    """Match only sessions for which the duration in 30 seconds rounded are larger or equal"""
    duration_interval_30s_rounded_max: builtins.float
    """Match only sessions for which the duration in 30 seconds rounded are smaller or equal"""
    duration_interval_45s_rounded_min: builtins.float
    """Match only sessions for which the duration in 45 seconds rounded are larger or equal"""
    duration_interval_45s_rounded_max: builtins.float
    """Match only sessions for which the duration in 45 seconds rounded are smaller or equal"""
    started_time_slot_per_hour_min: builtins.str
    """Match only sessions for which the started_time_slot_per_hour (e.g. 08:00) are larger or equal"""
    started_time_slot_per_hour_max: builtins.str
    """Match only sessions for which the started_time_slot_per_hour (e.g. 14:00) are smaller or equal"""
    started_time_slot_per_quarter_hour_min: builtins.str
    """Match only sessions for which the started_time_slot_per_quarter_hour (e.g. 08:00) are larger or equal"""
    started_time_slot_per_quarter_hour_max: builtins.str
    """Match only sessions for which the started_time_slot_per_quarter_hour (e.g. 14:00) are smaller or equal"""
    started_time_slot_per_half_hour_min: builtins.str
    """Match only sessions for which the started_time_slot_per_half_hour (e.g. 08:00) are larger or equal"""
    started_time_slot_per_half_hour_max: builtins.str
    """Match only sessions for which the started_time_slot_per_half_hour (e.g. 14:00) are smaller or equal"""
    started_time_slot_per_day_phase_min: builtins.str
    """Match only sessions for which the started_time_slot_per_day_phase (e.g. 08:00) are larger or equal"""
    started_time_slot_per_day_phase_max: builtins.str
    """Match only sessions for which the started_time_slot_per_day_phase (e.g. 14:00) are smaller or equal"""
    started_time_slot_per_minute_min: builtins.str
    """Match only sessions for which the started_time_slot_per_minute (e.g. 08:00) are larger or equal"""
    started_time_slot_per_minute_max: builtins.str
    """Match only sessions for which the started_time_slot_per_minute (e.g. 14:00) are smaller or equal"""
    duration_in_s_rounded_min: builtins.float
    """Match only sessions for which the duration in seconds rounded are larger or equal"""
    duration_in_s_rounded_max: builtins.float
    """Match only sessions for which the duration in seconds rounded are smaller or equal"""
    @property
    def platforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType]:
        """Messages for each of the Intent.Message.Platform were sent to the user"""
    @property
    def account_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the account, e.g. Company Ondewo,
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def property_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the property of the account, e.g. Domain ondewo.com
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def datastream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the datastream of the property of the account, e.g. Subdomain sub1.ondewo.com or sub2.ondewo.com
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def origin_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the the origin of the user request

        For a phone bot, this is the phone number +123456789 the user called (Note: This is not the user's phone number)
        For a chatbot or voicebot on the web, this is the URL on which the bo, e.g. https://ondewo.com/webchat
        For a voice assistant device, this is the device-id or the app id
        """
    @property
    def identified_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the "identified user" e.g. for a chatbot the email address or for a phone bot the phone number of the user"""
    duration_interval_60s_rounded_min: builtins.float
    """Match only sessions for which the duration in 60 seconds rounded are larger or equal"""
    duration_interval_60s_rounded_max: builtins.float
    """Match only sessions for which the duration in 60 seconds rounded are smaller or equal"""
    def __init__(
        self,
        *,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        matched_intents: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent] | None = ...,
        matched_entity_types: collections.abc.Iterable[ondewo.nlu.entity_type_pb2.EntityType] | None = ...,
        min_intents_confidence_min: builtins.float = ...,
        min_intents_confidence_max: builtins.float = ...,
        min_entity_types_confidence_min: builtins.float = ...,
        min_entity_types_confidence_max: builtins.float = ...,
        earliest: builtins.float = ...,
        latest: builtins.float = ...,
        min_number_turns: builtins.int = ...,
        max_number_turns: builtins.int = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        intent_tags: collections.abc.Iterable[builtins.str] | None = ...,
        session_ids: collections.abc.Iterable[builtins.str] | None = ...,
        input_contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        output_contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        duration_in_s_min: builtins.float = ...,
        duration_in_s_max: builtins.float = ...,
        duration_in_m_min: builtins.float = ...,
        duration_in_m_max: builtins.float = ...,
        duration_in_m_rounded_min: builtins.float = ...,
        duration_in_m_rounded_max: builtins.float = ...,
        duration_interval_15s_rounded_min: builtins.float = ...,
        duration_interval_15s_rounded_max: builtins.float = ...,
        duration_interval_30s_rounded_min: builtins.float = ...,
        duration_interval_30s_rounded_max: builtins.float = ...,
        duration_interval_45s_rounded_min: builtins.float = ...,
        duration_interval_45s_rounded_max: builtins.float = ...,
        started_time_slot_per_hour_min: builtins.str = ...,
        started_time_slot_per_hour_max: builtins.str = ...,
        started_time_slot_per_quarter_hour_min: builtins.str = ...,
        started_time_slot_per_quarter_hour_max: builtins.str = ...,
        started_time_slot_per_half_hour_min: builtins.str = ...,
        started_time_slot_per_half_hour_max: builtins.str = ...,
        started_time_slot_per_day_phase_min: builtins.str = ...,
        started_time_slot_per_day_phase_max: builtins.str = ...,
        started_time_slot_per_minute_min: builtins.str = ...,
        started_time_slot_per_minute_max: builtins.str = ...,
        duration_in_s_rounded_min: builtins.float = ...,
        duration_in_s_rounded_max: builtins.float = ...,
        platforms: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType] | None = ...,
        account_ids: collections.abc.Iterable[builtins.str] | None = ...,
        property_ids: collections.abc.Iterable[builtins.str] | None = ...,
        datastream_ids: collections.abc.Iterable[builtins.str] | None = ...,
        origin_ids: collections.abc.Iterable[builtins.str] | None = ...,
        identified_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        duration_interval_60s_rounded_min: builtins.float = ...,
        duration_interval_60s_rounded_max: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_ids", b"account_ids", "datastream_ids", b"datastream_ids", "duration_in_m_max", b"duration_in_m_max", "duration_in_m_min", b"duration_in_m_min", "duration_in_m_rounded_max", b"duration_in_m_rounded_max", "duration_in_m_rounded_min", b"duration_in_m_rounded_min", "duration_in_s_max", b"duration_in_s_max", "duration_in_s_min", b"duration_in_s_min", "duration_in_s_rounded_max", b"duration_in_s_rounded_max", "duration_in_s_rounded_min", b"duration_in_s_rounded_min", "duration_interval_15s_rounded_max", b"duration_interval_15s_rounded_max", "duration_interval_15s_rounded_min", b"duration_interval_15s_rounded_min", "duration_interval_30s_rounded_max", b"duration_interval_30s_rounded_max", "duration_interval_30s_rounded_min", b"duration_interval_30s_rounded_min", "duration_interval_45s_rounded_max", b"duration_interval_45s_rounded_max", "duration_interval_45s_rounded_min", b"duration_interval_45s_rounded_min", "duration_interval_60s_rounded_max", b"duration_interval_60s_rounded_max", "duration_interval_60s_rounded_min", b"duration_interval_60s_rounded_min", "earliest", b"earliest", "identified_user_ids", b"identified_user_ids", "input_contexts", b"input_contexts", "intent_tags", b"intent_tags", "labels", b"labels", "language_codes", b"language_codes", "latest", b"latest", "matched_entity_types", b"matched_entity_types", "matched_intents", b"matched_intents", "max_number_turns", b"max_number_turns", "min_entity_types_confidence_max", b"min_entity_types_confidence_max", "min_entity_types_confidence_min", b"min_entity_types_confidence_min", "min_intents_confidence_max", b"min_intents_confidence_max", "min_intents_confidence_min", b"min_intents_confidence_min", "min_number_turns", b"min_number_turns", "origin_ids", b"origin_ids", "output_contexts", b"output_contexts", "platforms", b"platforms", "property_ids", b"property_ids", "session_ids", b"session_ids", "started_time_slot_per_day_phase_max", b"started_time_slot_per_day_phase_max", "started_time_slot_per_day_phase_min", b"started_time_slot_per_day_phase_min", "started_time_slot_per_half_hour_max", b"started_time_slot_per_half_hour_max", "started_time_slot_per_half_hour_min", b"started_time_slot_per_half_hour_min", "started_time_slot_per_hour_max", b"started_time_slot_per_hour_max", "started_time_slot_per_hour_min", b"started_time_slot_per_hour_min", "started_time_slot_per_minute_max", b"started_time_slot_per_minute_max", "started_time_slot_per_minute_min", b"started_time_slot_per_minute_min", "started_time_slot_per_quarter_hour_max", b"started_time_slot_per_quarter_hour_max", "started_time_slot_per_quarter_hour_min", b"started_time_slot_per_quarter_hour_min", "user_ids", b"user_ids"]) -> None: ...

global___SessionFilter = SessionFilter

@typing_extensions.final
class SessionInfo(google.protobuf.message.Message):
    """This message contains information about session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ContextSteps(google.protobuf.message.Message):
        """The list of contexts of each step collected in an outer list"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONTEXTS_FIELD_NUMBER: builtins.int
        @property
        def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]: ...
        def __init__(
            self,
            *,
            contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["contexts", b"contexts"]) -> None: ...

    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    MATCHED_INTENTS_FIELD_NUMBER: builtins.int
    MATCHED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_FIELD_NUMBER: builtins.int
    EARLIEST_FIELD_NUMBER: builtins.int
    LATEST_FIELD_NUMBER: builtins.int
    NUMBER_TURNS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    INTENT_TAGS_FIELD_NUMBER: builtins.int
    INPUT_CONTEXT_STEPS_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXT_STEPS_FIELD_NUMBER: builtins.int
    DURATION_IN_S_FIELD_NUMBER: builtins.int
    DURATION_IN_M_FIELD_NUMBER: builtins.int
    DURATION_IN_M_ROUNDED_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_15S_ROUNDED_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_30S_ROUNDED_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_45S_ROUNDED_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HOUR_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_QUARTER_HOUR_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_HALF_HOUR_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_DAY_PHASE_FIELD_NUMBER: builtins.int
    STARTED_TIME_SLOT_PER_MINUTE_FIELD_NUMBER: builtins.int
    DURATION_IN_S_ROUNDED_FIELD_NUMBER: builtins.int
    PLATFORMS_FIELD_NUMBER: builtins.int
    ACCOUNT_IDS_FIELD_NUMBER: builtins.int
    PROPERTY_IDS_FIELD_NUMBER: builtins.int
    DATASTREAM_IDS_FIELD_NUMBER: builtins.int
    ORIGIN_IDS_FIELD_NUMBER: builtins.int
    IDENTIFIED_USER_IDS_FIELD_NUMBER: builtins.int
    DURATION_INTERVAL_60S_ROUNDED_FIELD_NUMBER: builtins.int
    PARENT_COMMENT_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A SessionInfo contains some general information about a session.

        This information can be returned inside a Session object for consumption by a client.
        Or it can be used by the backend to check whether the Session matches a given SessionFilter.

        All fields below are optional. Multiple fields specified at the same time are chained
        The language codes used in the given session.
        """
    @property
    def matched_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent]:
        """A list of intents which have been matched"""
    @property
    def matched_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """A list of entity types which have been matched"""
    min_intents_confidence: builtins.float
    """The minimum confidence for intent recognition along the session"""
    min_entity_types_confidence: builtins.float
    """The minimum confidence for entity recognition along the session"""
    earliest: builtins.float
    """The earliest date of the given session (in UNIX epochs), i.e. the time of the first interaction of a user
    in the given session
    """
    latest: builtins.float
    """The latest date of the given session (in UNIX epochs), i.e. the time of the last interaction of a user
    in the given session
    """
    number_turns: builtins.int
    """The number of turns (interaction steps) in the given session"""
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of labels of the given session"""
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The user_ids of the users which were interacting within the given session"""
    @property
    def intent_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of intent tags in the given session"""
    @property
    def input_context_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionInfo.ContextSteps]:
        """The input contexts that are matched in the given session. The name of the context here is the short name
        and not the full URL name including the project parent
        """
    @property
    def output_context_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionInfo.ContextSteps]:
        """The output contexts that are matched in the given session. The name of the context here is the short name
        and not the full URL name including the project parent
        """
    duration_in_s: builtins.float
    """ duration in seconds"""
    duration_in_m: builtins.float
    """duration in minutes"""
    duration_in_m_rounded: builtins.float
    """duration in minutes rounded"""
    duration_interval_15s_rounded: builtins.float
    """duration in 15 seconds intervals rounded"""
    duration_interval_30s_rounded: builtins.float
    """duration in 30 seconds intervals rounded"""
    duration_interval_45s_rounded: builtins.float
    """duration in 45 seconds intervals rounded"""
    started_time_slot_per_hour: builtins.str
    """started_time_slot_per_hour (e.g. 08:00)"""
    started_time_slot_per_quarter_hour: builtins.str
    """started_time_slot_per_quarter_hour (e.g. 08:00)"""
    started_time_slot_per_half_hour: builtins.str
    """started_time_slot_per_half_hour (e.g. 08:00)"""
    started_time_slot_per_day_phase: builtins.str
    """started_time_slot_per_day_phase (e.g. 14:00)"""
    started_time_slot_per_minute: builtins.str
    """started_time_slot_per_minute (e.g. 14:00)"""
    duration_in_s_rounded: builtins.float
    """duration in seconds rounded"""
    @property
    def platforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType]:
        """Messages for each of the Intent.Message.Platform were sent to the user"""
    @property
    def account_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the account, e.g. Company Ondewo,
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def property_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the property of the account, e.g. Domain ondewo.com
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def datastream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the datastream of the property of the account, e.g. Subdomain sub1.ondewo.com or sub2.ondewo.com
        This field can also be used for customized tracking ids or tag ids
        """
    @property
    def origin_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the the origin of the user request

        For a phone bot, this is the phone number +123456789 the user called (Note: This is not the user's phone number)
        For a chatbot or voicebot on the web, this is the URL on which the bo, e.g. https://ondewo.com/webchat
        For a voice assistant device, this is the device-id or the app id
        """
    @property
    def identified_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ids of the "identified user" e.g. for a chatbot the email address or for a phone bot the phone number of the user"""
    duration_interval_60s_rounded: builtins.float
    """duration in 60 seconds intervals rounded"""
    @property
    def parent_comment(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.common_pb2.Comment]:
        """comments about a session"""
    def __init__(
        self,
        *,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
        matched_intents: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent] | None = ...,
        matched_entity_types: collections.abc.Iterable[ondewo.nlu.entity_type_pb2.EntityType] | None = ...,
        min_intents_confidence: builtins.float = ...,
        min_entity_types_confidence: builtins.float = ...,
        earliest: builtins.float = ...,
        latest: builtins.float = ...,
        number_turns: builtins.int = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        intent_tags: collections.abc.Iterable[builtins.str] | None = ...,
        input_context_steps: collections.abc.Iterable[global___SessionInfo.ContextSteps] | None = ...,
        output_context_steps: collections.abc.Iterable[global___SessionInfo.ContextSteps] | None = ...,
        duration_in_s: builtins.float = ...,
        duration_in_m: builtins.float = ...,
        duration_in_m_rounded: builtins.float = ...,
        duration_interval_15s_rounded: builtins.float = ...,
        duration_interval_30s_rounded: builtins.float = ...,
        duration_interval_45s_rounded: builtins.float = ...,
        started_time_slot_per_hour: builtins.str = ...,
        started_time_slot_per_quarter_hour: builtins.str = ...,
        started_time_slot_per_half_hour: builtins.str = ...,
        started_time_slot_per_day_phase: builtins.str = ...,
        started_time_slot_per_minute: builtins.str = ...,
        duration_in_s_rounded: builtins.float = ...,
        platforms: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType] | None = ...,
        account_ids: collections.abc.Iterable[builtins.str] | None = ...,
        property_ids: collections.abc.Iterable[builtins.str] | None = ...,
        datastream_ids: collections.abc.Iterable[builtins.str] | None = ...,
        origin_ids: collections.abc.Iterable[builtins.str] | None = ...,
        identified_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        duration_interval_60s_rounded: builtins.float = ...,
        parent_comment: collections.abc.Iterable[ondewo.nlu.common_pb2.Comment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_ids", b"account_ids", "datastream_ids", b"datastream_ids", "duration_in_m", b"duration_in_m", "duration_in_m_rounded", b"duration_in_m_rounded", "duration_in_s", b"duration_in_s", "duration_in_s_rounded", b"duration_in_s_rounded", "duration_interval_15s_rounded", b"duration_interval_15s_rounded", "duration_interval_30s_rounded", b"duration_interval_30s_rounded", "duration_interval_45s_rounded", b"duration_interval_45s_rounded", "duration_interval_60s_rounded", b"duration_interval_60s_rounded", "earliest", b"earliest", "identified_user_ids", b"identified_user_ids", "input_context_steps", b"input_context_steps", "intent_tags", b"intent_tags", "labels", b"labels", "language_codes", b"language_codes", "latest", b"latest", "matched_entity_types", b"matched_entity_types", "matched_intents", b"matched_intents", "min_entity_types_confidence", b"min_entity_types_confidence", "min_intents_confidence", b"min_intents_confidence", "number_turns", b"number_turns", "origin_ids", b"origin_ids", "output_context_steps", b"output_context_steps", "parent_comment", b"parent_comment", "platforms", b"platforms", "property_ids", b"property_ids", "started_time_slot_per_day_phase", b"started_time_slot_per_day_phase", "started_time_slot_per_half_hour", b"started_time_slot_per_half_hour", "started_time_slot_per_hour", b"started_time_slot_per_hour", "started_time_slot_per_minute", b"started_time_slot_per_minute", "started_time_slot_per_quarter_hour", b"started_time_slot_per_quarter_hour", "user_ids", b"user_ids"]) -> None: ...

global___SessionInfo = SessionInfo

@typing_extensions.final
class ListSessionsResponse(google.protobuf.message.Message):
    """This message is a response including the listing of sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def sessions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Session]:
        """The requested sessions"""
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""
    def __init__(
        self,
        *,
        sessions: collections.abc.Iterable[global___Session] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "sessions", b"sessions"]) -> None: ...

global___ListSessionsResponse = ListSessionsResponse

@typing_extensions.final
class GetSessionRequest(google.protobuf.message.Message):
    """This message is a request to get a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The session to be returned
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    session_view: global___Session.View.ValueType
    """whether to return a full or sparse view; if unspecified full view is returned"""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which fields will be filled with data.
        Example: path=["session_info.duration_in_s_min"]
        """
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        session_view: global___Session.View.ValueType = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["field_mask", b"field_mask", "session_id", b"session_id", "session_view", b"session_view"]) -> None: ...

global___GetSessionRequest = GetSessionRequest

@typing_extensions.final
class CreateSessionRequest(google.protobuf.message.Message):
    """This message is a request to create a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_UUID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project that the agent to fetch is associated with.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agents</code></pre>
    """
    session_uuid: builtins.str
    """The unique UUID of a Session
    Format: UUID Version 4, e.g. 2f59fad2-06bc-4730-9920-d3148f28f357
    Optional. If not provided, it will be auto-generated
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. labels for the session."""
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """Optional. The collection of contexts to be activated before this query is executed."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_uuid: builtins.str = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
        contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["contexts", b"contexts", "labels", b"labels", "parent", b"parent", "session_uuid", b"session_uuid"]) -> None: ...

global___CreateSessionRequest = CreateSessionRequest

@typing_extensions.final
class DeleteSessionRequest(google.protobuf.message.Message):
    """This message is a request to delete a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """Required. The session to be deleted
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id", b"session_id"]) -> None: ...

global___DeleteSessionRequest = DeleteSessionRequest

@typing_extensions.final
class CreateSessionReviewRequest(google.protobuf.message.Message):
    """*** SESSION-REVIEW RELATED MESSAGES *** //"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    PARENT_REVIEW_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The unique identifier for the session under review
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    parent_review_id: builtins.str
    """Optional: The unique identifier of the parent review
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/reviews/&lt;session_review_uuid&gt;</code></pre>
    """
    @property
    def session_review(self) -> global___SessionReview:
        """The reviews for all steps in the session"""
    session_review_view: global___SessionReview.View.ValueType
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        parent_review_id: builtins.str = ...,
        session_review: global___SessionReview | None = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_review", b"session_review"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent_review_id", b"parent_review_id", "session_id", b"session_id", "session_review", b"session_review", "session_review_view", b"session_review_view"]) -> None: ...

global___CreateSessionReviewRequest = CreateSessionReviewRequest

@typing_extensions.final
class SessionReview(google.protobuf.message.Message):
    """This message contains a session review"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SessionReview._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: SessionReview._View.ValueType  # 0
        """Endpoints decide whether to return the full or the sparse view"""
        VIEW_FULL: SessionReview._View.ValueType  # 1
        """All fields are populated."""
        VIEW_SPARSE: SessionReview._View.ValueType  # 2
        """Only some fields are populated in the response."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """Represents the options for views of a session_review.
        A session_review can be a sizable object. Therefore, we provide a resource view that
        does not return all data
        """

    VIEW_UNSPECIFIED: SessionReview.View.ValueType  # 0
    """Endpoints decide whether to return the full or the sparse view"""
    VIEW_FULL: SessionReview.View.ValueType  # 1
    """All fields are populated."""
    VIEW_SPARSE: SessionReview.View.ValueType  # 2
    """Only some fields are populated in the response."""

    NAME_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_STEPS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique identifier for the given review
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/reviews/&lt;session_review_uuid&gt;</code></pre>
    """
    @property
    def session_review_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionReviewStep]:
        """The reviews for all steps in the session"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        session_review_steps: collections.abc.Iterable[global___SessionReviewStep] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "created_by", b"created_by", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "session_review_steps", b"session_review_steps"]) -> None: ...

global___SessionReview = SessionReview

@typing_extensions.final
class SessionReviewStep(google.protobuf.message.Message):
    """This message contains a session review step"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ANNOTATED_USERSAYS_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    DETECTED_INTENTS_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    CONTEXTS_OUT_FIELD_NUMBER: builtins.int
    QUERY_TEXT_ORIGINAL_FIELD_NUMBER: builtins.int
    PLATFORMS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    AUDIO_FILE_RESOURCES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique identifier for the given review step
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/reviews/&lt;review_uuid&gt;/sessionreviewsteps/&lt;session_review_step_uuid&gt;</code></pre>
    """
    @property
    def annotated_usersays(self) -> ondewo.nlu.intent_pb2.Intent.TrainingPhrase:
        """The user says with markup of the detected entity types after the preprocessing such as spelling correction,
        stopword removal etc. has been applied.

        This string represents what has been passed to the entity recognition and intent detection algorithms.
        """
    language_code: builtins.str
    """The language code"""
    @property
    def detected_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DetectedIntent]:
        """Unique detected intents ordered by descending confidence"""
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The contexts which were active at the beginning of this step"""
    @property
    def contexts_out(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The output contexts of this step"""
    query_text_original: builtins.str
    """User input without any pre-processing applied"""
    @property
    def platforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType]:
        """Messages for each of the Intent.Message.Platform were sent to the user"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of session review step"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    @property
    def audio_file_resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """audio file resources associated with the session review step"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        annotated_usersays: ondewo.nlu.intent_pb2.Intent.TrainingPhrase | None = ...,
        language_code: builtins.str = ...,
        detected_intents: collections.abc.Iterable[global___DetectedIntent] | None = ...,
        contexts: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        contexts_out: collections.abc.Iterable[ondewo.nlu.context_pb2.Context] | None = ...,
        query_text_original: builtins.str = ...,
        platforms: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType] | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
        audio_file_resources: collections.abc.Iterable[global___AudioFileResource] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["annotated_usersays", b"annotated_usersays", "created_at", b"created_at", "modified_at", b"modified_at", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotated_usersays", b"annotated_usersays", "audio_file_resources", b"audio_file_resources", "contexts", b"contexts", "contexts_out", b"contexts_out", "created_at", b"created_at", "created_by", b"created_by", "detected_intents", b"detected_intents", "language_code", b"language_code", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "platforms", b"platforms", "query_text_original", b"query_text_original", "timestamp", b"timestamp"]) -> None: ...

global___SessionReviewStep = SessionReviewStep

@typing_extensions.final
class DetectedIntent(google.protobuf.message.Message):
    """This message contains a detected intent"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INTENT_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    FULFILLMENT_MESSAGES_FIELD_NUMBER: builtins.int
    REQUIRED_PARAM_MISSING_FIELD_NUMBER: builtins.int
    @property
    def intent(self) -> ondewo.nlu.intent_pb2.Intent:
        """intent"""
    score: builtins.float
    """score of intent detection"""
    algorithm: builtins.str
    """intent detection algorithm"""
    @property
    def fulfillment_messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent.Message]:
        """collection of rich messages to present to the user
        This field is set only for the first detected intent. For the rest of the intents the messages are not
          resolved and the raw messages for the current language code are available in self.intent.messages
        """
    required_param_missing: builtins.bool
    """This field is set to:
    - `true` if the matched intent has required parameters and not all of
       the required parameter values have been collected.
    - `false` if all required parameter values have been collected, or if the
       matched intent doesn't contain any required parameters.
    """
    def __init__(
        self,
        *,
        intent: ondewo.nlu.intent_pb2.Intent | None = ...,
        score: builtins.float = ...,
        algorithm: builtins.str = ...,
        fulfillment_messages: collections.abc.Iterable[ondewo.nlu.intent_pb2.Intent.Message] | None = ...,
        required_param_missing: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["intent", b"intent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "fulfillment_messages", b"fulfillment_messages", "intent", b"intent", "required_param_missing", b"required_param_missing", "score", b"score"]) -> None: ...

global___DetectedIntent = DetectedIntent

@typing_extensions.final
class ListSessionLabelsRequest(google.protobuf.message.Message):
    """This message is a request to list session labels"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id", b"session_id"]) -> None: ...

global___ListSessionLabelsRequest = ListSessionLabelsRequest

@typing_extensions.final
class ListSessionLabelsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all labels of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the labels for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListSessionLabelsOfAllSessionsRequest = ListSessionLabelsOfAllSessionsRequest

@typing_extensions.final
class ListSessionLabelsResponse(google.protobuf.message.Message):
    """This message is a response of listing session labels"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LABELS_FIELD_NUMBER: builtins.int
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The labels of the session"""
    def __init__(
        self,
        *,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels"]) -> None: ...

global___ListSessionLabelsResponse = ListSessionLabelsResponse

@typing_extensions.final
class ListLanguageCodesOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all language codes of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the language_codes for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListLanguageCodesOfAllSessionsRequest = ListLanguageCodesOfAllSessionsRequest

@typing_extensions.final
class ListLanguageCodesResponse(google.protobuf.message.Message):
    """This message is a response of listing session language_codes"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The language_codes of the session"""
    def __init__(
        self,
        *,
        language_codes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_codes", b"language_codes"]) -> None: ...

global___ListLanguageCodesResponse = ListLanguageCodesResponse

@typing_extensions.final
class ListMatchedIntentsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all matched_intents of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the matched_intents for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListMatchedIntentsOfAllSessionsRequest = ListMatchedIntentsOfAllSessionsRequest

@typing_extensions.final
class ListMatchedIntentsResponse(google.protobuf.message.Message):
    """This message is a response of listing session matched_intents"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCHED_INTENTS_FIELD_NUMBER: builtins.int
    @property
    def matched_intents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The matched_intents of the session"""
    def __init__(
        self,
        *,
        matched_intents: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["matched_intents", b"matched_intents"]) -> None: ...

global___ListMatchedIntentsResponse = ListMatchedIntentsResponse

@typing_extensions.final
class ListMatchedEntityTypesOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all matched_entity_types of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the matched_entity_types for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListMatchedEntityTypesOfAllSessionsRequest = ListMatchedEntityTypesOfAllSessionsRequest

@typing_extensions.final
class ListMatchedEntityTypesResponse(google.protobuf.message.Message):
    """This message is a response of listing session matched_entity_types"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCHED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    @property
    def matched_entity_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The matched_entity_types of the session"""
    def __init__(
        self,
        *,
        matched_entity_types: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["matched_entity_types", b"matched_entity_types"]) -> None: ...

global___ListMatchedEntityTypesResponse = ListMatchedEntityTypesResponse

@typing_extensions.final
class ListUserIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all user_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the user_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListUserIdsOfAllSessionsRequest = ListUserIdsOfAllSessionsRequest

@typing_extensions.final
class ListUserIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session user_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The user_ids of the session"""
    def __init__(
        self,
        *,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["user_ids", b"user_ids"]) -> None: ...

global___ListUserIdsResponse = ListUserIdsResponse

@typing_extensions.final
class ListIdentifiedUserIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all identified_user_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the identified_user_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListIdentifiedUserIdsOfAllSessionsRequest = ListIdentifiedUserIdsOfAllSessionsRequest

@typing_extensions.final
class ListIdentifiedUserIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session identified_user_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDENTIFIED_USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def identified_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The identified_user_ids of the session"""
    def __init__(
        self,
        *,
        identified_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["identified_user_ids", b"identified_user_ids"]) -> None: ...

global___ListIdentifiedUserIdsResponse = ListIdentifiedUserIdsResponse

@typing_extensions.final
class ListTagsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all tags of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the tags for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListTagsOfAllSessionsRequest = ListTagsOfAllSessionsRequest

@typing_extensions.final
class ListTagsResponse(google.protobuf.message.Message):
    """This message is a response of listing session tags"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The tags of the session"""
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tags", b"tags"]) -> None: ...

global___ListTagsResponse = ListTagsResponse

@typing_extensions.final
class ListInputContextsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all input_contexts of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the input_contexts for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListInputContextsOfAllSessionsRequest = ListInputContextsOfAllSessionsRequest

@typing_extensions.final
class ListInputContextsResponse(google.protobuf.message.Message):
    """This message is a response of listing session input_contexts"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    @property
    def input_contexts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The input_contexts ids of the session"""
    def __init__(
        self,
        *,
        input_contexts: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["input_contexts", b"input_contexts"]) -> None: ...

global___ListInputContextsResponse = ListInputContextsResponse

@typing_extensions.final
class ListOutputContextsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all output_contexts of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the output_contexts for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListOutputContextsOfAllSessionsRequest = ListOutputContextsOfAllSessionsRequest

@typing_extensions.final
class ListOutputContextsResponse(google.protobuf.message.Message):
    """This message is a response of listing session output_contexts"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    @property
    def output_contexts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The output_contexts ids of the session"""
    def __init__(
        self,
        *,
        output_contexts: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["output_contexts", b"output_contexts"]) -> None: ...

global___ListOutputContextsResponse = ListOutputContextsResponse

@typing_extensions.final
class ListPlatformsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all labels of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the platforms for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListPlatformsOfAllSessionsRequest = ListPlatformsOfAllSessionsRequest

@typing_extensions.final
class ListPlatformsResponse(google.protobuf.message.Message):
    """This message is a response of listing session platforms"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLATFORMS_FIELD_NUMBER: builtins.int
    @property
    def platforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The platforms of the session"""
    def __init__(
        self,
        *,
        platforms: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["platforms", b"platforms"]) -> None: ...

global___ListPlatformsResponse = ListPlatformsResponse

@typing_extensions.final
class ListAccountIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all account_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the account_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListAccountIdsOfAllSessionsRequest = ListAccountIdsOfAllSessionsRequest

@typing_extensions.final
class ListAccountIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session account_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_IDS_FIELD_NUMBER: builtins.int
    @property
    def account_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The account_ids of the session"""
    def __init__(
        self,
        *,
        account_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_ids", b"account_ids"]) -> None: ...

global___ListAccountIdsResponse = ListAccountIdsResponse

@typing_extensions.final
class ListPropertyIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all property_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the property_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListPropertyIdsOfAllSessionsRequest = ListPropertyIdsOfAllSessionsRequest

@typing_extensions.final
class ListPropertyIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session property_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROPERTY_IDS_FIELD_NUMBER: builtins.int
    @property
    def property_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The property_ids of the session"""
    def __init__(
        self,
        *,
        property_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["property_ids", b"property_ids"]) -> None: ...

global___ListPropertyIdsResponse = ListPropertyIdsResponse

@typing_extensions.final
class ListDatastreamIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all datastream_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the datastream_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListDatastreamIdsOfAllSessionsRequest = ListDatastreamIdsOfAllSessionsRequest

@typing_extensions.final
class ListDatastreamIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session datastream_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASTREAM_IDS_FIELD_NUMBER: builtins.int
    @property
    def datastream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The datastream_ids of the session"""
    def __init__(
        self,
        *,
        datastream_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["datastream_ids", b"datastream_ids"]) -> None: ...

global___ListDatastreamIdsResponse = ListDatastreamIdsResponse

@typing_extensions.final
class ListOriginIdsOfAllSessionsRequest(google.protobuf.message.Message):
    """request to list all origin_ids of all sessions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The parent for which the origin_ids for all sessions should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_filter: global___SessionFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter", b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "session_filter", b"session_filter"]) -> None: ...

global___ListOriginIdsOfAllSessionsRequest = ListOriginIdsOfAllSessionsRequest

@typing_extensions.final
class ListOriginIdsResponse(google.protobuf.message.Message):
    """This message is a response of listing session origin_ids"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_IDS_FIELD_NUMBER: builtins.int
    @property
    def origin_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The origin_ids of the session"""
    def __init__(
        self,
        *,
        origin_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["origin_ids", b"origin_ids"]) -> None: ...

global___ListOriginIdsResponse = ListOriginIdsResponse

@typing_extensions.final
class AddSessionLabelsRequest(google.protobuf.message.Message):
    """This message is a request to add session labels"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The labels to add to the session"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "session_id", b"session_id"]) -> None: ...

global___AddSessionLabelsRequest = AddSessionLabelsRequest

@typing_extensions.final
class DeleteSessionLabelsRequest(google.protobuf.message.Message):
    """This message is a request to delete session labels"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The labels to delete from the session"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "session_id", b"session_id"]) -> None: ...

global___DeleteSessionLabelsRequest = DeleteSessionLabelsRequest

@typing_extensions.final
class AddSessionCommentRequest(google.protobuf.message.Message):
    """This message is a request to add a comment to a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    COMMENT_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    @property
    def comment(self) -> ondewo.nlu.common_pb2.Comment:
        """The comment to add to the session"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        comment: ondewo.nlu.common_pb2.Comment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["comment", b"comment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["comment", b"comment", "session_id", b"session_id"]) -> None: ...

global___AddSessionCommentRequest = AddSessionCommentRequest

@typing_extensions.final
class DeleteSessionCommentsRequest(google.protobuf.message.Message):
    """This message is a request to delete a session comment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    COMMENT_NAMES_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    @property
    def comment_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The comment names to delete from the session"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        comment_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["comment_names", b"comment_names", "session_id", b"session_id"]) -> None: ...

global___DeleteSessionCommentsRequest = DeleteSessionCommentsRequest

@typing_extensions.final
class UpdateSessionCommentsRequest(google.protobuf.message.Message):
    """This message is a request to update a session comment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    COMMENT_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The id of the session"""
    @property
    def comment(self) -> ondewo.nlu.common_pb2.Comment:
        """The comment of a session to be updated"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        comment: ondewo.nlu.common_pb2.Comment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["comment", b"comment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["comment", b"comment", "session_id", b"session_id"]) -> None: ...

global___UpdateSessionCommentsRequest = UpdateSessionCommentsRequest

@typing_extensions.final
class ListSessionCommentsRequest(google.protobuf.message.Message):
    """This message is a request to list comments of a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The unique identifier for the session for which reviews should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token", "session_id", b"session_id"]) -> None: ...

global___ListSessionCommentsRequest = ListSessionCommentsRequest

@typing_extensions.final
class ListSessionCommentsResponse(google.protobuf.message.Message):
    """This message is a request to list comments of a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMENT_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def comment(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.common_pb2.Comment]:
        """The comments of a specific session
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/comments/&lt;comment_uuid&gt;</code></pre>
        """
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        comment: collections.abc.Iterable[ondewo.nlu.common_pb2.Comment] | None = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["comment", b"comment", "page_token", b"page_token"]) -> None: ...

global___ListSessionCommentsResponse = ListSessionCommentsResponse

@typing_extensions.final
class ListSessionReviewsRequest(google.protobuf.message.Message):
    """This message is a request to list session reviews"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The unique identifier for the session for which reviews should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    session_review_view: global___SessionReview.View.ValueType
    """An enum specifying the amount of information to be returned per session review"""
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token", "session_id", b"session_id", "session_review_view", b"session_review_view"]) -> None: ...

global___ListSessionReviewsRequest = ListSessionReviewsRequest

@typing_extensions.final
class ListSessionReviewsResponse(google.protobuf.message.Message):
    """This message is a response of listing session reviews"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_REVIEWS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def session_reviews(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionReview]:
        """The requested session reviews"""
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""
    def __init__(
        self,
        *,
        session_reviews: collections.abc.Iterable[global___SessionReview] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "session_reviews", b"session_reviews"]) -> None: ...

global___ListSessionReviewsResponse = ListSessionReviewsResponse

@typing_extensions.final
class GetSessionReviewRequest(google.protobuf.message.Message):
    """This message is a request to get session review"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_REVIEW_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_review_id: builtins.str
    """The unique identifier of the session review to be returned"""
    session_review_view: global___SessionReview.View.ValueType
    def __init__(
        self,
        *,
        session_review_id: builtins.str = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_review_id", b"session_review_id", "session_review_view", b"session_review_view"]) -> None: ...

global___GetSessionReviewRequest = GetSessionReviewRequest

@typing_extensions.final
class GetLatestSessionReviewRequest(google.protobuf.message.Message):
    """This message is a request to get latest session review"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """The unique identifier of the session for which the latest review should be returned
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;</code></pre>
    """
    session_review_view: global___SessionReview.View.ValueType
    """An enum specifying the amount of information to be returned for the desired session review"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id", b"session_id", "session_review_view", b"session_review_view"]) -> None: ...

global___GetLatestSessionReviewRequest = GetLatestSessionReviewRequest

@typing_extensions.final
class AudioFileResource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BYTES_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    DURATION_IN_S_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_FIELD_NUMBER: builtins.int
    AUDIO_FILE_RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    TRANSCRIPTIONS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique identifier of the session for which the latest review should be returned
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
    """
    bytes: builtins.bytes
    """Bytes of the audio file"""
    language: builtins.str
    """Language of the audio file"""
    duration_in_s: builtins.float
    """Duration in seconds and milliseconds of the audio file"""
    sample_rate: builtins.int
    """sample rate of the audio"""
    audio_file_resource_type: global___AudioFileResourceType.ValueType
    """File type of an audio resource"""
    @property
    def transcriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S2tTranscription]:
        """transcriptions of the user input sorted by score.
        A transcription can be from a speech-to-text system or a human
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date and time. Read-only field."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification date and time. Read-only field."""
    created_by: builtins.str
    """User id in form of a valid UUID."""
    modified_by: builtins.str
    """User id in form of a valid UUID."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        bytes: builtins.bytes = ...,
        language: builtins.str = ...,
        duration_in_s: builtins.float = ...,
        sample_rate: builtins.int = ...,
        audio_file_resource_type: global___AudioFileResourceType.ValueType = ...,
        transcriptions: collections.abc.Iterable[global___S2tTranscription] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_file_resource_type", b"audio_file_resource_type", "bytes", b"bytes", "created_at", b"created_at", "created_by", b"created_by", "duration_in_s", b"duration_in_s", "language", b"language", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "sample_rate", b"sample_rate", "transcriptions", b"transcriptions"]) -> None: ...

global___AudioFileResource = AudioFileResource

@typing_extensions.final
class GetAudioFilesRequest(google.protobuf.message.Message):
    """This message is a request to get audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    RESOURCE_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SORTING_MODE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifier of the audio file of the specific session
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    resource_view: global___ResourceView.ValueType
    """Represents the options for views of resources"""
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType
    """sorting mode"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        names: collections.abc.Iterable[builtins.str] | None = ...,
        resource_view: global___ResourceView.ValueType = ...,
        page_token: builtins.str = ...,
        sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names", "page_token", b"page_token", "parent", b"parent", "resource_view", b"resource_view", "sorting_mode", b"sorting_mode"]) -> None: ...

global___GetAudioFilesRequest = GetAudioFilesRequest

@typing_extensions.final
class GetAudioFilesResponse(google.protobuf.message.Message):
    """This message is a request to retrieve the audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FILES_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def audio_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """The unique identifier of the audio file for a specific session.
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    error_message: builtins.str
    """error message if there are any."""
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""
    def __init__(
        self,
        *,
        audio_files: collections.abc.Iterable[global___AudioFileResource] | None = ...,
        error_message: builtins.str = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_files", b"audio_files", "error_message", b"error_message", "next_page_token", b"next_page_token"]) -> None: ...

global___GetAudioFilesResponse = GetAudioFilesResponse

@typing_extensions.final
class AddAudioFilesRequest(google.protobuf.message.Message):
    """This message is a request to add the audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    AUDIO_FILE_RESOURCES_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    session_id: builtins.str
    """The unique identifier of the session for which the audio files should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/&lt</code></pre>
    """
    @property
    def audio_file_resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """AudioFileResources to be added"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_id: builtins.str = ...,
        audio_file_resources: collections.abc.Iterable[global___AudioFileResource] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_file_resources", b"audio_file_resources", "parent", b"parent", "session_id", b"session_id"]) -> None: ...

global___AddAudioFilesRequest = AddAudioFilesRequest

@typing_extensions.final
class AddAudioFilesResponse(google.protobuf.message.Message):
    """This message is a request to add the audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FILE_RESOURCES_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def audio_file_resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """The unique identifier of the audio files for a specific session.
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    error_message: builtins.str
    """error message if there are any."""
    def __init__(
        self,
        *,
        audio_file_resources: collections.abc.Iterable[global___AudioFileResource] | None = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_file_resources", b"audio_file_resources", "error_message", b"error_message"]) -> None: ...

global___AddAudioFilesResponse = AddAudioFilesResponse

@typing_extensions.final
class DeleteAudioFilesRequest(google.protobuf.message.Message):
    """This message is a request to the delete audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifier of the audio file of the specific session
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names", "parent", b"parent"]) -> None: ...

global___DeleteAudioFilesRequest = DeleteAudioFilesRequest

@typing_extensions.final
class DeleteAudioFilesResponse(google.protobuf.message.Message):
    """This message is a request to the delete audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifier of the audio file of the specific session
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    error_message: builtins.str
    """error message if there are any."""
    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_message", b"error_message", "names", b"names"]) -> None: ...

global___DeleteAudioFilesResponse = DeleteAudioFilesResponse

@typing_extensions.final
class ListAudioFilesRequest(google.protobuf.message.Message):
    """This message is a request to list all available audio files of a session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    RESOURCE_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SORTING_MODE_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    session_id: builtins.str
    """Optional: The unique identifier of the session for which the audio files should be listed
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/&lt</code></pre>
    """
    resource_view: global___ResourceView.ValueType
    """Represents the options for views of resources"""
    page_token: builtins.str
    """Optional: The page token to support pagination.
    Pagination allows you to retrieve a large result set in smaller, more manageable portions.
    The page token is a string representing the current index and page size.

    Valid page token strings:
    * "" (empty string) - Retrieves the first page.
    * "current_index-0--page_size-20" - Retrieves the first page with a page size of 20.
    * "current_index-1--page_size-20" - Retrieves the second page with a page size of 20.

    Index starts at 0.

    Examples of valid page token strings:
    * ""
    * "current_index-0--page_size-20"
    * "current_index-1--page_size-20"
    * "current_index-10--page_size-20"

    Examples of invalid page token strings:
    * "1"
    * "current_index-0--page_size-20"
    * "current_index--1--page_size-20"
    * "current_index1--page_size-20"
    * "current_index-1--page_size--20"
    """
    sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType
    """sorting mode"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_id: builtins.str = ...,
        resource_view: global___ResourceView.ValueType = ...,
        page_token: builtins.str = ...,
        sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token", b"page_token", "parent", b"parent", "resource_view", b"resource_view", "session_id", b"session_id", "sorting_mode", b"sorting_mode"]) -> None: ...

global___ListAudioFilesRequest = ListAudioFilesRequest

@typing_extensions.final
class ListAudioFilesResponse(google.protobuf.message.Message):
    """This message is a request to retrieve the audio files specified"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FILES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def audio_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioFileResource]:
        """The requested audio files .
        Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/audios/&lt;audio_uuid&gt;</code></pre>
        """
    next_page_token: builtins.str
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""
    error_message: builtins.str
    """error message if there are any."""
    def __init__(
        self,
        *,
        audio_files: collections.abc.Iterable[global___AudioFileResource] | None = ...,
        next_page_token: builtins.str = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_files", b"audio_files", "error_message", b"error_message", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAudioFilesResponse = ListAudioFilesResponse

@typing_extensions.final
class GetAudioFileOfSessionRequest(google.protobuf.message.Message):
    """This message is a request to get one one file combining all audios of a specific session"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    RESOURCE_VIEW_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The project of this agent.
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent</code></pre>
    """
    session_id: builtins.str
    """The unique identifier of the session for which the audio files should be combined
    Format: <pre><code>projects/&lt;project_uuid&gt;/agent/sessions/&lt;session_uuid&gt;/&lt</code></pre>
    """
    resource_view: global___ResourceView.ValueType
    """Represents the options for views of resources"""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        session_id: builtins.str = ...,
        resource_view: global___ResourceView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "resource_view", b"resource_view", "session_id", b"session_id"]) -> None: ...

global___GetAudioFileOfSessionRequest = GetAudioFileOfSessionRequest
