"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023 ONDEWO GmbH

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import ondewo.nlu.session_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GetAnswerRequest(google.protobuf.message.Message):
    """The request message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    MAX_NUM_ANSWERS_FIELD_NUMBER: builtins.int
    THRESHOLD_READER_FIELD_NUMBER: builtins.int
    THRESHOLD_RETRIEVER_FIELD_NUMBER: builtins.int
    THRESHOLD_OVERALL_FIELD_NUMBER: builtins.int
    READER_MODEL_NAME_FIELD_NUMBER: builtins.int
    URL_FILTER_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """Required. The name of the session this query is sent to. Format:
    `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
    caller to choose an appropriate session ID. It can be a random number or
    some type of user identifier (preferably hashed). The length of the session
    ID must not exceed 36 bytes.
    """
    @property
    def text(self) -> ondewo.nlu.session_pb2.TextInput:
        """Required. The context of the request. A message containing a string (in the form of a sentence) and a
        language code.
        """
    max_num_answers: builtins.int
    """Maximal number of answers returned"""
    threshold_reader: builtins.float
    """Threshold (minimal score) to give back reader result"""
    threshold_retriever: builtins.float
    """Threshold (minimal score) to give back retriever result"""
    threshold_overall: builtins.float
    """Threshold (minimal score) overall probability"""
    reader_model_name: builtins.str
    """Reader model name"""
    @property
    def url_filter(self) -> global___UrlFilter:
        """Optional. Filters applied to the urls, to restrict the retrieved documents."""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        text: ondewo.nlu.session_pb2.TextInput | None = ...,
        max_num_answers: builtins.int = ...,
        threshold_reader: builtins.float = ...,
        threshold_retriever: builtins.float = ...,
        threshold_overall: builtins.float = ...,
        reader_model_name: builtins.str = ...,
        url_filter: global___UrlFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["text", b"text", "url_filter", b"url_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_num_answers", b"max_num_answers", "reader_model_name", b"reader_model_name", "session_id", b"session_id", "text", b"text", "threshold_overall", b"threshold_overall", "threshold_reader", b"threshold_reader", "threshold_retriever", b"threshold_retriever", "url_filter", b"url_filter"]) -> None: ...

global___GetAnswerRequest = GetAnswerRequest

@typing_extensions.final
class GetAnswerResponse(google.protobuf.message.Message):
    """Message containing the response for retrieving answers."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_RESULT_FIELD_NUMBER: builtins.int
    @property
    def query_result(self) -> ondewo.nlu.session_pb2.DetectIntentResponse:
        """The results of the conversational query or event processing."""
    def __init__(
        self,
        *,
        query_result: ondewo.nlu.session_pb2.DetectIntentResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_result", b"query_result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["query_result", b"query_result"]) -> None: ...

global___GetAnswerResponse = GetAnswerResponse

@typing_extensions.final
class RunScraperRequest(google.protobuf.message.Message):
    """Message for running a web scraper job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_IDS_FIELD_NUMBER: builtins.int
    @property
    def project_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of project IDs to run the scraper on."""
    def __init__(
        self,
        *,
        project_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_ids", b"project_ids"]) -> None: ...

global___RunScraperRequest = RunScraperRequest

@typing_extensions.final
class RunScraperResponse(google.protobuf.message.Message):
    """Message containing the response for running a web scraper job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ScraperContainer(google.protobuf.message.Message):
        """Message representing a scraper container."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONTAINER_NAME_FIELD_NUMBER: builtins.int
        CONTAINER_ID_FIELD_NUMBER: builtins.int
        container_name: builtins.str
        """Name of the Docker container running the job."""
        container_id: builtins.str
        """ID of the Docker container running the scraping job."""
        def __init__(
            self,
            *,
            container_name: builtins.str = ...,
            container_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["container_id", b"container_id", "container_name", b"container_name"]) -> None: ...

    SCRAPER_CONTAINERS_FIELD_NUMBER: builtins.int
    @property
    def scraper_containers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RunScraperResponse.ScraperContainer]:
        """List of scraper containers running the jobs."""
    def __init__(
        self,
        *,
        scraper_containers: collections.abc.Iterable[global___RunScraperResponse.ScraperContainer] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["scraper_containers", b"scraper_containers"]) -> None: ...

global___RunScraperResponse = RunScraperResponse

@typing_extensions.final
class RunTrainingResponse(google.protobuf.message.Message):
    """Message containing the response for running a training job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    F1_FIELD_NUMBER: builtins.int
    ACCURACY_FIELD_NUMBER: builtins.int
    f1: builtins.float
    """F1 score as a response of the training."""
    accuracy: builtins.float
    """Accuracy as a response of the training."""
    def __init__(
        self,
        *,
        f1: builtins.float = ...,
        accuracy: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["accuracy", b"accuracy", "f1", b"f1"]) -> None: ...

global___RunTrainingResponse = RunTrainingResponse

@typing_extensions.final
class UrlFilter(google.protobuf.message.Message):
    """Message for defining URL filters to include and exclude from the scraping process."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALLOWED_VALUES_FIELD_NUMBER: builtins.int
    REGEX_FILTER_INCLUDE_FIELD_NUMBER: builtins.int
    REGEX_FILTER_EXCLUDE_FIELD_NUMBER: builtins.int
    @property
    def allowed_values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. List of allowed values for the metadata field 'url'."""
    regex_filter_include: builtins.str
    """Optional. Regular expression that must be matched by the metadata."""
    regex_filter_exclude: builtins.str
    """Optional. Regular expression that must not be matched by the metadata."""
    def __init__(
        self,
        *,
        allowed_values: collections.abc.Iterable[builtins.str] | None = ...,
        regex_filter_include: builtins.str = ...,
        regex_filter_exclude: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["allowed_values", b"allowed_values", "regex_filter_exclude", b"regex_filter_exclude", "regex_filter_include", b"regex_filter_include"]) -> None: ...

global___UrlFilter = UrlFilter

@typing_extensions.final
class GetServerStateResponse(google.protobuf.message.Message):
    """Message containing the response for checking the server state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SERVER_IS_READY_FIELD_NUMBER: builtins.int
    server_is_ready: builtins.bool
    """Indicates whether the server is ready to accept requests."""
    def __init__(
        self,
        *,
        server_is_ready: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["server_is_ready", b"server_is_ready"]) -> None: ...

global___GetServerStateResponse = GetServerStateResponse

@typing_extensions.final
class ListProjectIdsResponse(google.protobuf.message.Message):
    """Message for listing project IDs in the response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_IDS_FIELD_NUMBER: builtins.int
    @property
    def project_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of project IDs."""
    def __init__(
        self,
        *,
        project_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_ids", b"project_ids"]) -> None: ...

global___ListProjectIdsResponse = ListProjectIdsResponse

@typing_extensions.final
class GetProjectConfigRequest(google.protobuf.message.Message):
    """Message for requesting the configuration of a specific project."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_ID_FIELD_NUMBER: builtins.int
    project_id: builtins.str
    """The ID of the project for which to retrieve the configuration."""
    def __init__(
        self,
        *,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_id", b"project_id"]) -> None: ...

global___GetProjectConfigRequest = GetProjectConfigRequest

@typing_extensions.final
class GetProjectConfigResponse(google.protobuf.message.Message):
    """Message containing the response for getting the configuration of a project."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_SERIALIZED_FIELD_NUMBER: builtins.int
    config_serialized: builtins.str
    """Serialized configuration of the project."""
    def __init__(
        self,
        *,
        config_serialized: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["config_serialized", b"config_serialized"]) -> None: ...

global___GetProjectConfigResponse = GetProjectConfigResponse

@typing_extensions.final
class UpdateDatabaseRequest(google.protobuf.message.Message):
    """Message for requesting a database update for specific projects."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_IDS_FIELD_NUMBER: builtins.int
    @property
    def project_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of project IDs for which to update the database."""
    def __init__(
        self,
        *,
        project_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["project_ids", b"project_ids"]) -> None: ...

global___UpdateDatabaseRequest = UpdateDatabaseRequest

@typing_extensions.final
class UpdateDatabaseResponse(google.protobuf.message.Message):
    """Message containing the response for updating the database of specific projects."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_MESSAGES_FIELD_NUMBER: builtins.int
    @property
    def error_messages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of error messages encountered during the database update."""
    def __init__(
        self,
        *,
        error_messages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_messages", b"error_messages"]) -> None: ...

global___UpdateDatabaseResponse = UpdateDatabaseResponse
