import time
import threading

def esperar(tiempo, continuar=False, accion=None):
    """
    Pausa la ejecución del programa por un tiempo especificado y ejecuta una acción opcional.
    
    :param tiempo: El tiempo de espera (por ejemplo, '10s', '5m', '1h').
    :param continuar: Si es True, continuará inmediatamente después de esperar sin bloquear el programa.
    :param accion: Código que se ejecutará al finalizar el tiempo de espera.
    """
    # Convertir el tiempo a segundos
    if tiempo.endswith("s"):
        segundos = int(tiempo[:-1])
    elif tiempo.endswith("m"):
        segundos = int(tiempo[:-1]) * 60
    elif tiempo.endswith("h"):
        segundos = int(tiempo[:-1]) * 3600
    else:
        print("Formato de tiempo incorrecto")
        return
    
    # Función para esperar y ejecutar la acción
    def esperar_y_accion():
        time.sleep(segundos)
        if accion:
            exec(accion)
        if not continuar:
            print(f"Han pasado {tiempo}.")
    
    if continuar:
        # Ejecutar la espera y la acción en un hilo en segundo plano
        print(f"Esperando en segundo plano durante {tiempo}...")
        threading.Thread(target=esperar_y_accion).start()
    else:
        # Si continuar es False, bloquear el programa hasta que pase el tiempo
        print(f"Esperando durante {tiempo}.")
        time.sleep(segundos)
        if accion:
            exec(accion)
        print(f"Han pasado {tiempo}.")

