import re

# SQL function sets as constants
SQL_AGGREGATE_FUNCTIONS = {
    "GROUP_CONCAT",
    "STRING_AGG",
    "ARRAY_AGG",
    "FIRST",
    "LAST",
    "BIT_AND",
    "BIT_OR",
    "BIT_XOR",
    "CORR",
    "COVAR_POP",
    "COVAR_SAMP",
    "JSON_AGG",
    "JSONB_AGG",
    "XMLAGG",
    "LISTAGG",
}

SQL_STRING_FUNCTIONS = {
    "UPPER",
    "LOWER",
    "SUBSTRING",
    "SUBSTR",
    "TRIM",
    "LENGTH",
    "LEN",
    "CONCAT",
    "REPLACE",
    "LEFT",
    "RIGHT",
    "LPAD",
    "RPAD",
    "SPLIT_PART",
    "CHAR_LENGTH",
    "CHARINDEX",
    "POSITION",
    "INITCAP",
    "TO_CHAR",
    "FORMAT",
    "REGEXP_REPLACE",
    "REGEXP_MATCHES",
    "REGEXP_SUBSTR",
    "TRANSLATE",
    "STRPOS",
    "OVERLAY",
    "BTRIM",
    "LTRIM",
    "RTRIM",
    "ASCII",
    "CHR",
    "SOUNDEX",
    "DIFFERENCE",
    "CONCAT_WS",
}

SQL_DATE_FUNCTIONS = {
    "NOW",
    "GETDATE",
    "DATEADD",
    "DATEDIFF",
    "DATEPART",
    "CURRENT_DATE",
    "CURRENT_TIME",
    "CURRENT_TIMESTAMP",
    "EXTRACT",
    "TO_DATE",
    "TO_TIMESTAMP",
    # "AGE",
    "TIMESTAMPDIFF",
    "TIMESTAMPADD",
    "DAY",
    "MONTH",
    "YEAR",
    "HOUR",
    "MINUTE",
    "SECOND",
    "WEEK",
    "QUARTER",
    "TIMEZONE",
    "TIMEZONE_HOUR",
    "TIMEZONE_MINUTE",
    "ISODOW",
    "ISOWEEK",
    "JULIANDAY",
    "STRFTIME",
    "TO_UNIXTIME",
    "FROM_UNIXTIME",
    "SYSDATE",
    "SYSTIMESTAMP",
    "LOCALTIMESTAMP",
    "CURRENT_TIMEZONE",
    "LOCALTIME",
}

SQL_NUMERIC_FUNCTIONS = {
    "COUNT",
    "SUM",
    "AVG",
    "MIN",
    "MAX",
    "ROUND",
    "CEIL",
    "FLOOR",
    "ABS",
    "POWER",
    "SQRT",
    "EXP",
    "LN",
    "LOG",
    "LOG10",
    "MOD",
    "RANDOM",
    "TRUNC",
    "SIGN",
    "GREATEST",
    "LEAST",
    "DIV",
    "BIT_LENGTH",
    "OCTET_LENGTH",
    "WIDTH_BUCKET",
    "CUME_DIST",
    "DENSE_RANK",
    "PERCENT_RANK",
    "RANK",
    "ROW_NUMBER",
    "NTILE",
    "CORR",
    "COVAR_POP",
    "COVAR_SAMP",
    "VARIANCE",
    "STDDEV",
    "MEDIAN",
    "MODE",
}

ALL_SQL_FUNCTIONS = (
    SQL_AGGREGATE_FUNCTIONS
    | SQL_STRING_FUNCTIONS
    | SQL_DATE_FUNCTIONS
    | SQL_NUMERIC_FUNCTIONS
)

SQL_KEYWORDS = {  # fmt: off
    "SELECT",
    "INSERT",
    "UPDATE",
    "DELETE",
    "DISTINCT",
    "UNIQUE",
    "AS",
    "FROM",
    "JOIN",
    "INNER JOIN",
    "OUTER JOIN",
    "LEFT JOIN",
    "RIGHT JOIN",
    "FULL JOIN",
    "FULL OUTER JOIN",
    "CROSS JOIN",
    "ON",
    "WHERE",
    "LIKE",
    "AND",
    "OR",
    "IN",
    "NOT",
    "BETWEEN",
    "IS",
    "NULL",
    "CASE",
    "WHEN",
    "THEN",
    "ELSE",
    "END",
    "UNION",
    "ALL",
    "GROUP BY",
    "ORDER BY",
    "IF",
    "EXISTS",
    "ELSEIF",
    "WITH",
    "HAVING",
    "LIMIT",
    "OFFSET",
    "CAST",
    # "COUNT", "SUM", "AVG", "MIN", "MAX",
    "TRUE",
    "FALSE",
    "NULLIF",
    "COALESCE",
    # "ROUND", "LENGTH", "LEN", "SUBSTRING", "SUBSTR", "TRIM", "UPPER", "LOWER",
    # "GETDATE", "NOW", "TODAY", "DATEADD", "DATEDIFF", "DATEPART", "CONVERT",
    "CREATE",
    "ALTER",
    "DROP",
    "INDEX",
    "VIEW",
    "TRIGGER",
    "TABLE",
    "COLUMN",
    "PRIMARY KEY",
    "FOREIGN KEY",
    "UNIQUE KEY",
    "CHECK",
    "DEFAULT",
    "REFERENCES",
    "EXCEPT",
    "INTERSECT",
    "RECURSIVE",
    "INTO",
    "VALUES",
    "GRANT",
    "REVOKE",
    "COMMIT",
    "ROLLBACK",
    "SAVEPOINT",
    "TRANSACTION",
    "LOCK",
    "BEGIN",
    "END",
    "DECLARE",
    "CURSOR",
    "FETCH",
    "OPEN",
    "CLOSE",
    # "TABLESPACE",
    # "ANALYZE",
    # "EXPLAIN",
    # "VACUUM",
    "SET",
    "SHOW",
    "DESCRIBE",
    "USE",
    "RETURNS",
    # "RETURNING",
    "DATABASE",
    "SCHEMA",
    "FUNCTION",
    "PROCEDURE",
    "TRUNCATE",
    "REPLACE",
    "MERGE",
    "UPSERT",
    "ASSERT",
    "RAISE",
    "THROW",
    "LOOP",
    "EXIT",
    "CONTINUE",
    "FOR",
    "WHILE",
    "DO",
    # "LANGUAGE",
    # "PLPGSQL",
    # "PLSQL",
    # "PLV8",
    # "PLPYTHON",
    # "PLPERLU",
    # "PLTCL",
    # "PLJAVA",
}

# replace SYMBOLS + its usage with an OP pattern
MULTI_OPS = ["<=", ">=", "<>", "!=", "||", "::", "->>", "->"]
SINGLE_OPS = list("(),.;=*+-/%^&|~<>")
OP_PATTERN = (
    rf"(?:{'|'.join(map(re.escape, MULTI_OPS))}|[{re.escape(''.join(SINGLE_OPS))}])"
)
