# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class PartnerData(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    Configurations for your SnapTrade Client ID, including allowed brokerages and data access.
    """


    class MetaOapg:
        
        class properties:
            slug = schemas.StrSchema
            name = schemas.StrSchema
            logo_url = schemas.StrSchema
            
            
            class allowed_brokerages(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['Brokerage']:
                        return Brokerage
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['Brokerage'], typing.List['Brokerage']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'allowed_brokerages':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'Brokerage':
                    return super().__getitem__(i)
            can_access_trades = schemas.BoolSchema
            can_access_holdings = schemas.BoolSchema
            can_access_account_history = schemas.BoolSchema
            can_access_reference_data = schemas.BoolSchema
            can_access_portfolio_management = schemas.BoolSchema
            can_access_orders = schemas.BoolSchema
            redirect_uri = schemas.StrSchema
            pin_required = schemas.BoolSchema
            __annotations__ = {
                "slug": slug,
                "name": name,
                "logo_url": logo_url,
                "allowed_brokerages": allowed_brokerages,
                "can_access_trades": can_access_trades,
                "can_access_holdings": can_access_holdings,
                "can_access_account_history": can_access_account_history,
                "can_access_reference_data": can_access_reference_data,
                "can_access_portfolio_management": can_access_portfolio_management,
                "can_access_orders": can_access_orders,
                "redirect_uri": redirect_uri,
                "pin_required": pin_required,
            }
        additional_properties = schemas.AnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["slug"]) -> MetaOapg.properties.slug: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["logo_url"]) -> MetaOapg.properties.logo_url: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["allowed_brokerages"]) -> MetaOapg.properties.allowed_brokerages: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_trades"]) -> MetaOapg.properties.can_access_trades: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_holdings"]) -> MetaOapg.properties.can_access_holdings: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_account_history"]) -> MetaOapg.properties.can_access_account_history: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_reference_data"]) -> MetaOapg.properties.can_access_reference_data: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_portfolio_management"]) -> MetaOapg.properties.can_access_portfolio_management: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["can_access_orders"]) -> MetaOapg.properties.can_access_orders: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["redirect_uri"]) -> MetaOapg.properties.redirect_uri: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pin_required"]) -> MetaOapg.properties.pin_required: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> MetaOapg.additional_properties: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["slug"], typing_extensions.Literal["name"], typing_extensions.Literal["logo_url"], typing_extensions.Literal["allowed_brokerages"], typing_extensions.Literal["can_access_trades"], typing_extensions.Literal["can_access_holdings"], typing_extensions.Literal["can_access_account_history"], typing_extensions.Literal["can_access_reference_data"], typing_extensions.Literal["can_access_portfolio_management"], typing_extensions.Literal["can_access_orders"], typing_extensions.Literal["redirect_uri"], typing_extensions.Literal["pin_required"], str, ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["slug"]) -> typing.Union[MetaOapg.properties.slug, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> typing.Union[MetaOapg.properties.name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["logo_url"]) -> typing.Union[MetaOapg.properties.logo_url, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["allowed_brokerages"]) -> typing.Union[MetaOapg.properties.allowed_brokerages, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_trades"]) -> typing.Union[MetaOapg.properties.can_access_trades, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_holdings"]) -> typing.Union[MetaOapg.properties.can_access_holdings, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_account_history"]) -> typing.Union[MetaOapg.properties.can_access_account_history, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_reference_data"]) -> typing.Union[MetaOapg.properties.can_access_reference_data, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_portfolio_management"]) -> typing.Union[MetaOapg.properties.can_access_portfolio_management, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["can_access_orders"]) -> typing.Union[MetaOapg.properties.can_access_orders, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["redirect_uri"]) -> typing.Union[MetaOapg.properties.redirect_uri, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pin_required"]) -> typing.Union[MetaOapg.properties.pin_required, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[MetaOapg.additional_properties, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["slug"], typing_extensions.Literal["name"], typing_extensions.Literal["logo_url"], typing_extensions.Literal["allowed_brokerages"], typing_extensions.Literal["can_access_trades"], typing_extensions.Literal["can_access_holdings"], typing_extensions.Literal["can_access_account_history"], typing_extensions.Literal["can_access_reference_data"], typing_extensions.Literal["can_access_portfolio_management"], typing_extensions.Literal["can_access_orders"], typing_extensions.Literal["redirect_uri"], typing_extensions.Literal["pin_required"], str, ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        slug: typing.Union[MetaOapg.properties.slug, str, schemas.Unset] = schemas.unset,
        name: typing.Union[MetaOapg.properties.name, str, schemas.Unset] = schemas.unset,
        logo_url: typing.Union[MetaOapg.properties.logo_url, str, schemas.Unset] = schemas.unset,
        allowed_brokerages: typing.Union[MetaOapg.properties.allowed_brokerages, list, tuple, schemas.Unset] = schemas.unset,
        can_access_trades: typing.Union[MetaOapg.properties.can_access_trades, bool, schemas.Unset] = schemas.unset,
        can_access_holdings: typing.Union[MetaOapg.properties.can_access_holdings, bool, schemas.Unset] = schemas.unset,
        can_access_account_history: typing.Union[MetaOapg.properties.can_access_account_history, bool, schemas.Unset] = schemas.unset,
        can_access_reference_data: typing.Union[MetaOapg.properties.can_access_reference_data, bool, schemas.Unset] = schemas.unset,
        can_access_portfolio_management: typing.Union[MetaOapg.properties.can_access_portfolio_management, bool, schemas.Unset] = schemas.unset,
        can_access_orders: typing.Union[MetaOapg.properties.can_access_orders, bool, schemas.Unset] = schemas.unset,
        redirect_uri: typing.Union[MetaOapg.properties.redirect_uri, str, schemas.Unset] = schemas.unset,
        pin_required: typing.Union[MetaOapg.properties.pin_required, bool, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
    ) -> 'PartnerData':
        return super().__new__(
            cls,
            *args,
            slug=slug,
            name=name,
            logo_url=logo_url,
            allowed_brokerages=allowed_brokerages,
            can_access_trades=can_access_trades,
            can_access_holdings=can_access_holdings,
            can_access_account_history=can_access_account_history,
            can_access_reference_data=can_access_reference_data,
            can_access_portfolio_management=can_access_portfolio_management,
            can_access_orders=can_access_orders,
            redirect_uri=redirect_uri,
            pin_required=pin_required,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.brokerage import Brokerage
