# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraSenseArgs', 'CameraSense']

@pulumi.input_type
class CameraSenseArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[_builtins.str],
                 audio_detection: Optional[pulumi.Input['CameraSenseAudioDetectionArgs']] = None,
                 detection_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sense_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CameraSense resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input['CameraSenseAudioDetectionArgs'] audio_detection: The details of the audio detection config.
        :param pulumi.Input[_builtins.str] detection_model_id: The ID of the object detection model
        :param pulumi.Input[_builtins.str] mqtt_broker_id: The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        :param pulumi.Input[_builtins.bool] sense_enabled: Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        """
        pulumi.set(__self__, "serial", serial)
        if audio_detection is not None:
            pulumi.set(__self__, "audio_detection", audio_detection)
        if detection_model_id is not None:
            pulumi.set(__self__, "detection_model_id", detection_model_id)
        if mqtt_broker_id is not None:
            pulumi.set(__self__, "mqtt_broker_id", mqtt_broker_id)
        if sense_enabled is not None:
            pulumi.set(__self__, "sense_enabled", sense_enabled)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Input[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter(name="audioDetection")
    def audio_detection(self) -> Optional[pulumi.Input['CameraSenseAudioDetectionArgs']]:
        """
        The details of the audio detection config.
        """
        return pulumi.get(self, "audio_detection")

    @audio_detection.setter
    def audio_detection(self, value: Optional[pulumi.Input['CameraSenseAudioDetectionArgs']]):
        pulumi.set(self, "audio_detection", value)

    @_builtins.property
    @pulumi.getter(name="detectionModelId")
    def detection_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the object detection model
        """
        return pulumi.get(self, "detection_model_id")

    @detection_model_id.setter
    def detection_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detection_model_id", value)

    @_builtins.property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        """
        return pulumi.get(self, "mqtt_broker_id")

    @mqtt_broker_id.setter
    def mqtt_broker_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_broker_id", value)

    @_builtins.property
    @pulumi.getter(name="senseEnabled")
    def sense_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        """
        return pulumi.get(self, "sense_enabled")

    @sense_enabled.setter
    def sense_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sense_enabled", value)


@pulumi.input_type
class _CameraSenseState:
    def __init__(__self__, *,
                 audio_detection: Optional[pulumi.Input['CameraSenseAudioDetectionArgs']] = None,
                 detection_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sense_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CameraSense resources.
        :param pulumi.Input['CameraSenseAudioDetectionArgs'] audio_detection: The details of the audio detection config.
        :param pulumi.Input[_builtins.str] detection_model_id: The ID of the object detection model
        :param pulumi.Input[_builtins.str] mqtt_broker_id: The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        :param pulumi.Input[_builtins.bool] sense_enabled: Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        """
        if audio_detection is not None:
            pulumi.set(__self__, "audio_detection", audio_detection)
        if detection_model_id is not None:
            pulumi.set(__self__, "detection_model_id", detection_model_id)
        if mqtt_broker_id is not None:
            pulumi.set(__self__, "mqtt_broker_id", mqtt_broker_id)
        if mqtt_topics is not None:
            pulumi.set(__self__, "mqtt_topics", mqtt_topics)
        if sense_enabled is not None:
            pulumi.set(__self__, "sense_enabled", sense_enabled)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)

    @_builtins.property
    @pulumi.getter(name="audioDetection")
    def audio_detection(self) -> Optional[pulumi.Input['CameraSenseAudioDetectionArgs']]:
        """
        The details of the audio detection config.
        """
        return pulumi.get(self, "audio_detection")

    @audio_detection.setter
    def audio_detection(self, value: Optional[pulumi.Input['CameraSenseAudioDetectionArgs']]):
        pulumi.set(self, "audio_detection", value)

    @_builtins.property
    @pulumi.getter(name="detectionModelId")
    def detection_model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the object detection model
        """
        return pulumi.get(self, "detection_model_id")

    @detection_model_id.setter
    def detection_model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detection_model_id", value)

    @_builtins.property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        """
        return pulumi.get(self, "mqtt_broker_id")

    @mqtt_broker_id.setter
    def mqtt_broker_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mqtt_broker_id", value)

    @_builtins.property
    @pulumi.getter(name="mqttTopics")
    def mqtt_topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "mqtt_topics")

    @mqtt_topics.setter
    def mqtt_topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mqtt_topics", value)

    @_builtins.property
    @pulumi.getter(name="senseEnabled")
    def sense_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        """
        return pulumi.get(self, "sense_enabled")

    @sense_enabled.setter
    def sense_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sense_enabled", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)


@pulumi.type_token("meraki:devices/cameraSense:CameraSense")
class CameraSense(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_detection: Optional[pulumi.Input[Union['CameraSenseAudioDetectionArgs', 'CameraSenseAudioDetectionArgsDict']]] = None,
                 detection_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sense_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraSense("example",
            audio_detection={
                "enabled": False,
            },
            mqtt_broker_id="1234",
            sense_enabled=True,
            serial="string")
        pulumi.export("merakiDevicesCameraSenseExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraSense:CameraSense example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraSenseAudioDetectionArgs', 'CameraSenseAudioDetectionArgsDict']] audio_detection: The details of the audio detection config.
        :param pulumi.Input[_builtins.str] detection_model_id: The ID of the object detection model
        :param pulumi.Input[_builtins.str] mqtt_broker_id: The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        :param pulumi.Input[_builtins.bool] sense_enabled: Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraSenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraSense("example",
            audio_detection={
                "enabled": False,
            },
            mqtt_broker_id="1234",
            sense_enabled=True,
            serial="string")
        pulumi.export("merakiDevicesCameraSenseExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraSense:CameraSense example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CameraSenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraSenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_detection: Optional[pulumi.Input[Union['CameraSenseAudioDetectionArgs', 'CameraSenseAudioDetectionArgsDict']]] = None,
                 detection_model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mqtt_broker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sense_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraSenseArgs.__new__(CameraSenseArgs)

            __props__.__dict__["audio_detection"] = audio_detection
            __props__.__dict__["detection_model_id"] = detection_model_id
            __props__.__dict__["mqtt_broker_id"] = mqtt_broker_id
            __props__.__dict__["sense_enabled"] = sense_enabled
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["mqtt_topics"] = None
        super(CameraSense, __self__).__init__(
            'meraki:devices/cameraSense:CameraSense',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audio_detection: Optional[pulumi.Input[Union['CameraSenseAudioDetectionArgs', 'CameraSenseAudioDetectionArgsDict']]] = None,
            detection_model_id: Optional[pulumi.Input[_builtins.str]] = None,
            mqtt_broker_id: Optional[pulumi.Input[_builtins.str]] = None,
            mqtt_topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sense_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None) -> 'CameraSense':
        """
        Get an existing CameraSense resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CameraSenseAudioDetectionArgs', 'CameraSenseAudioDetectionArgsDict']] audio_detection: The details of the audio detection config.
        :param pulumi.Input[_builtins.str] detection_model_id: The ID of the object detection model
        :param pulumi.Input[_builtins.str] mqtt_broker_id: The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        :param pulumi.Input[_builtins.bool] sense_enabled: Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraSenseState.__new__(_CameraSenseState)

        __props__.__dict__["audio_detection"] = audio_detection
        __props__.__dict__["detection_model_id"] = detection_model_id
        __props__.__dict__["mqtt_broker_id"] = mqtt_broker_id
        __props__.__dict__["mqtt_topics"] = mqtt_topics
        __props__.__dict__["sense_enabled"] = sense_enabled
        __props__.__dict__["serial"] = serial
        return CameraSense(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="audioDetection")
    def audio_detection(self) -> pulumi.Output['outputs.CameraSenseAudioDetection']:
        """
        The details of the audio detection config.
        """
        return pulumi.get(self, "audio_detection")

    @_builtins.property
    @pulumi.getter(name="detectionModelId")
    def detection_model_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the object detection model
        """
        return pulumi.get(self, "detection_model_id")

    @_builtins.property
    @pulumi.getter(name="mqttBrokerId")
    def mqtt_broker_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the MQTT broker to be enabled on the camera. A value of null will disable MQTT on the camera
        """
        return pulumi.get(self, "mqtt_broker_id")

    @_builtins.property
    @pulumi.getter(name="mqttTopics")
    def mqtt_topics(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "mqtt_topics")

    @_builtins.property
    @pulumi.getter(name="senseEnabled")
    def sense_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean indicating if sense(license) is enabled(true) or disabled(false) on the camera
        """
        return pulumi.get(self, "sense_enabled")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

