# -*- coding: utf-8 -*-

# Copyright (c) 2022, Alexei Znamensky <russoz@gmail.com>
# GNU General Public License v3.0+ (see LICENSES/GPL-3.0-or-later.txt or https://www.gnu.org/licenses/gpl-3.0.txt)
# SPDX-License-Identifier: GPL-3.0-or-later

import pytest

from magorder.data import SIDataMagnitudeUnit, IECDataMagnitudeUnit


def test_si_data():
    mags = SIDataMagnitudeUnit("b")
    assert mags.transform(1, "kb") == 1000
    assert mags.transform(1, "Gb", "kb") == 1_000_000


def test_iec_data():
    mags = IECDataMagnitudeUnit("b")
    assert mags.transform(1, "Kib") == 1024
    assert mags.transform(4096, from_unit="Mib", to_unit="Gib") == 4


def test_iec_data_legacy():
    mags = IECDataMagnitudeUnit("bps", legacy=True)
    assert mags.transform(1, "Kibps") == 1024
    assert mags.transform(4096, from_unit="Mibps", to_unit="Gibps") == 4
    assert mags.transform(1, "Kbps") == 1024
    assert mags.transform(8192, from_unit="Mbps", to_unit="Gbps") == 8


def test_iec_data_case_insensitive():
    mags = IECDataMagnitudeUnit("bps", case=False)
    assert mags.transform(1, "kibps") == 1024
    assert mags.transform(4096, from_unit="mibps", to_unit="Gibps") == 4
    assert mags.transform(1, "Kibps") == 1024
    assert mags.transform(8192, from_unit="Mibps", to_unit="gibps") == 8

# code: language=python tabSize=4
