import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#allow_new_private_endpoint_connections AppServiceEnvironmentV3#allow_new_private_endpoint_connections}.
     *
     * @stability stable
     */
    readonly allowNewPrivateEndpointConnections?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#dedicated_host_count AppServiceEnvironmentV3#dedicated_host_count}.
     *
     * @stability stable
     */
    readonly dedicatedHostCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#internal_load_balancing_mode AppServiceEnvironmentV3#internal_load_balancing_mode}.
     *
     * @stability stable
     */
    readonly internalLoadBalancingMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#name AppServiceEnvironmentV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#resource_group_name AppServiceEnvironmentV3#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#subnet_id AppServiceEnvironmentV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#tags AppServiceEnvironmentV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#zone_redundant AppServiceEnvironmentV3#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
     * cluster_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#cluster_setting AppServiceEnvironmentV3#cluster_setting}
     *
     * @stability stable
     */
    readonly clusterSetting?: AppServiceEnvironmentV3ClusterSetting[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#timeouts AppServiceEnvironmentV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceEnvironmentV3Timeouts;
}
/**
 * @stability stable
 */
export declare class AppServiceEnvironmentV3InboundNetworkDependencies extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get ports(): string[];
}
/**
 * @stability stable
 */
export interface AppServiceEnvironmentV3ClusterSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#name AppServiceEnvironmentV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#value AppServiceEnvironmentV3#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function appServiceEnvironmentV3ClusterSettingToTerraform(struct?: AppServiceEnvironmentV3ClusterSetting): any;
/**
 * @stability stable
 */
export interface AppServiceEnvironmentV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#create AppServiceEnvironmentV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#delete AppServiceEnvironmentV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#read AppServiceEnvironmentV3#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html#update AppServiceEnvironmentV3#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceEnvironmentV3TimeoutsToTerraform(struct?: AppServiceEnvironmentV3TimeoutsOutputReference | AppServiceEnvironmentV3Timeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceEnvironmentV3Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceEnvironmentV3Timeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html azurerm_app_service_environment_v3}.
 *
 * @stability stable
 */
export declare class AppServiceEnvironmentV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3.html azurerm_app_service_environment_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentV3Config);
    private _allowNewPrivateEndpointConnections?;
    /**
     * @stability stable
     */
    get allowNewPrivateEndpointConnections(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowNewPrivateEndpointConnections(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowNewPrivateEndpointConnections(): void;
    /**
     * @stability stable
     */
    get allowNewPrivateEndpointConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _dedicatedHostCount?;
    /**
     * @stability stable
     */
    get dedicatedHostCount(): number;
    /**
     * @stability stable
     */
    set dedicatedHostCount(value: number);
    /**
     * @stability stable
     */
    resetDedicatedHostCount(): void;
    /**
     * @stability stable
     */
    get dedicatedHostCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get dnsSuffix(): string;
    /**
     * @stability stable
     */
    get externalInboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    inboundNetworkDependencies(index: string): AppServiceEnvironmentV3InboundNetworkDependencies;
    /**
     * @stability stable
     */
    get internalInboundIpAddresses(): string[];
    private _internalLoadBalancingMode?;
    /**
     * @stability stable
     */
    get internalLoadBalancingMode(): string;
    /**
     * @stability stable
     */
    set internalLoadBalancingMode(value: string);
    /**
     * @stability stable
     */
    resetInternalLoadBalancingMode(): void;
    /**
     * @stability stable
     */
    get internalLoadBalancingModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get ipSslAddressCount(): number;
    /**
     * @stability stable
     */
    get linuxOutboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pricingTier(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get windowsOutboundIpAddresses(): string[];
    private _zoneRedundant?;
    /**
     * @stability stable
     */
    get zoneRedundant(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundant(): void;
    /**
     * @stability stable
     */
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterSetting?;
    /**
     * @stability stable
     */
    get clusterSetting(): AppServiceEnvironmentV3ClusterSetting[];
    /**
     * @stability stable
     */
    set clusterSetting(value: AppServiceEnvironmentV3ClusterSetting[]);
    /**
     * @stability stable
     */
    resetClusterSetting(): void;
    /**
     * @stability stable
     */
    get clusterSettingInput(): AppServiceEnvironmentV3ClusterSetting[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceEnvironmentV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceEnvironmentV3Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceEnvironmentV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
