import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbGremlinDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#account_name CosmosdbGremlinDatabase#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#name CosmosdbGremlinDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#resource_group_name CosmosdbGremlinDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#throughput CosmosdbGremlinDatabase#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#autoscale_settings CosmosdbGremlinDatabase#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbGremlinDatabaseAutoscaleSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#timeouts CosmosdbGremlinDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbGremlinDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinDatabaseAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#max_throughput CosmosdbGremlinDatabase#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbGremlinDatabaseAutoscaleSettingsToTerraform(struct?: CosmosdbGremlinDatabaseAutoscaleSettingsOutputReference | CosmosdbGremlinDatabaseAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinDatabaseAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinDatabaseAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinDatabaseAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#create CosmosdbGremlinDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#delete CosmosdbGremlinDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#read CosmosdbGremlinDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html#update CosmosdbGremlinDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbGremlinDatabaseTimeoutsToTerraform(struct?: CosmosdbGremlinDatabaseTimeoutsOutputReference | CosmosdbGremlinDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html azurerm_cosmosdb_gremlin_database}.
 *
 * @stability stable
 */
export declare class CosmosdbGremlinDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_database.html azurerm_cosmosdb_gremlin_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbGremlinDatabaseConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbGremlinDatabaseAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbGremlinDatabaseAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbGremlinDatabaseAutoscaleSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbGremlinDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbGremlinDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbGremlinDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
