import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAvailabilitySetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html#name DataAzurermAvailabilitySet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html#resource_group_name DataAzurermAvailabilitySet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html#timeouts DataAzurermAvailabilitySet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAvailabilitySetTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermAvailabilitySetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html#read DataAzurermAvailabilitySet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAvailabilitySetTimeoutsToTerraform(struct?: DataAzurermAvailabilitySetTimeoutsOutputReference | DataAzurermAvailabilitySetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAvailabilitySetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAvailabilitySetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAvailabilitySetTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html azurerm_availability_set}.
 *
 * @stability stable
 */
export declare class DataAzurermAvailabilitySet extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set.html azurerm_availability_set} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAvailabilitySetConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get managed(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get platformFaultDomainCount(): string;
    /**
     * @stability stable
     */
    get platformUpdateDomainCount(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAvailabilitySetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAvailabilitySetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAvailabilitySetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
