import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBlueprintPublishedVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html#blueprint_name DataAzurermBlueprintPublishedVersion#blueprint_name}.
     *
     * @stability stable
     */
    readonly blueprintName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html#scope_id DataAzurermBlueprintPublishedVersion#scope_id}.
     *
     * @stability stable
     */
    readonly scopeId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html#version DataAzurermBlueprintPublishedVersion#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html#timeouts DataAzurermBlueprintPublishedVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBlueprintPublishedVersionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBlueprintPublishedVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html#read DataAzurermBlueprintPublishedVersion#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBlueprintPublishedVersionTimeoutsToTerraform(struct?: DataAzurermBlueprintPublishedVersionTimeoutsOutputReference | DataAzurermBlueprintPublishedVersionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBlueprintPublishedVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBlueprintPublishedVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBlueprintPublishedVersionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html azurerm_blueprint_published_version}.
 *
 * @stability stable
 */
export declare class DataAzurermBlueprintPublishedVersion extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version.html azurerm_blueprint_published_version} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBlueprintPublishedVersionConfig);
    private _blueprintName?;
    /**
     * @stability stable
     */
    get blueprintName(): string;
    /**
     * @stability stable
     */
    set blueprintName(value: string);
    /**
     * @stability stable
     */
    get blueprintNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastModified(): string;
    private _scopeId?;
    /**
     * @stability stable
     */
    get scopeId(): string;
    /**
     * @stability stable
     */
    set scopeId(value: string);
    /**
     * @stability stable
     */
    get scopeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get targetScope(): string;
    /**
     * @stability stable
     */
    get timeCreated(): string;
    /**
     * @stability stable
     */
    get type(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBlueprintPublishedVersionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBlueprintPublishedVersionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBlueprintPublishedVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
