import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbRestorableDatabaseAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html#location DataAzurermCosmosdbRestorableDatabaseAccounts#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html#name DataAzurermCosmosdbRestorableDatabaseAccounts#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html#timeouts DataAzurermCosmosdbRestorableDatabaseAccounts#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get deletionTime(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get regionalDatabaseAccountInstanceId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccounts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get apiType(): string;
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get deletionTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get restorableLocations(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html#read DataAzurermCosmosdbRestorableDatabaseAccounts#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsToTerraform(struct?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference | DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html azurerm_cosmosdb_restorable_database_accounts}.
 *
 * @stability stable
 */
export declare class DataAzurermCosmosdbRestorableDatabaseAccounts extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts.html azurerm_cosmosdb_restorable_database_accounts} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbRestorableDatabaseAccountsConfig);
    /**
     * @stability stable
     */
    accounts(index: string): DataAzurermCosmosdbRestorableDatabaseAccountsAccounts;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
