import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html#name DataAzurermKubernetesCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html#resource_group_name DataAzurermKubernetesCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html#timeouts DataAzurermKubernetesCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKubernetesClusterTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get secretIdentity(): any;
    /**
     * @stability stable
     */
    get secretRotationEnabled(): string;
    /**
     * @stability stable
     */
    get secretRotationInterval(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileAzurePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get httpApplicationRoutingZoneName(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get effectiveGatewayId(): string;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get gatewayId(): string;
    /**
     * @stability stable
     */
    get ingressApplicationGatewayIdentity(): any;
    /**
     * @stability stable
     */
    get subnetCidr(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileKubeDashboard extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgent extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    get omsAgentIdentity(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfileOpenServiceMesh extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAddonProfile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get azureKeyvaultSecretsProvider(): any;
    /**
     * @stability stable
     */
    get azurePolicy(): any;
    /**
     * @stability stable
     */
    get httpApplicationRouting(): any;
    /**
     * @stability stable
     */
    get ingressApplicationGateway(): any;
    /**
     * @stability stable
     */
    get kubeDashboard(): any;
    /**
     * @stability stable
     */
    get omsAgent(): any;
    /**
     * @stability stable
     */
    get openServiceMesh(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxSurge(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterAgentPoolProfile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    get enableAutoScaling(): any;
    /**
     * @stability stable
     */
    get enableNodePublicIp(): any;
    /**
     * @stability stable
     */
    get maxCount(): number;
    /**
     * @stability stable
     */
    get maxPods(): number;
    /**
     * @stability stable
     */
    get minCount(): number;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get nodeLabels(): any;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixId(): string;
    /**
     * @stability stable
     */
    get nodeTaints(): string[];
    /**
     * @stability stable
     */
    get orchestratorVersion(): string;
    /**
     * @stability stable
     */
    get osDiskSizeGb(): number;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    get tags(): any;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get upgradeSettings(): any;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    get vnetSubnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterKubeAdminConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get clusterCaCertificate(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterKubeConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get clusterCaCertificate(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterKubeletIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterLinuxProfileSshKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyData(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterLinuxProfile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    get sshKey(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterNetworkProfile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dnsServiceIp(): string;
    /**
     * @stability stable
     */
    get dockerBridgeCidr(): string;
    /**
     * @stability stable
     */
    get loadBalancerSku(): string;
    /**
     * @stability stable
     */
    get networkPlugin(): string;
    /**
     * @stability stable
     */
    get networkPolicy(): string;
    /**
     * @stability stable
     */
    get podCidr(): string;
    /**
     * @stability stable
     */
    get serviceCidr(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminGroupObjectIds(): string[];
    /**
     * @stability stable
     */
    get clientAppId(): string;
    /**
     * @stability stable
     */
    get managed(): any;
    /**
     * @stability stable
     */
    get serverAppId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterRoleBasedAccessControl extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get azureActiveDirectory(): any;
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterServicePrincipal extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterWindowsProfile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminUsername(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermKubernetesClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html#read DataAzurermKubernetesCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterTimeoutsOutputReference | DataAzurermKubernetesClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKubernetesClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKubernetesClusterTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html azurerm_kubernetes_cluster}.
 *
 * @stability stable
 */
export declare class DataAzurermKubernetesCluster extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster.html azurerm_kubernetes_cluster} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterConfig);
    /**
     * @stability stable
     */
    addonProfile(index: string): DataAzurermKubernetesClusterAddonProfile;
    /**
     * @stability stable
     */
    agentPoolProfile(index: string): DataAzurermKubernetesClusterAgentPoolProfile;
    /**
     * @stability stable
     */
    get apiServerAuthorizedIpRanges(): string[];
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    get dnsPrefix(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermKubernetesClusterIdentity;
    /**
     * @stability stable
     */
    kubeAdminConfig(index: string): DataAzurermKubernetesClusterKubeAdminConfig;
    /**
     * @stability stable
     */
    get kubeAdminConfigRaw(): string;
    /**
     * @stability stable
     */
    kubeConfig(index: string): DataAzurermKubernetesClusterKubeConfig;
    /**
     * @stability stable
     */
    get kubeConfigRaw(): string;
    /**
     * @stability stable
     */
    kubeletIdentity(index: string): DataAzurermKubernetesClusterKubeletIdentity;
    /**
     * @stability stable
     */
    get kubernetesVersion(): string;
    /**
     * @stability stable
     */
    linuxProfile(index: string): DataAzurermKubernetesClusterLinuxProfile;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkProfile(index: string): DataAzurermKubernetesClusterNetworkProfile;
    /**
     * @stability stable
     */
    get nodeResourceGroup(): string;
    /**
     * @stability stable
     */
    get privateClusterEnabled(): any;
    /**
     * @stability stable
     */
    get privateFqdn(): string;
    /**
     * @stability stable
     */
    get privateLinkEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    roleBasedAccessControl(index: string): DataAzurermKubernetesClusterRoleBasedAccessControl;
    /**
     * @stability stable
     */
    servicePrincipal(index: string): DataAzurermKubernetesClusterServicePrincipal;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    windowsProfile(index: string): DataAzurermKubernetesClusterWindowsProfile;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKubernetesClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKubernetesClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKubernetesClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
