import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLogAnalyticsWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html#name DataAzurermLogAnalyticsWorkspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html#resource_group_name DataAzurermLogAnalyticsWorkspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html#timeouts DataAzurermLogAnalyticsWorkspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLogAnalyticsWorkspaceTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermLogAnalyticsWorkspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html#read DataAzurermLogAnalyticsWorkspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLogAnalyticsWorkspaceTimeoutsToTerraform(struct?: DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference | DataAzurermLogAnalyticsWorkspaceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLogAnalyticsWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLogAnalyticsWorkspaceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html azurerm_log_analytics_workspace}.
 *
 * @stability stable
 */
export declare class DataAzurermLogAnalyticsWorkspace extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace.html azurerm_log_analytics_workspace} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLogAnalyticsWorkspaceConfig);
    /**
     * @stability stable
     */
    get dailyQuotaGb(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get portalUrl(): string;
    /**
     * @stability stable
     */
    get primarySharedKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    get secondarySharedKey(): string;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLogAnalyticsWorkspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLogAnalyticsWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
