import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMssqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html#name DataAzurermMssqlDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html#server_id DataAzurermMssqlDatabase#server_id}.
     *
     * @stability stable
     */
    readonly serverId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html#timeouts DataAzurermMssqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMssqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermMssqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html#read DataAzurermMssqlDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMssqlDatabaseTimeoutsToTerraform(struct?: DataAzurermMssqlDatabaseTimeoutsOutputReference | DataAzurermMssqlDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMssqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMssqlDatabaseTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html azurerm_mssql_database}.
 *
 * @stability stable
 */
export declare class DataAzurermMssqlDatabase extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database.html azurerm_mssql_database} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlDatabaseConfig);
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    get elasticPoolId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    get maxSizeGb(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get readReplicaCount(): number;
    /**
     * @stability stable
     */
    get readScale(): any;
    private _serverId?;
    /**
     * @stability stable
     */
    get serverId(): string;
    /**
     * @stability stable
     */
    set serverId(value: string);
    /**
     * @stability stable
     */
    get serverIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zoneRedundant(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMssqlDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMssqlDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMssqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
