import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMssqlElasticpoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html#name DataAzurermMssqlElasticpool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html#resource_group_name DataAzurermMssqlElasticpool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html#server_name DataAzurermMssqlElasticpool#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html#timeouts DataAzurermMssqlElasticpool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMssqlElasticpoolTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMssqlElasticpoolSku extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get tier(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermMssqlElasticpoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html#read DataAzurermMssqlElasticpool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMssqlElasticpoolTimeoutsToTerraform(struct?: DataAzurermMssqlElasticpoolTimeoutsOutputReference | DataAzurermMssqlElasticpoolTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMssqlElasticpoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMssqlElasticpoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMssqlElasticpoolTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html azurerm_mssql_elasticpool}.
 *
 * @stability stable
 */
export declare class DataAzurermMssqlElasticpool extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_elasticpool.html azurerm_mssql_elasticpool} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlElasticpoolConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get maxSizeBytes(): number;
    /**
     * @stability stable
     */
    get maxSizeGb(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get perDbMaxCapacity(): number;
    /**
     * @stability stable
     */
    get perDbMinCapacity(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    /**
     * @stability stable
     */
    sku(index: string): DataAzurermMssqlElasticpoolSku;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zoneRedundant(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMssqlElasticpoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMssqlElasticpoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMssqlElasticpoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
