import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNatGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#name DataAzurermNatGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#public_ip_address_ids DataAzurermNatGateway#public_ip_address_ids}.
     *
     * @stability stable
     */
    readonly publicIpAddressIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#public_ip_prefix_ids DataAzurermNatGateway#public_ip_prefix_ids}.
     *
     * @stability stable
     */
    readonly publicIpPrefixIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#resource_group_name DataAzurermNatGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#timeouts DataAzurermNatGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNatGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermNatGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html#read DataAzurermNatGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNatGatewayTimeoutsToTerraform(struct?: DataAzurermNatGatewayTimeoutsOutputReference | DataAzurermNatGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermNatGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNatGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNatGatewayTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html azurerm_nat_gateway}.
 *
 * @stability stable
 */
export declare class DataAzurermNatGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/nat_gateway.html azurerm_nat_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNatGatewayConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicIpAddressIds?;
    /**
     * @stability stable
     */
    get publicIpAddressIds(): string[];
    /**
     * @stability stable
     */
    set publicIpAddressIds(value: string[]);
    /**
     * @stability stable
     */
    resetPublicIpAddressIds(): void;
    /**
     * @stability stable
     */
    get publicIpAddressIdsInput(): string[] | undefined;
    private _publicIpPrefixIds?;
    /**
     * @stability stable
     */
    get publicIpPrefixIds(): string[];
    /**
     * @stability stable
     */
    set publicIpPrefixIds(value: string[]);
    /**
     * @stability stable
     */
    resetPublicIpPrefixIds(): void;
    /**
     * @stability stable
     */
    get publicIpPrefixIdsInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceGuid(): string;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zones(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNatGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNatGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNatGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
