import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultCertificateIssuerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#account_id KeyVaultCertificateIssuer#account_id}.
     *
     * @stability stable
     */
    readonly accountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#key_vault_id KeyVaultCertificateIssuer#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#name KeyVaultCertificateIssuer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#org_id KeyVaultCertificateIssuer#org_id}.
     *
     * @stability stable
     */
    readonly orgId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#password KeyVaultCertificateIssuer#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#provider_name KeyVaultCertificateIssuer#provider_name}.
     *
     * @stability stable
     */
    readonly providerName: string;
    /**
     * admin block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#admin KeyVaultCertificateIssuer#admin}
     *
     * @stability stable
     */
    readonly admin?: KeyVaultCertificateIssuerAdmin[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#timeouts KeyVaultCertificateIssuer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultCertificateIssuerTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateIssuerAdmin {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#email_address KeyVaultCertificateIssuer#email_address}.
     *
     * @stability stable
     */
    readonly emailAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#first_name KeyVaultCertificateIssuer#first_name}.
     *
     * @stability stable
     */
    readonly firstName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#last_name KeyVaultCertificateIssuer#last_name}.
     *
     * @stability stable
     */
    readonly lastName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#phone KeyVaultCertificateIssuer#phone}.
     *
     * @stability stable
     */
    readonly phone?: string;
}
export declare function keyVaultCertificateIssuerAdminToTerraform(struct?: KeyVaultCertificateIssuerAdmin): any;
/**
 * @stability stable
 */
export interface KeyVaultCertificateIssuerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#create KeyVaultCertificateIssuer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#delete KeyVaultCertificateIssuer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#read KeyVaultCertificateIssuer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html#update KeyVaultCertificateIssuer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultCertificateIssuerTimeoutsToTerraform(struct?: KeyVaultCertificateIssuerTimeoutsOutputReference | KeyVaultCertificateIssuerTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateIssuerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateIssuerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateIssuerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html azurerm_key_vault_certificate_issuer}.
 *
 * @stability stable
 */
export declare class KeyVaultCertificateIssuer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate_issuer.html azurerm_key_vault_certificate_issuer} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultCertificateIssuerConfig);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    resetAccountId(): void;
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    resetOrgId(): void;
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _providerName?;
    /**
     * @stability stable
     */
    get providerName(): string;
    /**
     * @stability stable
     */
    set providerName(value: string);
    /**
     * @stability stable
     */
    get providerNameInput(): string | undefined;
    private _admin?;
    /**
     * @stability stable
     */
    get admin(): KeyVaultCertificateIssuerAdmin[];
    /**
     * @stability stable
     */
    set admin(value: KeyVaultCertificateIssuerAdmin[]);
    /**
     * @stability stable
     */
    resetAdmin(): void;
    /**
     * @stability stable
     */
    get adminInput(): KeyVaultCertificateIssuerAdmin[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultCertificateIssuerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultCertificateIssuerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultCertificateIssuerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
