import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#access_policy KeyVault#access_policy}.
     *
     * @stability stable
     */
    readonly accessPolicy?: KeyVaultAccessPolicy[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#enable_rbac_authorization KeyVault#enable_rbac_authorization}.
     *
     * @stability stable
     */
    readonly enableRbacAuthorization?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#enabled_for_deployment KeyVault#enabled_for_deployment}.
     *
     * @stability stable
     */
    readonly enabledForDeployment?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#enabled_for_disk_encryption KeyVault#enabled_for_disk_encryption}.
     *
     * @stability stable
     */
    readonly enabledForDiskEncryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#enabled_for_template_deployment KeyVault#enabled_for_template_deployment}.
     *
     * @stability stable
     */
    readonly enabledForTemplateDeployment?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#location KeyVault#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#name KeyVault#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#purge_protection_enabled KeyVault#purge_protection_enabled}.
     *
     * @stability stable
     */
    readonly purgeProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#resource_group_name KeyVault#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#sku_name KeyVault#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#soft_delete_enabled KeyVault#soft_delete_enabled}.
     *
     * @stability stable
     */
    readonly softDeleteEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#soft_delete_retention_days KeyVault#soft_delete_retention_days}.
     *
     * @stability stable
     */
    readonly softDeleteRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#tags KeyVault#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#tenant_id KeyVault#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
    /**
     * contact block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#contact KeyVault#contact}
     *
     * @stability stable
     */
    readonly contact?: KeyVaultContact[];
    /**
     * network_acls block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#network_acls KeyVault#network_acls}
     *
     * @stability stable
     */
    readonly networkAcls?: KeyVaultNetworkAcls;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#timeouts KeyVault#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultAccessPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#application_id KeyVault#application_id}.
     *
     * @stability stable
     */
    readonly applicationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#certificate_permissions KeyVault#certificate_permissions}.
     *
     * @stability stable
     */
    readonly certificatePermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#key_permissions KeyVault#key_permissions}.
     *
     * @stability stable
     */
    readonly keyPermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#object_id KeyVault#object_id}.
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#secret_permissions KeyVault#secret_permissions}.
     *
     * @stability stable
     */
    readonly secretPermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#storage_permissions KeyVault#storage_permissions}.
     *
     * @stability stable
     */
    readonly storagePermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#tenant_id KeyVault#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function keyVaultAccessPolicyToTerraform(struct?: KeyVaultAccessPolicy): any;
/**
 * @stability stable
 */
export interface KeyVaultContact {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#email KeyVault#email}.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#name KeyVault#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#phone KeyVault#phone}.
     *
     * @stability stable
     */
    readonly phone?: string;
}
export declare function keyVaultContactToTerraform(struct?: KeyVaultContact): any;
/**
 * @stability stable
 */
export interface KeyVaultNetworkAcls {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#bypass KeyVault#bypass}.
     *
     * @stability stable
     */
    readonly bypass: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#default_action KeyVault#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#ip_rules KeyVault#ip_rules}.
     *
     * @stability stable
     */
    readonly ipRules?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#virtual_network_subnet_ids KeyVault#virtual_network_subnet_ids}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetIds?: string[];
}
export declare function keyVaultNetworkAclsToTerraform(struct?: KeyVaultNetworkAclsOutputReference | KeyVaultNetworkAcls): any;
/**
 * @stability stable
 */
export declare class KeyVaultNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultNetworkAcls | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultNetworkAcls | undefined);
    private _bypass?;
    /**
     * @stability stable
     */
    get bypass(): string;
    /**
     * @stability stable
     */
    set bypass(value: string);
    /**
     * @stability stable
     */
    get bypassInput(): string | undefined;
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    set ipRules(value: string[]);
    /**
     * @stability stable
     */
    resetIpRules(): void;
    /**
     * @stability stable
     */
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkSubnetIds?;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIds(): string[];
    /**
     * @stability stable
     */
    set virtualNetworkSubnetIds(value: string[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkSubnetIds(): void;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#create KeyVault#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#delete KeyVault#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#read KeyVault#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html#update KeyVault#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultTimeoutsToTerraform(struct?: KeyVaultTimeoutsOutputReference | KeyVaultTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html azurerm_key_vault}.
 *
 * @stability stable
 */
export declare class KeyVault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault.html azurerm_key_vault} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultConfig);
    private _accessPolicy?;
    /**
     * @stability stable
     */
    get accessPolicy(): KeyVaultAccessPolicy[];
    /**
     * @stability stable
     */
    set accessPolicy(value: KeyVaultAccessPolicy[]);
    /**
     * @stability stable
     */
    resetAccessPolicy(): void;
    /**
     * @stability stable
     */
    get accessPolicyInput(): KeyVaultAccessPolicy[] | undefined;
    private _enableRbacAuthorization?;
    /**
     * @stability stable
     */
    get enableRbacAuthorization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableRbacAuthorization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableRbacAuthorization(): void;
    /**
     * @stability stable
     */
    get enableRbacAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDeployment?;
    /**
     * @stability stable
     */
    get enabledForDeployment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabledForDeployment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabledForDeployment(): void;
    /**
     * @stability stable
     */
    get enabledForDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDiskEncryption?;
    /**
     * @stability stable
     */
    get enabledForDiskEncryption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabledForDiskEncryption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabledForDiskEncryption(): void;
    /**
     * @stability stable
     */
    get enabledForDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForTemplateDeployment?;
    /**
     * @stability stable
     */
    get enabledForTemplateDeployment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabledForTemplateDeployment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabledForTemplateDeployment(): void;
    /**
     * @stability stable
     */
    get enabledForTemplateDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _purgeProtectionEnabled?;
    /**
     * @stability stable
     */
    get purgeProtectionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set purgeProtectionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPurgeProtectionEnabled(): void;
    /**
     * @stability stable
     */
    get purgeProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _softDeleteEnabled?;
    /**
     * @stability stable
     */
    get softDeleteEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set softDeleteEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSoftDeleteEnabled(): void;
    /**
     * @stability stable
     */
    get softDeleteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _softDeleteRetentionDays?;
    /**
     * @stability stable
     */
    get softDeleteRetentionDays(): number;
    /**
     * @stability stable
     */
    set softDeleteRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetSoftDeleteRetentionDays(): void;
    /**
     * @stability stable
     */
    get softDeleteRetentionDaysInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get vaultUri(): string;
    private _contact?;
    /**
     * @stability stable
     */
    get contact(): KeyVaultContact[];
    /**
     * @stability stable
     */
    set contact(value: KeyVaultContact[]);
    /**
     * @stability stable
     */
    resetContact(): void;
    /**
     * @stability stable
     */
    get contactInput(): KeyVaultContact[] | undefined;
    private _networkAcls;
    /**
     * @stability stable
     */
    get networkAcls(): KeyVaultNetworkAclsOutputReference;
    /**
     * @stability stable
     */
    putNetworkAcls(value: KeyVaultNetworkAcls): void;
    /**
     * @stability stable
     */
    resetNetworkAcls(): void;
    /**
     * @stability stable
     */
    get networkAclsInput(): KeyVaultNetworkAcls | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
