import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoEventhubDataConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#cluster_name KustoEventhubDataConnection#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#compression KustoEventhubDataConnection#compression}.
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#consumer_group KustoEventhubDataConnection#consumer_group}.
     *
     * @stability stable
     */
    readonly consumerGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#data_format KustoEventhubDataConnection#data_format}.
     *
     * @stability stable
     */
    readonly dataFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#database_name KustoEventhubDataConnection#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#event_system_properties KustoEventhubDataConnection#event_system_properties}.
     *
     * @stability stable
     */
    readonly eventSystemProperties?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#eventhub_id KustoEventhubDataConnection#eventhub_id}.
     *
     * @stability stable
     */
    readonly eventhubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#identity_id KustoEventhubDataConnection#identity_id}.
     *
     * @stability stable
     */
    readonly identityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#location KustoEventhubDataConnection#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#mapping_rule_name KustoEventhubDataConnection#mapping_rule_name}.
     *
     * @stability stable
     */
    readonly mappingRuleName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#name KustoEventhubDataConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#resource_group_name KustoEventhubDataConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#table_name KustoEventhubDataConnection#table_name}.
     *
     * @stability stable
     */
    readonly tableName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#timeouts KustoEventhubDataConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoEventhubDataConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface KustoEventhubDataConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#create KustoEventhubDataConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#delete KustoEventhubDataConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#read KustoEventhubDataConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html#update KustoEventhubDataConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoEventhubDataConnectionTimeoutsToTerraform(struct?: KustoEventhubDataConnectionTimeoutsOutputReference | KustoEventhubDataConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoEventhubDataConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoEventhubDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoEventhubDataConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html azurerm_kusto_eventhub_data_connection}.
 *
 * @stability stable
 */
export declare class KustoEventhubDataConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventhub_data_connection.html azurerm_kusto_eventhub_data_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoEventhubDataConnectionConfig);
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _compression?;
    /**
     * @stability stable
     */
    get compression(): string;
    /**
     * @stability stable
     */
    set compression(value: string);
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): string | undefined;
    private _consumerGroup?;
    /**
     * @stability stable
     */
    get consumerGroup(): string;
    /**
     * @stability stable
     */
    set consumerGroup(value: string);
    /**
     * @stability stable
     */
    get consumerGroupInput(): string | undefined;
    private _dataFormat?;
    /**
     * @stability stable
     */
    get dataFormat(): string;
    /**
     * @stability stable
     */
    set dataFormat(value: string);
    /**
     * @stability stable
     */
    resetDataFormat(): void;
    /**
     * @stability stable
     */
    get dataFormatInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _eventSystemProperties?;
    /**
     * @stability stable
     */
    get eventSystemProperties(): string[];
    /**
     * @stability stable
     */
    set eventSystemProperties(value: string[]);
    /**
     * @stability stable
     */
    resetEventSystemProperties(): void;
    /**
     * @stability stable
     */
    get eventSystemPropertiesInput(): string[] | undefined;
    private _eventhubId?;
    /**
     * @stability stable
     */
    get eventhubId(): string;
    /**
     * @stability stable
     */
    set eventhubId(value: string);
    /**
     * @stability stable
     */
    get eventhubIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _identityId?;
    /**
     * @stability stable
     */
    get identityId(): string;
    /**
     * @stability stable
     */
    set identityId(value: string);
    /**
     * @stability stable
     */
    resetIdentityId(): void;
    /**
     * @stability stable
     */
    get identityIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _mappingRuleName?;
    /**
     * @stability stable
     */
    get mappingRuleName(): string;
    /**
     * @stability stable
     */
    set mappingRuleName(value: string);
    /**
     * @stability stable
     */
    resetMappingRuleName(): void;
    /**
     * @stability stable
     */
    get mappingRuleNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tableName?;
    /**
     * @stability stable
     */
    get tableName(): string;
    /**
     * @stability stable
     */
    set tableName(value: string);
    /**
     * @stability stable
     */
    resetTableName(): void;
    /**
     * @stability stable
     */
    get tableNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoEventhubDataConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoEventhubDataConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoEventhubDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
