import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorMetricAlertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#auto_mitigate MonitorMetricAlert#auto_mitigate}.
     *
     * @stability stable
     */
    readonly autoMitigate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#description MonitorMetricAlert#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#enabled MonitorMetricAlert#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#frequency MonitorMetricAlert#frequency}.
     *
     * @stability stable
     */
    readonly frequency?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#name MonitorMetricAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#resource_group_name MonitorMetricAlert#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#scopes MonitorMetricAlert#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#severity MonitorMetricAlert#severity}.
     *
     * @stability stable
     */
    readonly severity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#tags MonitorMetricAlert#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The location of the target pluginsdk. Required when using subscription, resource group scope or multiple scopes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#target_resource_location MonitorMetricAlert#target_resource_location}
     *
     * @stability stable
     */
    readonly targetResourceLocation?: string;
    /**
     * The resource type (e.g. Microsoft.Compute/virtualMachines) of the target pluginsdk. Required when using subscription, resource group scope or multiple scopes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#target_resource_type MonitorMetricAlert#target_resource_type}
     *
     * @stability stable
     */
    readonly targetResourceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#window_size MonitorMetricAlert#window_size}.
     *
     * @stability stable
     */
    readonly windowSize?: string;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#action MonitorMetricAlert#action}
     *
     * @stability stable
     */
    readonly action?: MonitorMetricAlertAction[];
    /**
     * application_insights_web_test_location_availability_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#application_insights_web_test_location_availability_criteria MonitorMetricAlert#application_insights_web_test_location_availability_criteria}
     *
     * @stability stable
     */
    readonly applicationInsightsWebTestLocationAvailabilityCriteria?: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria;
    /**
     * criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#criteria MonitorMetricAlert#criteria}
     *
     * @stability stable
     */
    readonly criteria?: MonitorMetricAlertCriteria[];
    /**
     * dynamic_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#dynamic_criteria MonitorMetricAlert#dynamic_criteria}
     *
     * @stability stable
     */
    readonly dynamicCriteria?: MonitorMetricAlertDynamicCriteria;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#timeouts MonitorMetricAlert#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorMetricAlertTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorMetricAlertAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#action_group_id MonitorMetricAlert#action_group_id}.
     *
     * @stability stable
     */
    readonly actionGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#webhook_properties MonitorMetricAlert#webhook_properties}.
     *
     * @stability stable
     */
    readonly webhookProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function monitorMetricAlertActionToTerraform(struct?: MonitorMetricAlertAction): any;
/**
 * @stability stable
 */
export interface MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#component_id MonitorMetricAlert#component_id}.
     *
     * @stability stable
     */
    readonly componentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#failed_location_count MonitorMetricAlert#failed_location_count}.
     *
     * @stability stable
     */
    readonly failedLocationCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#web_test_id MonitorMetricAlert#web_test_id}.
     *
     * @stability stable
     */
    readonly webTestId: string;
}
export declare function monitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaToTerraform(struct?: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference | MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria): any;
/**
 * @stability stable
 */
export declare class MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined);
    private _componentId?;
    /**
     * @stability stable
     */
    get componentId(): string;
    /**
     * @stability stable
     */
    set componentId(value: string);
    /**
     * @stability stable
     */
    get componentIdInput(): string | undefined;
    private _failedLocationCount?;
    /**
     * @stability stable
     */
    get failedLocationCount(): number;
    /**
     * @stability stable
     */
    set failedLocationCount(value: number);
    /**
     * @stability stable
     */
    get failedLocationCountInput(): number | undefined;
    private _webTestId?;
    /**
     * @stability stable
     */
    get webTestId(): string;
    /**
     * @stability stable
     */
    set webTestId(value: string);
    /**
     * @stability stable
     */
    get webTestIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorMetricAlertCriteriaDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#name MonitorMetricAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#operator MonitorMetricAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#values MonitorMetricAlert#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorMetricAlertCriteriaDimensionToTerraform(struct?: MonitorMetricAlertCriteriaDimension): any;
/**
 * @stability stable
 */
export interface MonitorMetricAlertCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#aggregation MonitorMetricAlert#aggregation}.
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#metric_name MonitorMetricAlert#metric_name}.
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#metric_namespace MonitorMetricAlert#metric_namespace}.
     *
     * @stability stable
     */
    readonly metricNamespace: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#operator MonitorMetricAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#skip_metric_validation MonitorMetricAlert#skip_metric_validation}.
     *
     * @stability stable
     */
    readonly skipMetricValidation?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#threshold MonitorMetricAlert#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#dimension MonitorMetricAlert#dimension}
     *
     * @stability stable
     */
    readonly dimension?: MonitorMetricAlertCriteriaDimension[];
}
export declare function monitorMetricAlertCriteriaToTerraform(struct?: MonitorMetricAlertCriteria): any;
/**
 * @stability stable
 */
export interface MonitorMetricAlertDynamicCriteriaDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#name MonitorMetricAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#operator MonitorMetricAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#values MonitorMetricAlert#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorMetricAlertDynamicCriteriaDimensionToTerraform(struct?: MonitorMetricAlertDynamicCriteriaDimension): any;
/**
 * @stability stable
 */
export interface MonitorMetricAlertDynamicCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#aggregation MonitorMetricAlert#aggregation}.
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#alert_sensitivity MonitorMetricAlert#alert_sensitivity}.
     *
     * @stability stable
     */
    readonly alertSensitivity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#evaluation_failure_count MonitorMetricAlert#evaluation_failure_count}.
     *
     * @stability stable
     */
    readonly evaluationFailureCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#evaluation_total_count MonitorMetricAlert#evaluation_total_count}.
     *
     * @stability stable
     */
    readonly evaluationTotalCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#ignore_data_before MonitorMetricAlert#ignore_data_before}.
     *
     * @stability stable
     */
    readonly ignoreDataBefore?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#metric_name MonitorMetricAlert#metric_name}.
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#metric_namespace MonitorMetricAlert#metric_namespace}.
     *
     * @stability stable
     */
    readonly metricNamespace: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#operator MonitorMetricAlert#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#skip_metric_validation MonitorMetricAlert#skip_metric_validation}.
     *
     * @stability stable
     */
    readonly skipMetricValidation?: boolean | cdktf.IResolvable;
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#dimension MonitorMetricAlert#dimension}
     *
     * @stability stable
     */
    readonly dimension?: MonitorMetricAlertDynamicCriteriaDimension[];
}
export declare function monitorMetricAlertDynamicCriteriaToTerraform(struct?: MonitorMetricAlertDynamicCriteriaOutputReference | MonitorMetricAlertDynamicCriteria): any;
/**
 * @stability stable
 */
export declare class MonitorMetricAlertDynamicCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorMetricAlertDynamicCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorMetricAlertDynamicCriteria | undefined);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _alertSensitivity?;
    /**
     * @stability stable
     */
    get alertSensitivity(): string;
    /**
     * @stability stable
     */
    set alertSensitivity(value: string);
    /**
     * @stability stable
     */
    get alertSensitivityInput(): string | undefined;
    private _evaluationFailureCount?;
    /**
     * @stability stable
     */
    get evaluationFailureCount(): number;
    /**
     * @stability stable
     */
    set evaluationFailureCount(value: number);
    /**
     * @stability stable
     */
    resetEvaluationFailureCount(): void;
    /**
     * @stability stable
     */
    get evaluationFailureCountInput(): number | undefined;
    private _evaluationTotalCount?;
    /**
     * @stability stable
     */
    get evaluationTotalCount(): number;
    /**
     * @stability stable
     */
    set evaluationTotalCount(value: number);
    /**
     * @stability stable
     */
    resetEvaluationTotalCount(): void;
    /**
     * @stability stable
     */
    get evaluationTotalCountInput(): number | undefined;
    private _ignoreDataBefore?;
    /**
     * @stability stable
     */
    get ignoreDataBefore(): string;
    /**
     * @stability stable
     */
    set ignoreDataBefore(value: string);
    /**
     * @stability stable
     */
    resetIgnoreDataBefore(): void;
    /**
     * @stability stable
     */
    get ignoreDataBeforeInput(): string | undefined;
    private _metricName?;
    /**
     * @stability stable
     */
    get metricName(): string;
    /**
     * @stability stable
     */
    set metricName(value: string);
    /**
     * @stability stable
     */
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    /**
     * @stability stable
     */
    get metricNamespace(): string;
    /**
     * @stability stable
     */
    set metricNamespace(value: string);
    /**
     * @stability stable
     */
    get metricNamespaceInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _skipMetricValidation?;
    /**
     * @stability stable
     */
    get skipMetricValidation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipMetricValidation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipMetricValidation(): void;
    /**
     * @stability stable
     */
    get skipMetricValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _dimension?;
    /**
     * @stability stable
     */
    get dimension(): MonitorMetricAlertDynamicCriteriaDimension[];
    /**
     * @stability stable
     */
    set dimension(value: MonitorMetricAlertDynamicCriteriaDimension[]);
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): MonitorMetricAlertDynamicCriteriaDimension[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorMetricAlertTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#create MonitorMetricAlert#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#delete MonitorMetricAlert#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#read MonitorMetricAlert#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html#update MonitorMetricAlert#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorMetricAlertTimeoutsToTerraform(struct?: MonitorMetricAlertTimeoutsOutputReference | MonitorMetricAlertTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorMetricAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorMetricAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorMetricAlertTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html azurerm_monitor_metric_alert}.
 *
 * @stability stable
 */
export declare class MonitorMetricAlert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_metric_alert.html azurerm_monitor_metric_alert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorMetricAlertConfig);
    private _autoMitigate?;
    /**
     * @stability stable
     */
    get autoMitigate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoMitigate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoMitigate(): void;
    /**
     * @stability stable
     */
    get autoMitigateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    resetFrequency(): void;
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _severity?;
    /**
     * @stability stable
     */
    get severity(): number;
    /**
     * @stability stable
     */
    set severity(value: number);
    /**
     * @stability stable
     */
    resetSeverity(): void;
    /**
     * @stability stable
     */
    get severityInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _targetResourceLocation?;
    /**
     * @stability stable
     */
    get targetResourceLocation(): string;
    /**
     * @stability stable
     */
    set targetResourceLocation(value: string);
    /**
     * @stability stable
     */
    resetTargetResourceLocation(): void;
    /**
     * @stability stable
     */
    get targetResourceLocationInput(): string | undefined;
    private _targetResourceType?;
    /**
     * @stability stable
     */
    get targetResourceType(): string;
    /**
     * @stability stable
     */
    set targetResourceType(value: string);
    /**
     * @stability stable
     */
    resetTargetResourceType(): void;
    /**
     * @stability stable
     */
    get targetResourceTypeInput(): string | undefined;
    private _windowSize?;
    /**
     * @stability stable
     */
    get windowSize(): string;
    /**
     * @stability stable
     */
    set windowSize(value: string);
    /**
     * @stability stable
     */
    resetWindowSize(): void;
    /**
     * @stability stable
     */
    get windowSizeInput(): string | undefined;
    private _action?;
    /**
     * @stability stable
     */
    get action(): MonitorMetricAlertAction[];
    /**
     * @stability stable
     */
    set action(value: MonitorMetricAlertAction[]);
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): MonitorMetricAlertAction[] | undefined;
    private _applicationInsightsWebTestLocationAvailabilityCriteria;
    /**
     * @stability stable
     */
    get applicationInsightsWebTestLocationAvailabilityCriteria(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaOutputReference;
    /**
     * @stability stable
     */
    putApplicationInsightsWebTestLocationAvailabilityCriteria(value: MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria): void;
    /**
     * @stability stable
     */
    resetApplicationInsightsWebTestLocationAvailabilityCriteria(): void;
    /**
     * @stability stable
     */
    get applicationInsightsWebTestLocationAvailabilityCriteriaInput(): MonitorMetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria | undefined;
    private _criteria?;
    /**
     * @stability stable
     */
    get criteria(): MonitorMetricAlertCriteria[];
    /**
     * @stability stable
     */
    set criteria(value: MonitorMetricAlertCriteria[]);
    /**
     * @stability stable
     */
    resetCriteria(): void;
    /**
     * @stability stable
     */
    get criteriaInput(): MonitorMetricAlertCriteria[] | undefined;
    private _dynamicCriteria;
    /**
     * @stability stable
     */
    get dynamicCriteria(): MonitorMetricAlertDynamicCriteriaOutputReference;
    /**
     * @stability stable
     */
    putDynamicCriteria(value: MonitorMetricAlertDynamicCriteria): void;
    /**
     * @stability stable
     */
    resetDynamicCriteria(): void;
    /**
     * @stability stable
     */
    get dynamicCriteriaInput(): MonitorMetricAlertDynamicCriteria | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorMetricAlertTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorMetricAlertTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorMetricAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
