import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#backend_address_pool_id NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#backend_address_pool_id}.
     *
     * @stability stable
     */
    readonly backendAddressPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#ip_configuration_name NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#ip_configuration_name}.
     *
     * @stability stable
     */
    readonly ipConfigurationName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#network_interface_id NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#network_interface_id}.
     *
     * @stability stable
     */
    readonly networkInterfaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#timeouts NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#create NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#delete NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#read NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html#update NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeoutsToTerraform(struct?: NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeoutsOutputReference | NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html azurerm_network_interface_application_gateway_backend_address_pool_association}.
 *
 * @stability stable
 */
export declare class NetworkInterfaceApplicationGatewayBackendAddressPoolAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_gateway_backend_address_pool_association.html azurerm_network_interface_application_gateway_backend_address_pool_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationConfig);
    private _backendAddressPoolId?;
    /**
     * @stability stable
     */
    get backendAddressPoolId(): string;
    /**
     * @stability stable
     */
    set backendAddressPoolId(value: string);
    /**
     * @stability stable
     */
    get backendAddressPoolIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipConfigurationName?;
    /**
     * @stability stable
     */
    get ipConfigurationName(): string;
    /**
     * @stability stable
     */
    set ipConfigurationName(value: string);
    /**
     * @stability stable
     */
    get ipConfigurationNameInput(): string | undefined;
    private _networkInterfaceId?;
    /**
     * @stability stable
     */
    get networkInterfaceId(): string;
    /**
     * @stability stable
     */
    set networkInterfaceId(value: string);
    /**
     * @stability stable
     */
    get networkInterfaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkInterfaceApplicationGatewayBackendAddressPoolAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
