import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudAppCosmosdbAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#api_type SpringCloudAppCosmosdbAssociation#api_type}.
     *
     * @stability stable
     */
    readonly apiType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_access_key SpringCloudAppCosmosdbAssociation#cosmosdb_access_key}.
     *
     * @stability stable
     */
    readonly cosmosdbAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_account_id SpringCloudAppCosmosdbAssociation#cosmosdb_account_id}.
     *
     * @stability stable
     */
    readonly cosmosdbAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_cassandra_keyspace_name SpringCloudAppCosmosdbAssociation#cosmosdb_cassandra_keyspace_name}.
     *
     * @stability stable
     */
    readonly cosmosdbCassandraKeyspaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_gremlin_database_name SpringCloudAppCosmosdbAssociation#cosmosdb_gremlin_database_name}.
     *
     * @stability stable
     */
    readonly cosmosdbGremlinDatabaseName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_gremlin_graph_name SpringCloudAppCosmosdbAssociation#cosmosdb_gremlin_graph_name}.
     *
     * @stability stable
     */
    readonly cosmosdbGremlinGraphName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_mongo_database_name SpringCloudAppCosmosdbAssociation#cosmosdb_mongo_database_name}.
     *
     * @stability stable
     */
    readonly cosmosdbMongoDatabaseName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#cosmosdb_sql_database_name SpringCloudAppCosmosdbAssociation#cosmosdb_sql_database_name}.
     *
     * @stability stable
     */
    readonly cosmosdbSqlDatabaseName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#name SpringCloudAppCosmosdbAssociation#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#spring_cloud_app_id SpringCloudAppCosmosdbAssociation#spring_cloud_app_id}.
     *
     * @stability stable
     */
    readonly springCloudAppId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#timeouts SpringCloudAppCosmosdbAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudAppCosmosdbAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface SpringCloudAppCosmosdbAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#create SpringCloudAppCosmosdbAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#delete SpringCloudAppCosmosdbAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#read SpringCloudAppCosmosdbAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html#update SpringCloudAppCosmosdbAssociation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function springCloudAppCosmosdbAssociationTimeoutsToTerraform(struct?: SpringCloudAppCosmosdbAssociationTimeoutsOutputReference | SpringCloudAppCosmosdbAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class SpringCloudAppCosmosdbAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudAppCosmosdbAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudAppCosmosdbAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html azurerm_spring_cloud_app_cosmosdb_association}.
 *
 * @stability stable
 */
export declare class SpringCloudAppCosmosdbAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_app_cosmosdb_association.html azurerm_spring_cloud_app_cosmosdb_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudAppCosmosdbAssociationConfig);
    private _apiType?;
    /**
     * @stability stable
     */
    get apiType(): string;
    /**
     * @stability stable
     */
    set apiType(value: string);
    /**
     * @stability stable
     */
    get apiTypeInput(): string | undefined;
    private _cosmosdbAccessKey?;
    /**
     * @stability stable
     */
    get cosmosdbAccessKey(): string;
    /**
     * @stability stable
     */
    set cosmosdbAccessKey(value: string);
    /**
     * @stability stable
     */
    get cosmosdbAccessKeyInput(): string | undefined;
    private _cosmosdbAccountId?;
    /**
     * @stability stable
     */
    get cosmosdbAccountId(): string;
    /**
     * @stability stable
     */
    set cosmosdbAccountId(value: string);
    /**
     * @stability stable
     */
    get cosmosdbAccountIdInput(): string | undefined;
    private _cosmosdbCassandraKeyspaceName?;
    /**
     * @stability stable
     */
    get cosmosdbCassandraKeyspaceName(): string;
    /**
     * @stability stable
     */
    set cosmosdbCassandraKeyspaceName(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbCassandraKeyspaceName(): void;
    /**
     * @stability stable
     */
    get cosmosdbCassandraKeyspaceNameInput(): string | undefined;
    private _cosmosdbGremlinDatabaseName?;
    /**
     * @stability stable
     */
    get cosmosdbGremlinDatabaseName(): string;
    /**
     * @stability stable
     */
    set cosmosdbGremlinDatabaseName(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbGremlinDatabaseName(): void;
    /**
     * @stability stable
     */
    get cosmosdbGremlinDatabaseNameInput(): string | undefined;
    private _cosmosdbGremlinGraphName?;
    /**
     * @stability stable
     */
    get cosmosdbGremlinGraphName(): string;
    /**
     * @stability stable
     */
    set cosmosdbGremlinGraphName(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbGremlinGraphName(): void;
    /**
     * @stability stable
     */
    get cosmosdbGremlinGraphNameInput(): string | undefined;
    private _cosmosdbMongoDatabaseName?;
    /**
     * @stability stable
     */
    get cosmosdbMongoDatabaseName(): string;
    /**
     * @stability stable
     */
    set cosmosdbMongoDatabaseName(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbMongoDatabaseName(): void;
    /**
     * @stability stable
     */
    get cosmosdbMongoDatabaseNameInput(): string | undefined;
    private _cosmosdbSqlDatabaseName?;
    /**
     * @stability stable
     */
    get cosmosdbSqlDatabaseName(): string;
    /**
     * @stability stable
     */
    set cosmosdbSqlDatabaseName(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbSqlDatabaseName(): void;
    /**
     * @stability stable
     */
    get cosmosdbSqlDatabaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _springCloudAppId?;
    /**
     * @stability stable
     */
    get springCloudAppId(): string;
    /**
     * @stability stable
     */
    set springCloudAppId(value: string);
    /**
     * @stability stable
     */
    get springCloudAppIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudAppCosmosdbAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudAppCosmosdbAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudAppCosmosdbAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
